/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.AllocTable;

class AllocEntry {
    static final int BLOCK_COUNT_INCREASE = 32;
    private int totalBlocks;
    private int[] blockIds = new int[32];

    AllocEntry(int blockId) {
        this.blockIds[0] = blockId;
        this.totalBlocks = 1;
    }

    void refresh(AllocTable tbl) throws IOException {
        int lastBlockId = this.getLastBlock();
        int blockId = tbl.readFATInt(lastBlockId * 4);
        while (blockId != -1) {
            this.ensureBlocks(this.totalBlocks + 1);
            this.blockIds[this.totalBlocks] = blockId;
            ++this.totalBlocks;
            blockId = tbl.readFATInt(blockId * 4);
        }
    }

    void flush(AllocTable tbl) throws IOException {
        int i = 1;
        while (i < this.totalBlocks) {
            tbl.writeFATInt(this.blockIds[i - 1] * 4, this.blockIds[i]);
            ++i;
        }
        tbl.writeFATInt(this.blockIds[this.totalBlocks - 1] * 4, -1);
    }

    private void ensureBlocks(int size) {
        if (this.blockIds == null || this.blockIds.length < size) {
            size = size / 32 * 32 + 32;
            int[] blocks = new int[size];
            if (this.blockIds != null) {
                System.arraycopy(this.blockIds, 0, blocks, 0, this.totalBlocks);
            }
            this.blockIds = blocks;
        }
    }

    int getTotalBlocks() {
        return this.totalBlocks;
    }

    int getFirstBlock() {
        return this.blockIds[0];
    }

    int getLastBlock() {
        return this.blockIds[this.totalBlocks - 1];
    }

    int getBlock(int index) {
        if (index < this.totalBlocks) {
            return this.blockIds[index];
        }
        return -1;
    }

    void appendBlock(int blockId) {
        this.ensureBlocks(this.totalBlocks + 1);
        this.blockIds[this.totalBlocks] = blockId;
        ++this.totalBlocks;
    }
}

