/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.metadata.impl;

import java.lang.reflect.Method;
import org.apache.muse.core.AbstractCapability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.metadata.MetadataExchange;
import org.apache.muse.ws.metadata.impl.GetMetadataHandler;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleMetadataExchange
extends AbstractCapability
implements MetadataExchange {
    private static final Element[] _NOT_FOUND = new Element[0];

    protected MessageHandler createGetMetadataHandler() {
        GetMetadataHandler handler = new GetMetadataHandler();
        try {
            Method method = ReflectUtils.getFirstMethod(((Object)((Object)this)).getClass(), (String)"getMetadata");
            handler.setMethod(method);
        }
        catch (Throwable error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        return handler;
    }

    public Element[] getMetadata(String dialect) {
        Element metadata = null;
        if (dialect == null) {
            return _NOT_FOUND;
        }
        if (dialect.equals("http://schemas.xmlsoap.org/wsdl/")) {
            metadata = this.getWSDL();
        }
        if (metadata == null) {
            return _NOT_FOUND;
        }
        return new Element[]{metadata};
    }

    protected Element getWSDL() {
        Resource owner = this.getResource();
        Environment env = owner.getEnvironment();
        String path = owner.getWsdlPath();
        Document wsdlDoc = WsdlUtils.createWSDL((Environment)env, (String)path, (boolean)true);
        Element wsdl = XmlUtils.getFirstElement((Node)wsdlDoc);
        WsdlUtils.removeWsdlReferences((Element)wsdl);
        WsdlUtils.removeSchemaReferences((Element)wsdl);
        return wsdl;
    }

    public void initialize() throws SoapFault {
        super.initialize();
        this.setMessageHandler(this.createGetMetadataHandler());
    }
}

