/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.ws.dm.muws.impl.AbstractManageabilityCapability;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.basefaults.WsbfUtils;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagementProxy;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.DynamicInvocationHandler;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDMBinding;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMAttributeInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.w3c.dom.Element;

public class DynamicCapability
extends AbstractManageabilityCapability {
    private WSDMInfo info;
    private QName[] properties = new QName[0];
    private HashMap<QName, Method> getterMap = new HashMap();
    private HashMap<QName, Method> setterMap = new HashMap();

    public QName[] getPropertyNames() {
        return this.properties;
    }

    protected void createGettersAndSetters(QName propertyName) {
    }

    protected Method getGetter(QName propertyQName) {
        return this.getterMap.get(propertyQName);
    }

    protected Method getSetter(QName propertyQName) {
        return this.setterMap.get(propertyQName);
    }

    public DynamicCapability(WSDMInfo info, String namespace, String prefix) {
        WSDMOperationInfo[] operations;
        int n;
        this.info = info;
        int propertiesLength = info.getAttributes().length;
        if (info.getResourceIdField() != null) {
            --propertiesLength;
        }
        if (propertiesLength > 0) {
            this.properties = new QName[propertiesLength];
            propertiesLength = 0;
            int i = 0;
            WSDMAttributeInfo[] wSDMAttributeInfoArray = (WSDMAttributeInfo[])info.getAttributes();
            n = wSDMAttributeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                WSDMAttributeInfo attr = wSDMAttributeInfoArray[n2];
                if (!attr.isResourceID()) {
                    String ns = attr.getNamespace();
                    if ("".equals(ns)) {
                        ns = info.getTargetNamespace();
                    }
                    if (ns.equals(namespace)) {
                        QName propName = new QName(namespace, attr.getName(), prefix);
                        this.getterMap.put(propName, attr.getGetter());
                        if (attr.getSetter() != null) {
                            this.setterMap.put(propName, attr.getSetter());
                        }
                        this.properties[i++] = propName;
                        propertiesLength = i;
                    }
                }
                ++n2;
            }
        }
        QName[] actualProps = new QName[propertiesLength];
        int i = 0;
        while (i < propertiesLength) {
            actualProps[i] = this.properties[i];
            ++i;
        }
        this.properties = actualProps;
        WSDMOperationInfo[] wSDMOperationInfoArray = operations = (WSDMOperationInfo[])info.getOperations();
        int n3 = operations.length;
        n = 0;
        while (n < n3) {
            WSDMOperationInfo operation = wSDMOperationInfoArray[n];
            if (operation.getNamespace().equals(namespace)) {
                String actionURI = String.valueOf(namespace) + "/" + operation.getName();
                QName inputName = new QName(namespace, String.valueOf(operation.getName()) + "RequestType", "dyn");
                QName outputName = new QName(namespace, String.valueOf(operation.getName()) + "ResponseType", "dyn");
                DynamicInvocationHandler handler = new DynamicInvocationHandler(actionURI, inputName, outputName);
                handler.setMethod(operation.getOperationMethod());
                this.setMessageHandler((MessageHandler)handler);
            }
            ++n;
        }
    }

    public Element[] getProperty(QName propertyQName) throws BaseFault {
        Method method = this.getterMap.get(propertyQName);
        Object result = this.invokeMethod(method, null);
        return this.getPropertyElements(propertyQName, result);
    }

    protected Object invokeMethod(Method method, Object[] params) throws BaseFault {
        Object result = null;
        try {
            Object target = this.getWsResource();
            target.getClass();
            if (this.getWsResource() instanceof WSDMBinding) {
                WSDMBinding binding = (WSDMBinding)this.getWsResource();
                target = binding.getResource();
                target.getClass();
                if (target instanceof ManagementProxy) {
                    Method proxyMethod = ((ManagementProxy)target).getProxiedMethod(method);
                    if (proxyMethod == null || proxyMethod == method) {
                        target = ((ManagementProxy)target).getProxiedObject();
                    } else {
                        method = proxyMethod;
                    }
                }
            }
            result = method.invoke(target, params);
        }
        catch (Throwable error) {
            Throwable cause = error.getCause();
            if (cause != null) {
                error = cause;
            }
            throw WsbfUtils.convertToFault((Throwable)error);
        }
        return result;
    }

    public Object invokeCustomMethod(Method method, Object[] params) throws BaseFault {
        Object result = null;
        try {
            Object target = this.getWsResource();
            target.getClass();
            if (this.getWsResource() instanceof WSDMBinding) {
                WSDMBinding binding = (WSDMBinding)this.getWsResource();
                target = binding.getResource();
                target.getClass();
                if (target instanceof ManagementProxy) {
                    Method proxyMethod = ((ManagementProxy)target).getProxiedMethod(method);
                    if (proxyMethod == null || proxyMethod == method) {
                        target = ((ManagementProxy)target).getProxiedObject();
                    } else {
                        method = proxyMethod;
                    }
                }
            }
            System.out.println(method.getDeclaringClass() + " " + target.getClass());
            result = method.invoke(target, params);
        }
        catch (Throwable error) {
            Throwable cause = error.getCause();
            error.printStackTrace();
            if (cause != null) {
                error = cause;
            }
            throw WsbfUtils.convertToFault((Throwable)error);
        }
        return result;
    }
}

