/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.logging.datamgr.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.dataManager.client.DataManagerClient;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.logging.datamgr.api.ICBEClient;
import org.eclipse.cosmos.dc.logging.datamgr.api.ILogEventCollector;
import org.eclipse.cosmos.dc.logging.datamgr.client.CBEImpl;
import org.eclipse.cosmos.dc.logging.datamgr.client.CBESImpl;
import org.eclipse.cosmos.dc.logging.datamgr.common.CBESeverityCount;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.tptp.logging.events.cbe.Situation;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingDataManagerClient
extends DataManagerClient
implements ILogEventCollector,
ICBEClient {
    public LoggingDataManagerClient() {
        super(null);
    }

    public LoggingDataManagerClient(EndpointReference epr) {
        super(epr);
    }

    @Override
    public Collection<String> getDatasets() throws CosmosException {
        String[] ret = null;
        Vector<String> v = null;
        int i = 0;
        ret = this.getLogFileIdentifiers();
        v = new Vector<String>();
        i = 0;
        while (i < ret.length) {
            v.add(ret[i]);
            ++i;
        }
        return v;
    }

    @Override
    public Collection<CommonBaseEvent> getAllCBE(String logfile) throws CosmosException {
        Collection<CommonBaseEvent> ret = null;
        Element e = null;
        e = this.getCBEs(logfile);
        ret = this.ProcessCBEs(e);
        return ret;
    }

    @Override
    public Collection<CBESeverityCount> getCBECountBySeverity(String logfile) throws CosmosException {
        Collection<CommonBaseEvent> cbe = null;
        Element e = null;
        Iterator<CommonBaseEvent> cbeI = null;
        CommonBaseEvent ev2 = null;
        String cname = null;
        CBESeverityCount sc = null;
        e = this.getCBEs(logfile);
        HashMap<String, CBESeverityCount> componentMap = new HashMap<String, CBESeverityCount>();
        cbe = this.ProcessCBEs(e);
        for (CommonBaseEvent ev2 : cbe) {
            cname = ev2.getSourceComponentId().getComponent();
            sc = (CBESeverityCount)componentMap.get(cname);
            if (sc == null) {
                sc = new CBESeverityCount(cname);
                componentMap.put(cname, sc);
            }
            if (ev2.getSeverity() >= 50) {
                sc.setSevereCount(sc.getSevereCount() + 1);
                continue;
            }
            if (ev2.getSeverity() >= 30) {
                sc.setWarningCount(sc.getWarningCount() + 1);
                continue;
            }
            sc.setInfoCount(sc.getInfoCount() + 1);
        }
        return componentMap.values();
    }

    @Override
    public Element getCBEs(String logfile) throws CosmosException {
        QName q = ILogEventCollector.GET_ALL_CBE_OP_QNAME;
        String op = "http://www.eclipse.org/cosmos/logEventCollector/getCBEs";
        Element e = null;
        String[] ret = null;
        QName gq = new QName("http://www.eclipse.org/cosmos/logEventCollector", "logfile", "cbe");
        e = XmlUtils.createElement((QName)gq);
        e.setTextContent(logfile);
        try {
            e = this.SendRequest(op, q, e);
        }
        catch (DataManagerException ex) {
            throw new CosmosException("Problem sending request", (Throwable)ex);
        }
        return e;
    }

    @Override
    public String[] getCBESeverityCount(String logfile) throws CosmosException {
        return null;
    }

    @Override
    public String[] getLogFileIdentifiers() throws CosmosException {
        QName q = ILogEventCollector.GET_LOG_ID_OP_QNAME;
        String op = "http://www.eclipse.org/cosmos/logEventCollector/getLogFileIdentifiers";
        Element e = null;
        String[] ret = null;
        try {
            e = this.SendRequest(op, q, null);
        }
        catch (DataManagerException ex) {
            throw new CosmosException("Problem sending request", (Throwable)ex);
        }
        ret = this.ProcessLF(e);
        return ret;
    }

    private Element SendRequest(String operation, QName qstr, Element arg) throws DataManagerException {
        Element soapBody = XmlUtils.createElement((QName)qstr);
        if (arg != null) {
            Element parm = XmlUtils.createElement((QName)ILogEventCollector.GET_ALL_CBE_LOG_FILE_QNAME);
            parm.appendChild(arg);
            soapBody.appendChild(arg);
        }
        try {
            Element results = this.invoke(operation, soapBody);
            return results;
        }
        catch (SoapFault e) {
            throw new DataManagerException((Throwable)e);
        }
    }

    private String[] ProcessLF(Element e) {
        NodeList n = null;
        Element el = null;
        int i = 0;
        String s = null;
        Object r = null;
        String[] p = null;
        String[] ret = null;
        int idx = 0;
        n = e.getElementsByTagName("dyn:getLogFileIdentifiersResponseType");
        if (n.getLength() > 0) {
            p = new String[n.getLength()];
        }
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1 && (s = XmlUtils.extractText((Element)(el = (Element)n.item(i)))).length() > 0) {
                p[idx++] = new String(s);
            }
            ++i;
        }
        ret = new String[idx];
        i = 0;
        while (i < idx) {
            ret[i] = new String(p[i]);
            ++i;
        }
        return ret;
    }

    private String[] ProcessAllCBE(Element e) {
        NodeList n = null;
        Element el = null;
        int i = 0;
        String s = null;
        String r = null;
        String[] p = null;
        String[] ret = null;
        int idx = 0;
        n = e.getElementsByTagName("dyn:getLogFileIdentifiersResponseType");
        if (n.getLength() > 0) {
            p = new String[n.getLength()];
        }
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1 && (s = XmlUtils.extractText((Element)(el = (Element)n.item(i)))).length() > 0 && (r = this.Parse(s)) != null) {
                p[idx++] = new String(r);
            }
            ++i;
        }
        ret = new String[idx];
        i = 0;
        while (i < idx) {
            ret[i] = new String(p[i]);
            ++i;
        }
        return ret;
    }

    private String Parse(String s) {
        return s;
    }

    private Collection<CommonBaseEvent> ProcessCBEs(Element e) {
        NodeList n = null;
        Element el = null;
        int i = 0;
        CommonBaseEvent cbe = null;
        Vector<CommonBaseEvent> ret = null;
        ret = new Vector<CommonBaseEvent>();
        n = e.getElementsByTagName("CommonBaseEvent");
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1) {
                el = (Element)n.item(i);
                cbe = this.CreateCBE(el);
                ret.add(cbe);
            }
            ++i;
        }
        return ret;
    }

    private CommonBaseEvent CreateCBE(Element e) {
        CBEImpl c = null;
        c = new CBEImpl();
        this.PopulateBase(c, e);
        this.PopulateExtended(c, e);
        this.PopulateSourceComponent(c, e);
        this.PopulateSituation(c, e);
        return c;
    }

    private void PopulateBase(CBEImpl c, Element e) {
        short sh;
        String s;
        if (e.hasAttribute("creationTime")) {
            c.setCreationTime(e.getAttribute("creationTime"));
        }
        if (e.hasAttribute("globalInstanceId")) {
            c.setGlobalInstanceId(e.getAttribute("globalInstanceId"));
        }
        if (e.hasAttribute("extensionName")) {
            c.setExtensionName(e.getAttribute("extensionName"));
        }
        if (e.hasAttribute("localInstanceId")) {
            c.setLocalInstanceId(e.getAttribute("localInstanceId"));
        }
        if (e.hasAttribute("msg")) {
            c.setMsg(e.getAttribute("msg"));
        }
        if (e.hasAttribute("priority")) {
            s = e.getAttribute("priority");
            sh = Short.valueOf(s);
            c.setPriority(sh);
        }
        if (e.hasAttribute("repeatCount")) {
            s = e.getAttribute("repeatCount");
            sh = Short.valueOf(s);
            c.setRepeatCount(sh);
        }
        if (e.hasAttribute("sequenceNumber")) {
            s = e.getAttribute("sequenceNumber");
            long l = Long.valueOf(s);
            c.setSequenceNumber(l);
        }
        if (e.hasAttribute("severity")) {
            s = e.getAttribute("severity");
            short sh2 = Short.valueOf(s);
            c.setSeverity(sh2);
        }
    }

    private void PopulateSourceComponent(CBEImpl c, Element el) {
        NodeList n = null;
        Element e = null;
        String application = new String("");
        String component = new String("");
        String subComponent = new String("");
        String componentType = new String("");
        String componentIdType = new String("");
        String location = new String("");
        String locationType = new String("");
        n = el.getElementsByTagName("sourceComponentId");
        e = (Element)n.item(0);
        if (e.hasAttribute("application")) {
            application = e.getAttribute("application");
        }
        if (e.hasAttribute("component")) {
            component = e.getAttribute("component");
        }
        if (e.hasAttribute("subComponent")) {
            subComponent = e.getAttribute("subComponent");
        }
        if (e.hasAttribute("componentType")) {
            componentType = e.getAttribute("ComponentType");
        }
        if (e.hasAttribute("ComponentIdType")) {
            componentIdType = e.getAttribute("ComponentIdType");
        }
        if (e.hasAttribute("location")) {
            location = e.getAttribute("location");
        }
        if (e.hasAttribute("locationType")) {
            locationType = e.getAttribute("locationType");
        }
        c.setSourceComponentId(application, component, subComponent, componentType, componentIdType, location, locationType);
    }

    private void PopulateSituation(CBEImpl c, Element ele) {
        String success;
        String qualifier;
        String success2;
        NodeList ns = null;
        NodeList n = null;
        Element el = null;
        CBESImpl s = null;
        Element e = null;
        s = new CBESImpl();
        ns = ele.getElementsByTagName("situation");
        e = (Element)ns.item(0);
        String cat = e.getAttribute("categoryName");
        s.setCategoryName(cat);
        n = e.getElementsByTagName("situationType");
        el = (Element)n.item(0);
        String reason = el.getAttribute("reasoningScope");
        if (cat.equals("AvailableSituation")) {
            String available = el.getAttribute("availabilityDisposition");
            String operation = el.getAttribute("operationDisposition");
            String process = el.getAttribute("processingDisposition");
            s.setAvailableSituation(reason, available, operation, process);
        }
        if (cat.equals("ConfigureSituation")) {
            success2 = el.getAttribute("successDisposition");
            s.setConfigureSituation(reason, success2);
        }
        if (cat.equals("ConnectSituation")) {
            success2 = el.getAttribute("successDisposition");
            String situation = el.getAttribute("situationDisposition");
            s.setConnectSituation(reason, situation, success2);
        }
        if (cat.equals("CreateSituation")) {
            success2 = el.getAttribute("successDisposition");
            s.setCreateSituation(reason, success2);
        }
        if (cat.equals("DependencySituation")) {
            String depend = el.getAttribute("dependencyDisposition");
            s.setDependencySituation(reason, depend);
        }
        if (cat.equals("DestroySituation")) {
            success2 = el.getAttribute("successDisposition");
            s.setDestroySituation(reason, success2);
        }
        if (cat.equals("FeatureSituation")) {
            String feature = el.getAttribute("featureDisposition");
            s.setFeatureSituation(reason, feature);
        }
        if (cat.equals("OtherSituation")) {
            String any = el.getAttribute("any");
            s.setOtherSituation(reason, any);
        }
        if (cat.equals("ReportSituation")) {
            String rcat = el.getAttribute("ReportCategory");
            s.setReportSituation(reason, rcat);
        }
        if (cat.equals("RequestSituation")) {
            qualifier = el.getAttribute("situationQualifier");
            success = el.getAttribute("successDisposition");
            s.setRequestSituation(reason, qualifier, success);
        }
        if (cat.equals("StartSituation")) {
            qualifier = el.getAttribute("situationQualifier");
            success = el.getAttribute("successDisposition");
            s.setStartSituation(reason, qualifier, success);
        }
        if (cat.equals("StopSituation")) {
            qualifier = el.getAttribute("situationQualifier");
            success = el.getAttribute("successDisposition");
            s.setStopSituation(reason, qualifier, success);
        }
        c.setSituation((Situation)s);
    }

    private void PopulateExtended(CBEImpl c, Element e) {
        NodeList n = null;
        NodeList nv = null;
        Element el = null;
        Element v = null;
        int i = 0;
        String t = null;
        String name = null;
        n = e.getElementsByTagName("extendedDataElements");
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1) {
                el = (Element)n.item(i);
                t = el.getAttribute("type");
                name = el.getAttribute("name");
                if (!(t.equals("string") || t.equals("short") || t.equals("int"))) {
                    System.out.println("Unknown type" + t);
                } else {
                    nv = el.getElementsByTagName("values");
                    v = (Element)nv.item(0);
                    String value = XmlUtils.extractText((Element)v);
                    if (t.equals("short")) {
                        short svalue = Short.valueOf(value);
                        c.addExtendedDataElementWithShortValue(name, svalue);
                    } else if (t.equals("int")) {
                        int ivalue = Integer.valueOf(value);
                        c.addExtendedDataElementWithIntValue(name, ivalue);
                    } else {
                        c.addExtendedDataElement(name, value);
                    }
                }
            }
            ++i;
        }
    }
}

