/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

public class EventValidation {
    private static final Object LOCK = new Object();

    public static String getComponentName(EObject component, String name) {
        return EventValidation.getComponentName(component).concat(".").concat(new String(name));
    }

    public static String getComponentName(EObject component) {
        StringBuffer componentName = new StringBuffer();
        EObject parent = component;
        while (parent != null) {
            if (componentName.length() > 0) {
                componentName.insert(0, ".");
            }
            componentName.insert(0, parent.eClass().getName());
            parent = parent.eContainer();
        }
        return componentName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateRequiredProperties(String className, EObject elementInstance) throws ValidationException {
        EClass eClass = elementInstance.eClass();
        EList attrs = null;
        EList containments = null;
        Object object = LOCK;
        synchronized (object) {
            attrs = eClass.getEAllAttributes();
            containments = eClass.getEAllContainments();
        }
        int i = 0;
        while (i < attrs.size()) {
            EAttribute attr = (EAttribute)attrs.get(i);
            if (attr.isRequired() && !elementInstance.eIsSet((EStructuralFeature)attr)) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString((String)"LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", (Object)EventValidation.getComponentName(elementInstance, attr.getName())));
            }
            ++i;
        }
        i = 0;
        while (i < containments.size()) {
            EReference containement = (EReference)containments.get(i);
            if (containement.isRequired() && !elementInstance.eIsSet((EStructuralFeature)containement)) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString((String)"LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", (Object)EventValidation.getComponentName(elementInstance, containement.getName())));
            }
            ++i;
        }
    }

    public static void validateId(String classname, EObject o, EStructuralFeature att, String id) throws ValidationException {
        if (id != null) {
            if (id.length() < 32 || id.length() > 64) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", (Object)EventValidation.getComponentName(o, att.getName()), (Object)id));
            }
            if (!Character.isLetter(InternationalizationUtilities.charAt((String)id, (int)0))) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", (Object)EventValidation.getComponentName(o, att.getName()), (Object)id));
            }
        }
    }

    public static void validateId(String classname, EObject o, EStructuralFeature att) throws ValidationException {
        EventValidation.validateId(classname, o, att, (String)o.eGet(att));
    }

    public static void validateStringIdList(String classname, EObject o, EStructuralFeature att) throws ValidationException {
        String[] idSt = InternationalizationUtilities.tokenize((String)((String)o.eGet(att)), (String)" ");
        int counter = 0;
        while (counter < idSt.length) {
            EventValidation.validateId(classname, o, att, idSt[counter]);
            ++counter;
        }
    }

    public static void validateLength(String classname, EObject o, EStructuralFeature att, int minLength, int maxLength) throws ValidationException {
        String str = (String)o.eGet(att);
        if (str != null && (str.length() < minLength || str.length() > maxLength)) {
            if (minLength == 0) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)EventValidation.getComponentName(o, att.getName()), (Object)str, (Object)new Integer(str.length()), (Object)new Integer(maxLength)));
            }
            throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LENGTH_RANGE_EXC_", (Object)EventValidation.getComponentName(o, att.getName()), (Object)str, (Object)new Integer(str.length()), (Object)(String.valueOf(minLength) + " - " + maxLength)));
        }
    }

    public static void validateLength(String classname, EObject o, EStructuralFeature att, int maxLength) throws ValidationException {
        EventValidation.validateLength(classname, o, att, 0, maxLength);
    }

    public static void validateMutuallyExclusiveAttributes(String classname, EObject o, EStructuralFeature att1, EStructuralFeature att2) throws ValidationException {
        if (o.eGet(att1) == null && o.eGet(att2) == null || o.eGet(att1) != null && o.eGet(att2) != null) {
            throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_", (Object)EventValidation.getComponentName(o, att1.getName()), (Object)EventValidation.getComponentName(o, att2.getName())));
        }
    }

    public static void validateVersion(String classname, EObject o, EStructuralFeature att) throws ValidationException {
        String myStr = (String)o.eGet(att);
        if (myStr != null && !myStr.equals("1.0.1")) {
            throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_VERSION_EXC_", (Object)EventValidation.getComponentName(o, att.getName()), (Object)myStr));
        }
    }
}

