/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.dm.muws.Metric;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;

public class SimpleMetric
implements Metric {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$dm$muws$impl$SimpleMetric == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleMetric = SimpleMetric.class$("org.apache.muse.ws.dm.muws.impl.SimpleMetric")) : class$org$apache$muse$ws$dm$muws$impl$SimpleMetric));
    private int _changeType;
    private int _gatheringTime;
    private String _group = null;
    private boolean _hasBeenReset = false;
    private long _interval = -1L;
    private String _intervalString = null;
    private Date _lastUpdated = null;
    private QName _name = null;
    private Date _resetAt = null;
    private WsResource _resource = null;
    private int _timeScope;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleMetric;

    public SimpleMetric(QName name, WsResource resource) {
        if (name == null) {
            throw new NullPointerException(_MESSAGES.get("NullMetricName"));
        }
        if (resource == null) {
            throw new NullPointerException(_MESSAGES.get("NullResource"));
        }
        this._name = name;
        this._resource = resource;
        ResourcePropertyCollection props = this._resource.getPropertyCollection();
        MetadataDescriptor metadata = props.getMetadata();
        if (!metadata.isReadOnlyExternal(name)) {
            Object[] filler = new Object[]{name};
            throw new RuntimeException(_MESSAGES.get("NotReadOnly", filler));
        }
        String change = metadata.getExtendedMetadata(name, MuwsConstants.CHANGE_TYPE_QNAME);
        String gathering = metadata.getExtendedMetadata(name, MuwsConstants.GATHERING_QNAME);
        String time = metadata.getExtendedMetadata(name, MuwsConstants.TIME_SCOPE_QNAME);
        this._changeType = this.getChangeType(change);
        this._gatheringTime = this.getGatheringTime(gathering);
        this._timeScope = this.getTimeScope(time);
        this._intervalString = metadata.getExtendedMetadata(name, MuwsConstants.CALC_INTERVAL_QNAME);
        if (this._intervalString != null) {
            this._interval = XsdUtils.getDuration((String)this._intervalString);
        }
        this._group = metadata.getExtendedMetadata(name, MuwsConstants.METRIC_GROUP_QNAME);
        if (this.isInterval() && this.getIntervalString() == null) {
            Object[] filler = new Object[]{name};
            throw new RuntimeException(_MESSAGES.get("InvalidIntervalDef", filler));
        }
    }

    private int getChangeType(String value) {
        if (value.equals("Counter")) {
            return 1;
        }
        if (value.equals("Gauge")) {
            return 2;
        }
        if (value.equals("Unknown")) {
            return 3;
        }
        Object[] filler = new Object[]{value};
        throw new RuntimeException(_MESSAGES.get("InvalidChangeType", filler));
    }

    public String getDuration() {
        return this._intervalString;
    }

    private int getGatheringTime(String value) {
        if (value.equals("OnChange")) {
            return 7;
        }
        if (value.equals("OnDemand")) {
            return 8;
        }
        if (value.equals("Periodic")) {
            return 9;
        }
        if (value.equals("Unknown")) {
            return 3;
        }
        Object[] filler = new Object[]{value};
        throw new RuntimeException(_MESSAGES.get("InvalidGatheringTime", filler));
    }

    public String getGroup() {
        return this._group;
    }

    public long getInterval() {
        return this._interval;
    }

    public String getIntervalString() {
        return this._intervalString;
    }

    public Date getLastUpdated() {
        return this._lastUpdated;
    }

    public QName getName() {
        return this._name;
    }

    public Date getResetAt() {
        return this._resetAt;
    }

    private int getTimeScope(String value) {
        if (value.equals("Interval")) {
            return 4;
        }
        if (value.equals("PointInTime")) {
            return 5;
        }
        if (value.equals("SinceReset")) {
            return 6;
        }
        Object[] filler = new Object[]{value};
        throw new RuntimeException(_MESSAGES.get("InvalidTimeScope", filler));
    }

    public WsResource getWsResource() {
        return this._resource;
    }

    public boolean hasBeenReset() {
        return this._hasBeenReset;
    }

    public boolean isCounter() {
        return this._changeType == 1;
    }

    public boolean isGauge() {
        return this._changeType == 2;
    }

    public boolean isInterval() {
        return this._timeScope == 4;
    }

    public boolean isOnChange() {
        return this._gatheringTime == 7;
    }

    public boolean isOnDemand() {
        return this._gatheringTime == 8;
    }

    public boolean isPeriodic() {
        return this._gatheringTime == 9;
    }

    public boolean isPointInTime() {
        return this._timeScope == 5;
    }

    public boolean isSinceReset() {
        return this._timeScope == 6;
    }

    public void reset(Object value) throws BaseFault {
        if (this.isPointInTime()) {
            Object[] filler = new Object[]{this.getName()};
            throw new IllegalStateException(_MESSAGES.get("ResetNotAllowed", filler));
        }
        ResourcePropertyCollection props = this.getWsResource().getPropertyCollection();
        props.updateResourceProperty(this.getName(), new Object[]{value});
        this._resetAt = new Date();
        this._lastUpdated = null;
        this._hasBeenReset = true;
    }

    public void update() {
        this._lastUpdated = new Date();
        this._hasBeenReset = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

