/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.Participant;
import org.apache.muse.ws.dm.muws.RelationshipResource;
import org.apache.muse.ws.dm.muws.RelationshipType;
import org.apache.muse.ws.dm.muws.Relationships;
import org.apache.muse.ws.dm.muws.ext.faults.RelationshipCreationFailedFault;
import org.apache.muse.ws.dm.muws.impl.AbstractManageabilityCapability;
import org.apache.muse.ws.dm.muws.impl.QueryRelationshipsHandler;
import org.apache.muse.ws.dm.muws.impl.SimpleParticipant;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationshipType;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleRelationships
extends AbstractManageabilityCapability
implements Relationships {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships = SimpleRelationships.class$("org.apache.muse.ws.dm.muws.impl.SimpleRelationships")) : class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships));
    private String _relationshipPath = null;
    private Set _relationships = new HashSet();
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$RelationshipResource;

    public WsResource addRelationship(String name, RelationshipType type, Participant[] participants) throws BaseFault {
        WsResource relationship = this.createRelationship(name, type, participants);
        this._relationships.add(relationship);
        return relationship;
    }

    protected MessageHandler createQueryHandler() {
        QueryRelationshipsHandler handler = new QueryRelationshipsHandler();
        Method method = ReflectUtils.getFirstMethod(((Object)((Object)this)).getClass(), (String)"queryRelationshipsByType");
        handler.setMethod(method);
        return handler;
    }

    protected WsResource createRelationship(Element xml) throws BaseFault {
        String name = XmlUtils.getElementText((Node)xml, (QName)MuwsConstants.NAME_QNAME);
        Element typeXML = XmlUtils.getElement((Node)xml, (QName)MuwsConstants.TYPE_QNAME);
        SimpleRelationshipType type = new SimpleRelationshipType(typeXML);
        Element[] participantsXML = XmlUtils.getElements((Node)xml, (QName)MuwsConstants.PARTICIPANT_QNAME);
        Participant[] participants = new SimpleParticipant[participantsXML.length];
        for (int n = 0; n < participantsXML.length; ++n) {
            participants[n] = new SimpleParticipant(participantsXML[n]);
        }
        return this.createRelationship(name, type, participants);
    }

    protected WsResource createRelationship(String name, RelationshipType type, Participant[] participants) throws BaseFault {
        ResourceManager manager = this.getWsResource().getResourceManager();
        String endpoint = this.getRelationshipContextPath();
        WsResource resource = null;
        try {
            resource = (WsResource)manager.createResource(endpoint);
        }
        catch (SoapFault error) {
            throw new RelationshipCreationFailedFault((Throwable)error);
        }
        RelationshipResource relationship = (RelationshipResource)resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/RelationshipResource");
        relationship.setName(name);
        relationship.setType(type);
        relationship.setParticipant(participants);
        try {
            resource.initialize();
            manager.addResource(resource.getEndpointReference(), (Resource)resource);
        }
        catch (SoapFault error) {
            throw new RelationshipCreationFailedFault((Throwable)error);
        }
        return resource;
    }

    public Element[] getProperty(QName propertyName) throws BaseFault {
        if (propertyName.equals(MuwsConstants.RELATIONSHIP_QNAME)) {
            return this.getRelationshipElements();
        }
        return super.getProperty(propertyName);
    }

    public QName[] getPropertyNames() {
        return Relationships.PROPERTIES;
    }

    public WsResource[] getRelationship() {
        WsResource[] array = new WsResource[this._relationships.size()];
        return this._relationships.toArray(array);
    }

    protected String getRelationshipContextPath() {
        return this._relationshipPath;
    }

    protected Element[] getRelationshipElements() {
        WsResource[] relationships = this.getRelationship();
        Element[] relationshipXML = new Element[relationships.length];
        for (int n = 0; n < relationships.length; ++n) {
            RelationshipResource capability = (RelationshipResource)relationships[n].getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/RelationshipResource");
            relationshipXML[n] = capability.toXML();
        }
        return relationshipXML;
    }

    public void initialize() throws SoapFault {
        super.initialize();
        WsResource resource = this.getWsResource();
        ResourceManager manager = resource.getResourceManager();
        this._relationshipPath = manager.getResourceContextPath(class$org$apache$muse$ws$dm$muws$RelationshipResource == null ? (class$org$apache$muse$ws$dm$muws$RelationshipResource = SimpleRelationships.class$("org.apache.muse.ws.dm.muws.RelationshipResource")) : class$org$apache$muse$ws$dm$muws$RelationshipResource);
        if (this._relationshipPath == null) {
            throw new RuntimeException(_MESSAGES.get("NoRelationshipEndpoint"));
        }
        this.setMessageHandler(this.createQueryHandler());
    }

    public WsResource[] queryRelationshipsByType(QName[] types) throws BaseFault {
        if (types == null) {
            throw new NullPointerException(_MESSAGES.get("NullQueryTypes"));
        }
        if (types.length == 0) {
            throw new IllegalArgumentException(_MESSAGES.get("EmptyQueryTypes"));
        }
        HashSet<QName> typesSet = new HashSet<QName>();
        for (int n = 0; n < types.length; ++n) {
            typesSet.add(types[n]);
        }
        WsResource[] relationships = this.getRelationship();
        ArrayList<WsResource> results = new ArrayList<WsResource>();
        for (int n = 0; n < relationships.length; ++n) {
            RelationshipResource capability = (RelationshipResource)relationships[n].getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/RelationshipResource");
            QName[] typeValues = capability.getType().getValues();
            if (!typesSet.contains(typeValues[0])) continue;
            results.add(relationships[n]);
        }
        WsResource[] asArray = new WsResource[results.size()];
        return results.toArray(asArray);
    }

    public void removeRelationship(WsResource relationship) {
        if (relationship == null) {
            throw new NullPointerException(_MESSAGES.get("NullRelationship"));
        }
        if (!this._relationships.remove(relationship)) {
            throw new RuntimeException(_MESSAGES.get("RelationshipNotFound"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

