/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathAPI;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContextFactory;
import org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerHelper;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerNotAvailableException;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerPostProcessor;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.FastXPathClassGenerator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerHelper;
import org.eclipse.tptp.platform.provisional.fastxpath.utils.StrTools;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EXPath;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.compiler.CompilerContext;

public class FastXPathEngine
implements IFastXPathEngine {
    private static final String CANNOT_GENERATE_CODE_FOR_EXPRESSION__ = "Cannot generate code for expression: ";
    private FastXPathContextFactory fastXPathContextFactory;
    private HashMap knownExpressions = new HashMap();
    private Properties registeredVariables = new Properties();
    private HashMap registeredExtensionFunctionClass = new HashMap();
    private int compilerState;
    private ICompilerHelper currentHelper;
    private FastXPathClassGenerator compiler;
    private static boolean debug = false;
    private static final String FXP_DEBUG = "FXP_DEBUG";
    static /* synthetic */ Class class$0;

    static {
        debug = System.getProperty(FXP_DEBUG) != null;
    }

    public FastXPathEngine() {
    }

    public FastXPathEngine(FastXPathContextFactory fastXPathContextFactory) {
        this.setFastXPathContextFactory(fastXPathContextFactory);
    }

    public FastXPathEngine(FastXPathContextFactory fastXPathContextFactory, Object object) {
        this(fastXPathContextFactory);
    }

    public Object[] selectNodes(String expression, Object object) throws TransformerException, ExpressionEvaluationException {
        EXPath xpath = (EXPath)this.getExpression(expression);
        FastXPathContext ctx = this.fastXPathContextFactory.newContext(object, this);
        ctx.setEngine(this);
        return xpath.execute(ctx);
    }

    public Object eval(String expression, Object object) throws TransformerException, ExpressionEvaluationException {
        Object[] result = this.selectNodes(expression, object);
        if (result.length > 0) {
            return result[0];
        }
        return null;
    }

    public Object evalCompiled(CompiledExpressionEvaluator evaluator, Object object) throws ExpressionEvaluationException {
        return evaluator.eval(object, this);
    }

    public synchronized CompiledExpressionEvaluator compile(String expression, Object object, ICompilerHelper cHelper) throws TransformerException, CodeGenerationError, CompilerNotAvailableException {
        return this.compile(expression, object, false, null, null, null, cHelper);
    }

    public synchronized CompiledExpressionEvaluator compile(String expression, Object object, boolean verifyExpression, FastXPathContext fastXPathContext, ICompilerContext compilationContext, CompilerPostProcessor compilerPostProcessor, ICompilerHelper cHelper) throws TransformerException, CodeGenerationError, CompilerNotAvailableException {
        CompiledExpressionEvaluator compiledExpressionEvaluator;
        String compiledExpression = null;
        if (this.compilerState == 0) {
            try {
                if (this.currentHelper == null) {
                    this.currentHelper = new CompilerHelper(object.getClass());
                }
                this.currentHelper.initCompiler();
            }
            catch (CompilerNotAvailableException e) {
                this.compilerState = -1;
                throw e;
            }
        }
        if (this.compilerState == -1) {
            throw new CompilerNotAvailableException("Error initializing compiler");
        }
        if (verifyExpression) {
            try {
                this.eval(expression, object);
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {}
        }
        fastXPathContext = fastXPathContext == null ? this.fastXPathContextFactory.newContext(object, this) : fastXPathContext;
        compilationContext = compilationContext == null ? new CompilerContext(object, fastXPathContext, this) : compilationContext.setRuntimeContext(fastXPathContext, object);
        EXPath xpath = (EXPath)this.getExpression(expression);
        xpath.getEExpression().compile(compilationContext);
        compilerPostProcessor = compilerPostProcessor == null ? new CompilerPostProcessor(compilationContext.getSb(), fastXPathContext) : compilerPostProcessor.setSb(compilationContext.getSb()).setFastXPathContext(fastXPathContext);
        compiledExpression = compilerPostProcessor.postCompileProcess();
        compiledExpression = StrTools.escape(compiledExpression);
        if (FastXPathAPI.debug) {
            System.out.println("==== " + expression + " =====\n" + compiledExpression);
        }
        if (cHelper == null) {
            this.currentHelper = cHelper = new CompilerHelper(object.getClass());
            cHelper.initCompiler();
        }
        if ((compiledExpressionEvaluator = cHelper.getCompiledExpressionEvaluator(compiledExpression, expression)) == null) {
            throw new CodeGenerationError(CANNOT_GENERATE_CODE_FOR_EXPRESSION__ + expression);
        }
        return compiledExpressionEvaluator;
    }

    public char[] getExpressionJavaSource(String expression, Object object, boolean verifyExpression, FastXPathContext fastXPathContext, ICompilerContext compilationContext, CompilerPostProcessor compilerPostProcessor, ICompilerHelper cHelper) throws TransformerException, CodeGenerationError, CompilerNotAvailableException {
        String compiledExpression = null;
        if (verifyExpression) {
            try {
                this.eval(expression, object);
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {}
        }
        fastXPathContext = fastXPathContext == null ? this.fastXPathContextFactory.newContext(object, this) : fastXPathContext;
        compilationContext = compilationContext == null ? new CompilerContext(object, fastXPathContext, this) : compilationContext.setRuntimeContext(fastXPathContext, object);
        EXPath xpath = (EXPath)this.getExpression(expression);
        xpath.getEExpression().compile(compilationContext);
        compilerPostProcessor = compilerPostProcessor == null ? new CompilerPostProcessor(compilationContext.getSb(), fastXPathContext) : compilerPostProcessor.setSb(compilationContext.getSb()).setFastXPathContext(fastXPathContext);
        compiledExpression = compilerPostProcessor.postCompileProcess();
        compiledExpression = StrTools.escape(compiledExpression);
        if (cHelper == null) {
            if (this.currentHelper != null) {
                cHelper = this.currentHelper;
            } else {
                this.currentHelper = cHelper = new CompilerHelper(object.getClass());
            }
        }
        cHelper.buildCompiledExpression(compiledExpression, expression, false);
        return cHelper.getJavaSource();
    }

    public synchronized void batchCompile(Object obj, List xpathExpressions) {
        ArrayList<String> compiledExpressions = new ArrayList<String>();
        String compiledExpression = null;
        String expression = null;
        int i = 0;
        while (i < xpathExpressions.size()) {
            FastXPathContext fastXPathContext = this.fastXPathContextFactory.newContext(obj, this);
            CompilerContext compilationContext = new CompilerContext(obj, fastXPathContext, this);
            expression = (String)xpathExpressions.get(i);
            EXPath xpath = null;
            try {
                xpath = (EXPath)this.getExpression(expression);
                xpath.getEExpression().compile(compilationContext);
            }
            catch (TransformerException transformerException) {
            }
            catch (CodeGenerationError codeGenerationError) {}
            CompilerPostProcessor compilerPostProcessor = new CompilerPostProcessor(compilationContext.getSb(), fastXPathContext);
            compiledExpression = compilerPostProcessor.postCompileProcess();
            compiledExpression = StrTools.escape(compiledExpression);
            compiledExpressions.add(compiledExpression);
            compiledExpression = null;
            ++i;
        }
        try {
            this.currentHelper = new CompilerHelper(obj.getClass());
            ((CompilerHelper)this.currentHelper).batchCompile(compiledExpressions, xpathExpressions);
        }
        catch (Error error) {
        }
        catch (Exception exception) {}
    }

    public synchronized List batchGetJavaSource(Object obj, List xpathExpressions, boolean verifyExpression, FastXPathContext fastXPathContext, ICompilerContext compilationContext, CompilerPostProcessor compilerPostProcessor, ICompilerHelper cHelper) {
        ArrayList<String> compiledExpressions = new ArrayList<String>();
        String compiledExpression = null;
        String expression = null;
        int i = 0;
        while (i < xpathExpressions.size()) {
            expression = (String)xpathExpressions.get(i);
            fastXPathContext = this.fastXPathContextFactory.newContext(obj, this);
            compilationContext = new CompilerContext(obj, fastXPathContext, this);
            EXPath xpath = null;
            try {
                xpath = (EXPath)this.getExpression(expression);
                xpath.getEExpression().compile(compilationContext);
            }
            catch (TransformerException transformerException) {
            }
            catch (CodeGenerationError codeGenerationError) {}
            if (compilerPostProcessor == null) {
                compilerPostProcessor = new CompilerPostProcessor(compilationContext.getSb(), fastXPathContext);
            } else {
                compilerPostProcessor.setSb(compilationContext.getSb());
                compilerPostProcessor.setFastXPathContext(fastXPathContext);
            }
            compiledExpression = compilerPostProcessor.postCompileProcess();
            compiledExpression = StrTools.escape(compiledExpression);
            compiledExpressions.add(compiledExpression);
            compiledExpression = null;
            compilationContext.getSb().setLength(0);
            ++i;
        }
        try {
            if (cHelper == null) {
                if (this.currentHelper == null) {
                    this.currentHelper = new CompilerHelper(obj.getClass());
                }
                cHelper = this.currentHelper;
            }
            return ((CompilerHelper)cHelper).batchGetJavaSource(compiledExpressions, xpathExpressions, compilerPostProcessor);
        }
        catch (Error error) {
        }
        catch (Exception exception) {}
        return null;
    }

    public void resetExpressions() {
        this.knownExpressions.clear();
    }

    public void resetDeclaredVariables() {
        this.registeredVariables.clear();
    }

    public String getVariable(String key) {
        return this.registeredVariables.getProperty(key);
    }

    public void registerVariable(String key, String newValue) {
        this.registeredVariables.setProperty(key, newValue);
    }

    public void unRegisterVariable(String key) {
        this.registeredVariables.remove(key);
    }

    public Class getExtensionFunctionClass(String key) {
        return (Class)this.registeredExtensionFunctionClass.get(key);
    }

    public void registerFunctionClass(Class functionClass, String key) {
        this.registeredExtensionFunctionClass.put(key, functionClass);
    }

    public void unRegisterFunctionClass(String key) {
        this.registeredExtensionFunctionClass.remove(key);
    }

    public Object getExpression(String expression) throws TransformerException {
        EXPath xpath = (EXPath)this.knownExpressions.get(expression);
        if (xpath == null) {
            xpath = new EXPath(expression, null, null, 0, null);
            xpath.getEExpression().linkParent(null);
            if (debug) {
                xpath.printGraph();
            }
            this.knownExpressions.put(expression, xpath);
        }
        return xpath;
    }

    public FastXPathContextFactory getFastXPathContextFactory() {
        return this.fastXPathContextFactory;
    }

    public void setFastXPathContextFactory(FastXPathContextFactory fastXPathContextFactory) {
        this.fastXPathContextFactory = fastXPathContextFactory;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.tptp.platform.provisional.fastxpath.utils.StrTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerFunctionClass(clazz, "StrTools");
    }

    public ICompilerHelper createCompilerHelper(Class targetClass) {
        return new CompilerHelper(targetClass);
    }

    public FastXPathClassGenerator getClassGenerator() throws CompilerNotAvailableException {
        if (this.compiler == null) {
            this.compiler = this.currentHelper != null ? this.currentHelper.getCompiler() : new CompilerHelper(null).getCompiler();
        }
        return this.compiler;
    }

    public Map getClassesAsByteArrays() {
        if (this.currentHelper != null) {
            return this.currentHelper.getClassesAsByteArrays();
        }
        return null;
    }
}

