/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementEdge;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeInheritanceDataBuilderImpl;

public class DocumentNode {
    private List<String> aliases;
    private Map<String, Map<String, List<ElementEdge>>> edges = new Hashtable<String, Map<String, List<ElementEdge>>>();

    public String[] getAliases() {
        if (this.aliases == null) {
            return null;
        }
        return this.aliases.toArray(new String[this.aliases.size()]);
    }

    public void addAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(alias);
    }

    public void addEdge(ElementEdge edge) {
        String uri;
        Map<?, ?> namesPerUri;
        ArrayList<ElementEdge> referenceEdges;
        if (edge == null || edge.getReferenceType() == null) {
            return;
        }
        if (this.edges == null) {
            this.edges = new Hashtable<String, Map<String, List<ElementEdge>>>();
        }
        if ((referenceEdges = (ArrayList<ElementEdge>)(namesPerUri = SMLValidatorUtil.retrieveNestedMap(this.edges, uri = (uri = edge.getReferenceNameSpace()) == null ? "" : uri, true)).get(edge.getReferenceType())) == null) {
            referenceEdges = new ArrayList<ElementEdge>();
        }
        referenceEdges.add(edge);
        namesPerUri.put(edge.getReferenceType(), referenceEdges);
    }

    public ElementEdge[] getEdges(String uri, String localName) {
        Hashtable<String, Map<String, TypeNode>> inheritanceMap = (Hashtable<String, Map<String, TypeNode>>)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        if (inheritanceMap == null) {
            inheritanceMap = new Hashtable<String, Map<String, TypeNode>>();
        }
        ArrayList referenceEdges = new ArrayList();
        TypeNode refType = new TypeNode(localName, uri);
        TypeNode refTypeInQuestion = new TypeNode();
        for (String currentURI : this.edges.keySet()) {
            Map<String, List<ElementEdge>> namesPerUri = this.edges.get(currentURI);
            for (String currentType : namesPerUri.keySet()) {
                refTypeInQuestion.setUri(currentURI);
                refTypeInQuestion.setType(currentType);
                if (!TypeInheritanceDataBuilderImpl.isDerivedType(inheritanceMap, refType, refTypeInQuestion)) continue;
                referenceEdges.addAll(namesPerUri.get(currentType));
            }
        }
        return referenceEdges.toArray(new ElementEdge[referenceEdges.size()]);
    }
}

