/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityConstraintDataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintStructure {
    private Map<String, Map<String, List<IdentityConstraintDataBuilder.IdentityConstraintDecl>>> declarations = new Hashtable<String, Map<String, List<IdentityConstraintDataBuilder.IdentityConstraintDecl>>>();
    private Map<String, List<int[]>> constrainedInstances = new Hashtable<String, List<int[]>>();
    private Map<String, List<int[]>> orphanedConstrainedInstances = new Hashtable<String, List<int[]>>();

    public void addDeclaration(String uri, String localName, IdentityConstraintDataBuilder.IdentityConstraintDecl identityDecl) {
        Map<?, ?> declarationsPerURI = SMLValidatorUtil.retrieveNestedMap(this.declarations, uri, true);
        ArrayList<IdentityConstraintDataBuilder.IdentityConstraintDecl> listOfConstraints = (ArrayList<IdentityConstraintDataBuilder.IdentityConstraintDecl>)declarationsPerURI.get(localName);
        if (listOfConstraints == null) {
            listOfConstraints = new ArrayList<IdentityConstraintDataBuilder.IdentityConstraintDecl>();
            declarationsPerURI.put(localName, listOfConstraints);
        }
        listOfConstraints.add(identityDecl);
    }

    public void addConstrainedInstance(String alias, int[] indices) {
        this.addToNestedList(this.constrainedInstances, alias, indices);
    }

    public void addOrphanedConstrainedInstance(int orphanInx, int[] indices) {
        this.addToNestedList(this.orphanedConstrainedInstances, String.valueOf(orphanInx), indices);
    }

    private void addToNestedList(Map<String, List> map, String key, Object value) {
        ArrayList<Object> nestedList = map.get(key);
        if (nestedList == null) {
            nestedList = new ArrayList<Object>();
            map.put(key, nestedList);
        }
        nestedList.add(value);
    }

    public boolean isConstrained(String uri, String localName) {
        return this.retrieveConstraint(uri, localName) != null;
    }

    public IdentityConstraintDataBuilder.IdentityConstraintDecl[] retrieveConstraint(String uri, String localName) {
        if (uri == null || localName == null) {
            return null;
        }
        Map<String, List<IdentityConstraintDataBuilder.IdentityConstraintDecl>> declarationsPerURI = this.declarations.get(uri);
        List<IdentityConstraintDataBuilder.IdentityConstraintDecl> constraints = declarationsPerURI == null ? null : declarationsPerURI.get(localName);
        return constraints == null ? null : constraints.toArray(new IdentityConstraintDataBuilder.IdentityConstraintDecl[constraints.size()]);
    }

    public Map<String, List<int[]>> getConstrainedInstances() {
        return this.constrainedInstances;
    }

    public Map<String, Map<String, List<IdentityConstraintDataBuilder.IdentityConstraintDecl>>> getDeclarations() {
        return this.declarations;
    }

    public Map<String, List<int[]>> getOrphanedConstrainedInstances() {
        return this.orphanedConstrainedInstances;
    }

    public void setConstrainedInstances(Map<String, List<int[]>> constrainedInstances) {
        this.constrainedInstances = constrainedInstances;
    }

    public void setDeclarations(Map<String, Map<String, List<IdentityConstraintDataBuilder.IdentityConstraintDecl>>> declarations) {
        this.declarations = declarations;
    }

    public void setOrphanedConstrainedInstances(Map<String, List<int[]>> orphanedConstrainedInstances) {
        this.orphanedConstrainedInstances = orphanedConstrainedInstances;
    }
}

