/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.osgi.util.NLS;

public class ResourceWrapper {
    private IResource eclipseResource;
    private File resource;
    private boolean inEclipse;

    public ResourceWrapper(String path, boolean inEclipse) {
        this.inEclipse = inEclipse;
        if (inEclipse) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path resourcePath = new Path(path);
            this.eclipseResource = root.getFile((IPath)new Path(path));
            this.eclipseResource = this.eclipseResource != null && this.eclipseResource.exists() ? this.eclipseResource : root.getFileForLocation((IPath)resourcePath);
            Object object = this.eclipseResource = this.eclipseResource != null && this.eclipseResource.exists() ? this.eclipseResource : root.getFolder((IPath)new Path(path));
            if (!this.eclipseResource.exists()) {
                throw new MissingResourceException(NLS.bind((String)SMLValidationMessages.errorMissingFile, (Object)path), null, null);
            }
        } else {
            this.resource = new File(path);
            if (!this.resource.exists()) {
                throw new MissingResourceException(NLS.bind((String)SMLValidationMessages.errorMissingFile, (Object)path), null, null);
            }
        }
    }

    public ResourceWrapper(IResource eclipseResource) {
        this.eclipseResource = eclipseResource;
        this.inEclipse = true;
    }

    public ResourceWrapper(File resource) {
        this.resource = resource;
        this.inEclipse = false;
    }

    public boolean isDirectory() {
        return this.inEclipse ? this.eclipseResource instanceof IContainer : this.resource.isDirectory();
    }

    public ResourceWrapper[] getChildren() {
        ResourceWrapper[] childrenWrapped = new ResourceWrapper[]{};
        if (this.isDirectory()) {
            if (this.inEclipse) {
                try {
                    IResource[] children = ((IContainer)this.eclipseResource).members();
                    childrenWrapped = new ResourceWrapper[children.length];
                    int i = 0;
                    while (i < children.length) {
                        childrenWrapped[i] = new ResourceWrapper(children[i]);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    childrenWrapped = new ResourceWrapper[]{};
                    SMLActivator.logError(e);
                }
            } else {
                File[] children = this.resource.listFiles();
                childrenWrapped = new ResourceWrapper[children.length];
                int i = 0;
                while (i < children.length) {
                    childrenWrapped[i] = new ResourceWrapper(children[i]);
                    ++i;
                }
            }
        }
        return childrenWrapped;
    }

    public String getName() {
        return this.inEclipse ? this.eclipseResource.getName() : this.resource.getName();
    }

    public boolean isFile() {
        return this.inEclipse ? this.eclipseResource instanceof IFile : this.resource.isFile();
    }

    public InputStream getContents() {
        if (!this.isFile()) {
            return null;
        }
        try {
            if (!this.inEclipse) {
                return new FileInputStream(this.resource);
            }
            if (((IFile)this.eclipseResource).exists()) {
                return ((IFile)this.eclipseResource).getContents();
            }
            return new FileInputStream(this.eclipseResource.getFullPath().toOSString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            SMLActivator.logError(e);
        }
        return null;
    }

    public String getFullPath() {
        return this.inEclipse ? this.eclipseResource.getFullPath().toString() : this.resource.getPath();
    }

    public String getAbsolutePath() {
        if (!this.inEclipse) {
            return this.resource.getAbsolutePath();
        }
        if (this.eclipseResource.exists()) {
            return this.eclipseResource.getRawLocation().toString();
        }
        return this.eclipseResource.getFullPath().toOSString();
    }

    public boolean exists() {
        return this.inEclipse ? this.eclipseResource.exists() : this.resource.exists();
    }

    public Object getResource() {
        return this.inEclipse ? this.eclipseResource : this.resource;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceWrapper) || this.getResource() == null) {
            return false;
        }
        return this.getResource().equals(((ResourceWrapper)o).getResource());
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    public String toString() {
        return "ResourceWrapper: " + this.getFullPath();
    }
}

