/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyExtractor<T>
extends AbstractDataBuilder<T> {
    private byte phase;
    protected String elementName;
    private String[][] attributes;
    private String[] keyValuePair;
    private Map<TypeNode, String> entries;
    private Map<String, Map<String, String>> mappedTypeNodes;

    public AbstractPropertyExtractor(byte phase, String elementName, String[][] attributes, String[] keyValuePair) {
        this.phase = phase;
        this.elementName = elementName;
        this.attributes = attributes;
        this.keyValuePair = keyValuePair;
        this.entries = new Hashtable<TypeNode, String>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.elementName != null && !this.elementName.equals(localName)) {
            return;
        }
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.length) {
                int inx = attributes.getIndex(this.attributes[i][0], this.attributes[i][1]);
                if (inx < 0) {
                    if (this.attributes[i][0].equals(uri)) {
                        inx = attributes.getIndex("", this.attributes[i][1]);
                    }
                    if (inx < 0) {
                        return;
                    }
                }
                String currentAttributeValue = attributes.getValue(inx);
                String[] tokenizedValue = this.tokenizeName(currentAttributeValue);
                if (this.attributes[i][2] != null && !this.attributes[i][2].equals(tokenizedValue[1])) {
                    return;
                }
                ++i;
            }
        }
        String[] valueToStore = super.tokenizeName(attributes.getValue(this.keyValuePair[0]));
        String valueToStoreURI = this.getValueToStoreNS() == null ? (valueToStore[0] == null ? super.getDefaultNamespace() : super.getPrefixMap().get(valueToStore[0])) : this.getValueToStoreNS();
        TypeNode nodeType = new TypeNode(valueToStore[1], valueToStoreURI);
        if (valueToStore[1] == null || valueToStore[1] != null && this.entries.get(nodeType) == null) {
            String key;
            String string = key = this.keyValuePair[1] == null ? "true" : attributes.getValue(this.keyValuePair[1]);
            if (key != null) {
                this.entries.put(nodeType, key);
            }
        }
    }

    public Iterator<TypeNode> getIteratorDataStructure() {
        return this.entries.keySet().iterator();
    }

    @Override
    public byte getPhase() {
        return this.phase;
    }

    protected Map<String, Map<String, String>> getMapDataStructure() {
        if (this.mappedTypeNodes == null) {
            this.mappedTypeNodes = new Hashtable<String, Map<String, String>>();
            for (TypeNode typeNode : this.entries.keySet()) {
                String uri = typeNode.getUri();
                uri = uri == null ? "" : uri;
                String type = typeNode.getType();
                if (uri == null || type == null) continue;
                Map<String, String> nodesPerNS = this.mappedTypeNodes.get(uri);
                if (nodesPerNS == null) {
                    nodesPerNS = new Hashtable<String, String>();
                    this.mappedTypeNodes.put(uri, nodesPerNS);
                }
                nodesPerNS.put(type, this.entries.get(typeNode));
            }
        }
        return this.mappedTypeNodes;
    }

    protected String getValueToStoreNS() {
        return null;
    }
}

