/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementNode;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootElementAliasLookupBuilder
extends AbstractDataBuilder<Map<List<String>, String[]>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.RootElementAliasLookupBuilder";
    protected List<String> targetElements;
    protected String[] rootDocElement;
    Map<List<String>, String[]> rootElementAlias = new HashMap<List<String>, String[]>();
    protected ElementNode currentTargetElement;
    protected boolean aliasFound = false;
    protected boolean dataFound = false;
    protected boolean rootElem = false;

    @Override
    public Map<List<String>, String[]> getDataStructure() {
        return this.rootElementAlias;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("aliases".equals(localName)) {
            this.targetElements = new ArrayList<String>();
        } else if ("alias".equals(localName)) {
            this.aliasFound = true;
        } else if ("data".equals(localName)) {
            this.dataFound = true;
            this.rootElem = true;
        } else if (this.dataFound && this.targetElements != null && this.rootElem) {
            this.rootElem = false;
            this.rootDocElement = new String[2];
            this.rootDocElement[0] = localName;
            this.rootDocElement[1] = uri;
            this.dataFound = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.aliasFound) {
            String target = new String(ch, start, len);
            this.targetElements.add(target);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.dataFound && "data".equals(localName)) {
            this.dataFound = false;
            this.rootElem = false;
        } else if ("alias".equals(localName)) {
            this.aliasFound = false;
        } else if (this.dataFound && !this.rootElem) {
            this.rootElem = true;
        } else if ("document".equals(localName)) {
            if (this.targetElements != null && this.rootDocElement != null) {
                this.rootElementAlias.put(this.targetElements, this.rootDocElement);
            }
            this.rootDocElement = null;
            this.targetElements = null;
        }
    }

    @Override
    public byte getPhase() {
        return 16;
    }
}

