/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TargetSchemaNode;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetSchemaBuilder
extends AbstractDataBuilder<Map<String, TargetSchemaNode>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TargetSchemaBuilder";
    protected Map<String, TargetSchemaNode> dataStructure = new HashMap<String, TargetSchemaNode>();
    protected boolean uriElementFound = false;

    @Override
    public Map<String, TargetSchemaNode> getDataStructure() {
        return this.dataStructure;
    }

    public void startSchema(String uri) {
    }

    public void endSchema(String uri) {
        Map substitionMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.SubstitutionBuilder");
        for (String namespaceURI : substitionMap.keySet()) {
            String elementNameNonNS = ParserHelper.removeNameSpace(namespaceURI);
            TargetSchemaNode targetSchemaNode = this.dataStructure.get(elementNameNonNS);
            if (targetSchemaNode != null) {
                Object substitionName = substitionMap.get(namespaceURI);
                TargetSchemaNode subTargetSchemaNode = this.dataStructure.get(substitionName);
                targetSchemaNode.setSubstitutionGroup(subTargetSchemaNode);
                continue;
            }
            Map substitutionMap = (Map)substitionMap.get(namespaceURI);
            for (String elementName : substitutionMap.keySet()) {
                String substitutedElement = (String)substitutionMap.get(elementName);
                substitutedElement = substitutedElement == null ? null : ParserHelper.removeNameSpace(substitutedElement);
                TargetSchemaNode subTargetSchemaNode = this.dataStructure.get(substitutedElement);
                if (subTargetSchemaNode == null) continue;
                this.dataStructure.put(elementNameNonNS, subTargetSchemaNode);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("schema".equals(localName)) {
            this.startSchema(uri);
        } else if ("element".endsWith(localName)) {
            String elementName = attributes.getValue("name");
            String targetElement = attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "targetElement");
            String targetType = attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "targetType");
            String targetRequired = attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "targetRequired");
            if (targetElement != null || targetType != null || targetRequired != null) {
                TargetSchemaNode schemaNode = new TargetSchemaNode(elementName, this.getFilePath(), this.locator == null ? -1 : this.locator.getLineNumber(), this.locator == null ? -1 : this.locator.getColumnNumber());
                schemaNode.setTargetElement(targetElement);
                schemaNode.setTargetType(targetType);
                schemaNode.setRequired(targetRequired);
                this.dataStructure.put(elementName, schemaNode);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("schema".equals(localName)) {
            this.endSchema(uri);
        }
    }

    @Override
    public byte getPhase() {
        return 1;
    }
}

