/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInheritanceDataBuilderImpl
extends AbstractDataBuilder<Map<String, Map<String, TypeNode>>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl";
    private Map<String, Map<String, TypeNode>> inheritanceMap = new HashMap<String, Map<String, TypeNode>>();
    private TypeNode currentComplexType;
    private Map<String, Map<String, Map<String, String>>> attributes = new Hashtable<String, Map<String, Map<String, String>>>();

    @Override
    public Map<String, Map<String, TypeNode>> getDataStructure() {
        return this.inheritanceMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "complexType".equals(localName)) {
            String complexTypeName = attributes.getValue("name");
            if (complexTypeName != null && attributes != null) {
                String targetNameSpace;
                Hashtable<String, String> complexTypeAtts = new Hashtable<String, String>();
                String acyclic = attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "acyclic");
                if (acyclic != null) {
                    complexTypeAtts.put("acyclic", acyclic);
                }
                this.currentComplexType = new TypeNode(complexTypeName, (targetNameSpace = this.getTargetNamespace()) == null ? "" : targetNameSpace);
                Map<?, ?> typesPerUri = SMLValidatorUtil.retrieveNestedMap(this.attributes, this.currentComplexType.getUri(), true);
                typesPerUri.put(this.currentComplexType.getType(), complexTypeAtts);
            }
        } else if (this.currentComplexType != null && "extension".equals(localName)) {
            String name = attributes.getValue("base");
            String[] tokens = this.tokenizeName(name);
            String parentURI = "";
            if (tokens[0] != null) {
                parentURI = this.getPrefixMap().get(tokens[0]);
            }
            TypeNode parent = new TypeNode(tokens[1], parentURI);
            this.validateRelationship(parent, this.currentComplexType);
            Map<?, ?> namesPerUri = SMLValidatorUtil.retrieveNestedMap(this.inheritanceMap, this.currentComplexType.getUri(), true);
            namesPerUri.put(this.currentComplexType.getType(), parent);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "complexType".equals(localName)) {
            this.currentComplexType = null;
        }
    }

    public static boolean isDerivedType(Map<String, Map<String, TypeNode>> inheritanceMap, TypeNode refType, TypeNode refTypeInQuestion) {
        if (refType.equals(refTypeInQuestion)) {
            return true;
        }
        TypeNode currentType = refTypeInQuestion;
        while (currentType != null) {
            Map<String, TypeNode> namePerUri = inheritanceMap.get(currentType.getUri());
            TypeNode typeNode = currentType = namePerUri == null ? null : namePerUri.get(currentType.getType());
            if (!refType.equals(currentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte getPhase() {
        return 1;
    }

    private void validateRelationship(TypeNode baseType, TypeNode complexType) {
        if (this.isTypeAcyclic(baseType, false) && !this.isTypeAcyclic(complexType, true)) {
            this.setStructureValidity(false);
            if (this.getErrorMessage() == null) {
                this.setErrorMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.locator.getLineNumber(), NLS.bind((String)SMLValidationMessages.acyclicBadDerivation, (Object[])new String[]{baseType.getType(), complexType.getType()})));
            } else {
                this.appendToErrorMessage(NLS.bind((String)SMLValidationMessages.acyclicBadDerivation, (Object[])new String[]{baseType.getType(), complexType.getType()}));
            }
        }
    }

    private boolean isTypeAcyclic(TypeNode complexType, boolean defaultValue) {
        String acyclicValue;
        Map<String, String> typeAttributes;
        if (complexType.getUri() == null || complexType.getType() == null) {
            return false;
        }
        Map<String, Map<String, String>> namesPerUri = this.attributes.get(complexType.getUri());
        Map<String, String> map = typeAttributes = namesPerUri == null ? null : namesPerUri.get(complexType.getType());
        if (typeAttributes != null && (acyclicValue = typeAttributes.get("acyclic")) != null) {
            return "true".equalsIgnoreCase(acyclicValue);
        }
        return defaultValue;
    }

    public static TypeNode retrieveType(Map<String, Map<String, TypeNode>> inheritance, String uri, String localName) {
        Map<String, TypeNode> typesPerUri = inheritance.get(uri);
        return typesPerUri == null ? null : typesPerUri.get(localName);
    }
}

