/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBindings;
import org.eclipse.cosmos.rm.validation.internal.artifacts.Schematron;
import org.eclipse.cosmos.rm.validation.internal.artifacts.SchematronOutput;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.common.XMLInternalUtility;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementSchematronCacheBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementTypeMapDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.NamespaceContextBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeInheritanceDataBuilderImpl;
import org.eclipse.cosmos.rm.validation.internal.util.FileHelper;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchematronValidator
extends AbstractSMLValidator {
    protected static final String SKELETON15 = "validation-resources/skeleton1-5.xsl";
    protected IValidationOutput<String, Object> validationLogger;
    protected ElementTypeMap elementTypeMapBuilderStructure;
    protected RuleBindings schemaCacheBuilderStructure;
    protected DocumentDOMBuilder documentDOMBuilder;
    protected Map<String, Map<String, TypeNode>> inheritance;
    private String structuredSchematronOutputTarget;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.instance();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder", new ElementSchematronCacheBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder", new ElementTypeMapDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler", new DocumentDOMBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.IdentityDataBuilder", new IdentityDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl", new TypeInheritanceDataBuilderImpl());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.NamespaceContextBuilder", new NamespaceContextBuilder());
        this.structuredSchematronOutputTarget = (String)validationAttribute.get("validation.structured.output");
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationSchematron);
        this.validationLogger = this.getValidationOutput();
        this.documentDOMBuilder = (DocumentDOMBuilder)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
        this.inheritance = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        this.elementTypeMapBuilderStructure = (ElementTypeMap)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
        Map domDocuments = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
        this.schemaCacheBuilderStructure = (RuleBindings)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder");
        List docWithNoAlias = (List)domDocuments.get("no_alias");
        for (Object alias : domDocuments.keySet()) {
            Object rootElement = domDocuments.get(alias);
            if (!(rootElement instanceof Element) || this.processNode((Element)rootElement, (Node)rootElement, alias) || !this.shouldAbortOnError()) continue;
            return false;
        }
        for (Object rootElement : docWithNoAlias) {
            if (!(rootElement instanceof Element) || this.processNode((Element)rootElement, (Node)rootElement, null) || !this.shouldAbortOnError()) continue;
            return false;
        }
        return true;
    }

    protected boolean processNode(Node currentElement, Node rootElement, Object alias) {
        if (currentElement.getNodeType() != 1) {
            return true;
        }
        boolean allPass = true;
        if (this.schemaCacheBuilderStructure.isRuleBindingPresent()) {
            String nodeNamespace = currentElement.getNamespaceURI();
            List<Schematron> schematronRules = this.schemaCacheBuilderStructure.getBoundRules(nodeNamespace, currentElement.getLocalName());
            if (alias != null && schematronRules == null) {
                schematronRules = this.schemaCacheBuilderStructure.getBoundRules((String)alias);
            }
            String targetType = null;
            if (schematronRules == null && (targetType = this.elementTypeMapBuilderStructure.getType(currentElement.getNamespaceURI(), currentElement.getLocalName())) != null) {
                schematronRules = this.schemaCacheBuilderStructure.getBoundRules(nodeNamespace, targetType + "$typeDelim");
                Map<String, TypeNode> inheritanceMap = null;
                if (schematronRules == null && (inheritanceMap = this.inheritance.get(currentElement.getNamespaceURI())) != null) {
                    TypeNode parent = inheritanceMap.get(targetType);
                    while (parent != null) {
                        schematronRules = this.schemaCacheBuilderStructure.getBoundRules(nodeNamespace, String.valueOf(ParserHelper.removeNameSpace(parent.getType())) + "$typeDelim");
                        if (schematronRules != null) break;
                        parent = inheritanceMap.get(parent.getType());
                    }
                }
            }
            if (schematronRules != null) {
                for (Schematron rule : schematronRules) {
                    if (this.validateSchematron(rule, currentElement, rootElement) || !this.shouldAbortOnError()) continue;
                    allPass = false;
                }
            }
        }
        List<Schematron> globallyBoundRules = this.schemaCacheBuilderStructure.getGloballyBoundRules();
        int i = 0;
        int ruleCount = globallyBoundRules.size();
        while (i < ruleCount) {
            if (!this.validateSchematron(globallyBoundRules.get(i), currentElement, rootElement) && this.shouldAbortOnError()) {
                allPass = false;
            }
            ++i;
        }
        NodeList nodeLists = currentElement.getChildNodes();
        int x = 0;
        while (x < nodeLists.getLength()) {
            Node node = nodeLists.item(x);
            if (node.getNodeType() == 1 && !this.processNode(node, rootElement, null) && this.shouldAbortOnError()) {
                allPass = false;
            }
            ++x;
        }
        return allPass;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean validateSchematron(Schematron schematronNode, Node currentElement, Node rootElement) {
        ErrorCaptureStream errorCaptureStream = new ErrorCaptureStream();
        try {
            StringBuffer buffer = schematronNode.getFragment();
            if (buffer == null) {
                return true;
            }
            String fragment = buffer.toString();
            int schemaInx = fragment.lastIndexOf("</");
            if (schemaInx < 0) {
                return true;
            }
            List<Schematron.Pattern> patterns = schematronNode.getPatterns();
            int i = 0;
            int patternCount = patterns.size();
            while (i < patternCount) {
                Schematron.Pattern pattern = patterns.get(i);
                List<Schematron.Rule> rules = pattern.getRules();
                StringBuffer schematronFragmentBuffer = new StringBuffer().append(buffer);
                schematronFragmentBuffer.insert(schemaInx, pattern.getFragment().toString());
                int j = 0;
                int ruleCount = rules.size();
                while (j < ruleCount) {
                    int patternInx = schematronFragmentBuffer.substring(0, schemaInx + pattern.getFragment().length()).lastIndexOf("</");
                    if (patternInx >= 0) {
                        StringBuffer fragmentWithRule = new StringBuffer().append(schematronFragmentBuffer);
                        Schematron.Rule rule = rules.get(j);
                        String ruleFragment = null;
                        if (!rule.getMatchContainsDeref() && !rule.getContext().startsWith("/")) {
                            ruleFragment = rule.getFragment().toString();
                            StringBuffer pathToRoot = new StringBuffer();
                            this.findPathToRoot(pathToRoot, currentElement);
                            String ruleContext = rule.getContext();
                            if (ruleContext.startsWith(".")) {
                                int forwardSlashInx = ruleContext.indexOf("/");
                                ruleContext = forwardSlashInx >= 0 ? ruleContext.substring(forwardSlashInx) : "";
                            }
                            ruleContext = ruleContext.length() > 0 ? "/" + ruleContext : ruleContext;
                            ruleFragment = SMLValidatorUtil.stringReplace(ruleFragment, "\"" + rule.getContext() + "\"", "\"" + pathToRoot.toString().substring(0, pathToRoot.toString().length() - 1) + ruleContext + "\"");
                        }
                        fragmentWithRule.insert(patternInx, ruleFragment == null ? rule.getFragment().toString() : ruleFragment);
                        StringReader sr = new StringReader(fragmentWithRule.toString());
                        DOMResult schematron = new DOMResult();
                        this.transform(new StreamSource(sr), new StreamSource(FileHelper.getResourceAsStream(SKELETON15)), schematron, errorCaptureStream);
                        final Map<String, String> prefixMap = schematronNode.getPrefixMap();
                        String ruleContext = rule.getContext();
                        if (rule.getMatchContainsDeref() && ruleContext.length() > 0) {
                            NamespaceContext namespaceContext = new NamespaceContext(){

                                @Override
                                public String getNamespaceURI(String prefix) {
                                    String uri = (String)prefixMap.get(prefix);
                                    return uri == null ? "" : uri;
                                }

                                @Override
                                public String getPrefix(String arg0) {
                                    return null;
                                }

                                public Iterator<?> getPrefixes(String arg0) {
                                    return null;
                                }
                            };
                            SMLValidatorUtil.xpath.setNamespaceContext(namespaceContext);
                            XPathExpression xpathExp = SMLValidatorUtil.xpath.compile(ruleContext);
                            NodeList nodeList = (NodeList)xpathExp.evaluate(currentElement, XPathConstants.NODESET);
                            if (nodeList == null || nodeList.getLength() <= 0) {
                                ElementLocation elementLocation = currentElement instanceof Element ? this.documentDOMBuilder.getLocation((Element)currentElement) : null;
                                IValidationMessage message = elementLocation == null ? AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(rule.getLineNumber(), NLS.bind((String)SMLValidationMessages.schematronMissingContext, (Object)ruleContext)) : AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(elementLocation.getFilePath(), elementLocation.getLineNumber(), NLS.bind((String)SMLValidationMessages.schematronMissingContext, (Object)ruleContext));
                                this.validationLogger.reportMessage(message);
                                if (this.shouldAbortOnError()) {
                                    return false;
                                }
                            }
                            int x = 0;
                            while (x < nodeList.getLength()) {
                                if (!this.applySchematron(errorCaptureStream, nodeList.item(x), schematron.getNode()) && this.shouldAbortOnError()) {
                                    return false;
                                }
                                ++x;
                            }
                        } else {
                            if (ruleFragment != null) {
                                currentElement = currentElement.getOwnerDocument().getFirstChild();
                            }
                            if (!this.applySchematron(errorCaptureStream, currentElement, schematron.getNode()) && this.shouldAbortOnError()) {
                                return false;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        catch (XPathExpressionException xe) {
            this.handleError(errorCaptureStream, xe.getLocalizedMessage(), schematronNode.getLineNumber());
        }
        catch (TransformerException xe) {
            this.handleError(errorCaptureStream, xe.getLocalizedMessage());
        }
        catch (Exception e) {
            this.handleError(errorCaptureStream, e.getLocalizedMessage());
        }
        return false;
    }

    private void findPathToRoot(StringBuffer pathToRoot, Node currentElement) {
        pathToRoot.insert(0, String.valueOf(currentElement.getNodeName()) + '[' + this.findIndex(currentElement) + ']' + "/");
        Node parentNode = currentElement.getParentNode();
        if (parentNode == null || parentNode.getParentNode() == null || parentNode.getParentNode().getNodeType() == 9) {
            return;
        }
        this.findPathToRoot(pathToRoot, parentNode);
    }

    private int findIndex(Node currentElement) {
        Node[] children = SMLValidatorUtil.retrieveChildElements(currentElement.getParentNode());
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(currentElement)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private void handleError(ErrorCaptureStream errorCaptureStream, String msg) {
        this.handleError(errorCaptureStream, msg, -1);
    }

    private void handleError(ErrorCaptureStream errorCaptureStream, String msg, int lineNumber) {
        if (!errorCaptureStream.isEmpty()) {
            String[] lines = errorCaptureStream.getLines();
            int i = 0;
            while (i < lines.length && lines[i] != null) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, lines[i]));
                ++i;
            }
        }
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, msg));
    }

    private boolean applySchematron(ErrorCaptureStream errorCaptureStream, Node currentElement, Node schematron) {
        StringWriter sw;
        DocumentDOMBuilder domBuilder;
        block5: {
            domBuilder = (DocumentDOMBuilder)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
            sw = new StringWriter();
            StreamResult output = new StreamResult(sw);
            DOMSource schematronSource = new DOMSource(schematron);
            try {
                this.transform(this.createStreamSource(currentElement), schematronSource, output, errorCaptureStream);
            }
            catch (Exception e) {
                this.handleError(errorCaptureStream, NLS.bind((String)SMLValidationMessages.schematronTransformation, (Object)(e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage())));
                if (!this.shouldAbortOnError()) break block5;
                return false;
            }
        }
        String result = sw.getBuffer().toString();
        if (result.trim().length() > 0) {
            int outputIndex = result.indexOf("%outputids=");
            if (outputIndex > -1) {
                result = this.processStructuredSchematronOutput(currentElement, result);
            }
            this.validationLogger.reportMessage(SMLValidatorUtil.createValidationMessage(domBuilder, currentElement, result));
            if (this.shouldAbortOnError()) {
                return false;
            }
        }
        return true;
    }

    private String processStructuredSchematronOutput(Node currentElement, String schematronResult) {
        ElementSchematronCacheBuilder schematronBuilder = (ElementSchematronCacheBuilder)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder");
        String[] parts = schematronResult.split("%", 3);
        String outputids = parts[1].split("=", 2)[1];
        String[] outputidsArray = outputids.split(" ", -1);
        int i = 0;
        while (i < outputidsArray.length) {
            SchematronOutput schematronOutput = schematronBuilder.getSchematronOutputs().get(outputidsArray[i]);
            try {
                XPathExpression xpathExp = SMLValidatorUtil.xpath.compile(schematronOutput.getExpression());
                NodeList nodeList = (NodeList)xpathExp.evaluate(currentElement, XPathConstants.NODESET);
                Writer writer = this.createStructuredSchematronOutputWriter();
                writer.write("<smlerr:errorData " + SMLValidatorUtil.tagNameFor("xmlns", "smlerr") + "=" + "\"" + "http://schemas.serviceml.org/smlerr/2007/02" + "\"" + ">" + "\n");
                int x = 0;
                while (x < nodeList.getLength()) {
                    Node node = nodeList.item(x);
                    switch (node.getNodeType()) {
                        case 1: {
                            this.serializeElementNode(node, writer);
                            break;
                        }
                        case 2: {
                            this.serializeAttributeNode(node, writer, currentElement.getNamespaceURI());
                            break;
                        }
                    }
                    ++x;
                }
                writer.write("\n");
                writer.write(SMLValidatorUtil.endTagFor("smlerr", "errorData"));
                writer.flush();
                writer.close();
            }
            catch (XPathExpressionException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                e.printStackTrace();
            }
            catch (IOException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                e.printStackTrace();
            }
            ++i;
        }
        schematronResult = parts[2].trim();
        return schematronResult;
    }

    private Writer createStructuredSchematronOutputWriter() {
        if (this.structuredSchematronOutputTarget == null) {
            return new StringWriter();
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.structuredSchematronOutputTarget);
        }
        catch (IOException iOException) {}
        return fileWriter;
    }

    private void serializeAttributeNode(Node node, Writer writer, String namespaceURI) throws IOException {
        writer.write("\t<");
        writer.write(SMLValidatorUtil.tagNameFor("smlerr", "attributeNode"));
        if (namespaceURI != null) {
            writer.write(" ");
            writer.write(node.getPrefix() == null ? "xmlns" : SMLValidatorUtil.tagNameFor("xmlns", node.getPrefix()));
            writer.write("=\"" + namespaceURI + "\"");
        }
        writer.write("\n\t\t");
        writer.write("name=\"");
        writer.write(SMLValidatorUtil.tagNameFor(node.getPrefix(), node.getNodeName()));
        writer.write("\">");
        writer.write(node.getNodeValue());
        writer.write(SMLValidatorUtil.endTagFor("smlerr", "attributeNode"));
    }

    private void serializeElementNode(Node node, Writer writer) throws IOException {
        StringBuffer buffer = new StringBuffer();
        XMLInternalUtility.serializeNode(buffer, node, 1, false);
        writer.write(buffer.toString());
    }

    private StreamSource createStreamSource(Node node) {
        int lineNumber = 0;
        if (node instanceof ElementNode) {
            lineNumber = ((ElementNode)((Object)node)).getLocation().getLineNumber();
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            return new StreamSource(new StringReader(result.getWriter().toString()));
        }
        catch (TransformerConfigurationException e) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, e.getLocalizedMessage()));
        }
        catch (IllegalArgumentException e) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, e.getLocalizedMessage()));
        }
        catch (TransformerFactoryConfigurationError e) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, e.getLocalizedMessage()));
        }
        catch (TransformerException e) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, e.getLocalizedMessage()));
        }
        return null;
    }

    protected void transform(Source source, Source xslt, Result result, ErrorCaptureStream captureError) throws TransformerException {
        Transformer transformer = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        transformer = tFactory.newTransformer(xslt);
        transformer.setErrorListener(new ErrorListener(){

            public void error(TransformerException e) throws TransformerException {
                throw e;
            }

            public void fatalError(TransformerException e) throws TransformerException {
                throw e;
            }

            public void warning(TransformerException e) throws TransformerException {
                throw e;
            }
        });
        System.setErr(new PrintStream(captureError));
        transformer.transform(source, result);
        System.setErr(System.err);
    }

    private static class ErrorCaptureStream
    extends OutputStream {
        private String[] lines = new String[5];
        private int currentInx = 0;
        private StringBuffer buffer = new StringBuffer();

        public void write(int b) throws IOException {
            if (this.currentInx >= this.lines.length) {
                return;
            }
            if (b == 10) {
                if (this.currentInx == 0 || !this.buffer.toString().equals(this.lines[this.currentInx - 1])) {
                    this.lines[this.currentInx++] = this.buffer.toString();
                }
                this.buffer = new StringBuffer();
                return;
            }
            if (b != 13) {
                this.buffer.append((char)b);
            }
        }

        public boolean isEmpty() {
            return this.lines[0] == null;
        }

        public String[] getLines() {
            return this.lines;
        }
    }
}

