/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.analyzer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.analyzer.Analyzer;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.tools.generator.util.DeploymentDescriptorHelper;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.tools.inspector.JavaProperty;
import org.apache.muse.tools.inspector.ResourceInspector;
import org.apache.muse.ws.dm.muws.CorrelatableProperties;
import org.apache.muse.ws.dm.muws.Description;
import org.apache.muse.ws.dm.muws.Identity;
import org.apache.muse.ws.dm.muws.ManageabilityCharacteristics;
import org.apache.muse.ws.dm.muws.Metrics;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.OperationalStatus;
import org.apache.muse.ws.dm.muws.RelationshipResource;
import org.apache.muse.ws.dm.muws.Relationships;
import org.apache.muse.ws.dm.muws.State;
import org.apache.muse.ws.metadata.WsxConstants;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.SubscriptionManager;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.resource.lifetime.ScheduledTermination;
import org.apache.muse.ws.resource.lifetime.WsrlConstants;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.OpenMetadataDescriptor;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.apache.muse.ws.resource.sg.Entry;
import org.apache.muse.ws.resource.sg.ServiceGroup;
import org.w3c.dom.Document;

public class SimpleAnalyzer
implements Analyzer {
    static Map _qnameCapabilityMap = new HashMap();
    static Map _internalImplMap = new HashMap();
    static Map _internalActionMap = new HashMap();
    static ConfigurationDataDescriptor[] REQUIRED_PARAMETERS;
    private Map[] _capabilityMaps = null;
    private Document[] _wsdlDocuments = null;
    private MetadataDescriptor[] _metadataDescriptors;
    static /* synthetic */ Class class$org$apache$muse$ws$metadata$impl$SimpleMetadataExchange;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$query$impl$SimpleQueryCapability;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetCapability;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleIdentity;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleManageabilityCharacteristics;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleCorrelatableProperties;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleDescription;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleOperationalStatus;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleMetrics;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleConfiguration;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleState;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleRelationshipResource;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$adv$impl$SimpleAdvertisement;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$impl$SimpleEntry;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroupRegistration;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SimpleNotificationConsumer;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager;

    public ConfigurationData analyze(ConfigurationData configuration) throws Exception {
        int i;
        ConfigurationData.checkConfiguration(this, configuration);
        this.loadParameters(configuration);
        for (i = 0; i < this._wsdlDocuments.length; ++i) {
            ResourceInspector inspector = this.inspect(this._wsdlDocuments[i], this._metadataDescriptors[i]);
            this._capabilityMaps[i] = new HashMap();
            this.extractOperations(inspector, this._capabilityMaps[i]);
            this.extractProperties(inspector, this._capabilityMaps[i]);
        }
        for (i = 0; i < this._wsdlDocuments.length; ++i) {
            this.updateFromDescriptor(configuration, i);
        }
        return this.createResultData(configuration);
    }

    private static void addProperties(QName[] properties, String uri) {
        for (int i = 0; i < properties.length; ++i) {
            _qnameCapabilityMap.put(properties[i], uri);
        }
    }

    private void loadParameters(ConfigurationData configuration) {
        this._wsdlDocuments = (Document[])configuration.getParameter("wsdl_documents");
        this._capabilityMaps = new HashMap[this._wsdlDocuments.length];
        this._metadataDescriptors = (MetadataDescriptor[])configuration.getParameter("metadata_list");
    }

    private ResourceInspector inspect(Document wsdlDocument, MetadataDescriptor descriptor) {
        ResourceInspector inspector = new ResourceInspector();
        inspector.setMetadata(descriptor);
        inspector.run(wsdlDocument.getDocumentElement(), null);
        return inspector;
    }

    private ConfigurationData createResultData(ConfigurationData configuration) {
        ConfigurationData resultData = (ConfigurationData)configuration.clone();
        resultData.addParameter("capabilities_map_list", this._capabilityMaps);
        return resultData;
    }

    private void extractProperties(ResourceInspector inspector, Map capabilities) {
        Capability capability = null;
        Collection properties = inspector.getProperties();
        if (properties != null) {
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                QName property = (QName)i.next();
                capability = this.getCapability(property, capabilities);
                capability.addProperty(this.makeJavaProperty(property, inspector));
            }
        }
    }

    private void extractOperations(ResourceInspector inspector, Map capabilities) {
        Capability capability = null;
        Map methods = inspector.getJavaMethods();
        Iterator i = methods.values().iterator();
        while (i.hasNext()) {
            JavaMethod method = (JavaMethod)i.next();
            capability = this.getCapability(method.getName(), capabilities);
            String actionURI = (String)_internalActionMap.get(method.getName());
            if (actionURI != null) {
                method.setActionURI(actionURI);
            }
            capability.addOperation(method);
        }
    }

    private void updateFromDescriptor(ConfigurationData configuration, int resourceIndex) throws Exception {
        Document descriptorDocument = (Document)configuration.getParameter("descriptor_document");
        if (descriptorDocument == null) {
            return;
        }
        DeploymentDescriptorHelper helper = new DeploymentDescriptorHelper(descriptorDocument, this._wsdlDocuments[resourceIndex], resourceIndex);
        Capability[] capsFromDescriptor = helper.getCapabilities();
        Map currentCapabilityMap = this._capabilityMaps[resourceIndex];
        for (int i = 0; i < capsFromDescriptor.length; ++i) {
            Capability capability = capsFromDescriptor[i];
            String uri = capability.getURI();
            Capability existingCapability = (Capability)currentCapabilityMap.get(uri);
            if (existingCapability != null) {
                String implClass = capability.getImplementingClass();
                if (implClass == null) continue;
                String existingClass = existingCapability.getImplementingClass();
                if (existingClass == null) {
                    existingCapability.setImplementingClass(implClass);
                    existingCapability.setBuiltIn(false);
                    continue;
                }
                if (existingClass.equals(implClass)) continue;
                existingCapability.setImplementingClass(implClass);
                existingCapability.setBuiltIn(false);
                continue;
            }
            Class implementingClass = (Class)_internalImplMap.get(uri);
            if (implementingClass != null) continue;
            currentCapabilityMap.put(uri, capability);
            capability.setBuiltIn(false);
        }
    }

    private JavaProperty makeJavaProperty(QName property, ResourceInspector inspector) {
        JavaProperty javaProperty = new JavaProperty();
        javaProperty.setQName(property);
        javaProperty.setJavaType(inspector.getPropertyType(property));
        MetadataDescriptor metadata = inspector.getMetadata();
        if (!metadata.hasProperty(property)) {
            metadata = OpenMetadataDescriptor.getInstance();
        }
        javaProperty.setMetadata(metadata);
        return javaProperty;
    }

    private Capability getCapability(QName qname, Map capabilities) {
        Class implementingClass;
        String capabilityURI = this.getCapabilityURI(qname);
        Capability capability = (Capability)capabilities.get(capabilityURI);
        if (capability == null) {
            capability = new Capability(capabilityURI);
            capabilities.put(capabilityURI, capability);
        }
        if ((implementingClass = (Class)_internalImplMap.get(capabilityURI)) != null) {
            capability.setImplementingClass(implementingClass.getName());
            capability.setBuiltIn(true);
        }
        return capability;
    }

    private String getCapabilityURI(QName qname) {
        String result = (String)_qnameCapabilityMap.get(qname);
        return result == null ? qname.getNamespaceURI() : result;
    }

    public ConfigurationDataDescriptor[] getConfigurationDataDescriptions() {
        return REQUIRED_PARAMETERS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _qnameCapabilityMap.put(WsxConstants.GET_METADATA_QNAME, "http://schemas.xmlsoap.org/ws/2004/09/mex");
        _internalImplMap.put("http://schemas.xmlsoap.org/ws/2004/09/mex", class$org$apache$muse$ws$metadata$impl$SimpleMetadataExchange == null ? (class$org$apache$muse$ws$metadata$impl$SimpleMetadataExchange = SimpleAnalyzer.class$("org.apache.muse.ws.metadata.impl.SimpleMetadataExchange")) : class$org$apache$muse$ws$metadata$impl$SimpleMetadataExchange);
        _internalActionMap.put(WsxConstants.GET_METADATA_QNAME, "http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata");
        _qnameCapabilityMap.put(WsrpConstants.GET_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/Get");
        _qnameCapabilityMap.put(WsrpConstants.GET_DOCUMENT_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/Get");
        _qnameCapabilityMap.put(WsrpConstants.GET_MULTIPLE_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/Get");
        _qnameCapabilityMap.put(WsrpConstants.QUERY_DIALECT_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/Get");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/rpw-2/Get", class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability == null ? (class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability = SimpleAnalyzer.class$("org.apache.muse.ws.resource.properties.get.impl.SimpleGetCapability")) : class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability);
        _internalActionMap.put(WsrpConstants.GET_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/GetResourceProperty/GetResourcePropertyRequest");
        _internalActionMap.put(WsrpConstants.GET_DOCUMENT_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/GetResourcePropertyDocument/GetResourcePropertyDocumentRequest");
        _internalActionMap.put(WsrpConstants.GET_MULTIPLE_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/GetMultipleResourceProperties/GetMultipleResourcePropertiesRequest");
        _qnameCapabilityMap.put(WsrpConstants.QUERY_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/Query");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/rpw-2/Query", class$org$apache$muse$ws$resource$properties$query$impl$SimpleQueryCapability == null ? (class$org$apache$muse$ws$resource$properties$query$impl$SimpleQueryCapability = SimpleAnalyzer.class$("org.apache.muse.ws.resource.properties.query.impl.SimpleQueryCapability")) : class$org$apache$muse$ws$resource$properties$query$impl$SimpleQueryCapability);
        _internalActionMap.put(WsrpConstants.QUERY_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/QueryResourceProperties/QueryResourcePropertiesRequest");
        _qnameCapabilityMap.put(WsrpConstants.SET_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/Set");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/rpw-2/Set", class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetCapability == null ? (class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetCapability = SimpleAnalyzer.class$("org.apache.muse.ws.resource.properties.set.impl.SimpleSetCapability")) : class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetCapability);
        _internalActionMap.put(WsrpConstants.SET_QNAME, "http://docs.oasis-open.org/wsrf/rpw-2/SetResourceProperties/SetResourcePropertiesRequest");
        _qnameCapabilityMap.put(WsrlConstants.DESTROY_QNAME, "http://docs.oasis-open.org/wsrf/rlw-2/ImmediateResourceTermination");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/rlw-2/ImmediateResourceTermination", class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination == null ? (class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination = SimpleAnalyzer.class$("org.apache.muse.ws.resource.lifetime.impl.SimpleImmediateTermination")) : class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination);
        _internalActionMap.put(WsrlConstants.DESTROY_QNAME, "http://docs.oasis-open.org/wsrf/rlw-2/ImmediateResourceTermination/DestroyRequest");
        SimpleAnalyzer.addProperties(ScheduledTermination.PROPERTIES, "http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination");
        _qnameCapabilityMap.put(WsrlConstants.SET_TERMINATION_QNAME, "http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination", class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination == null ? (class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination = SimpleAnalyzer.class$("org.apache.muse.ws.resource.lifetime.impl.SimpleScheduledTermination")) : class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination);
        _internalActionMap.put(WsrlConstants.SET_TERMINATION_QNAME, "http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination/SetTerminationTimeRequest");
        SimpleAnalyzer.addProperties(Identity.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/Identity");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Identity", class$org$apache$muse$ws$dm$muws$impl$SimpleIdentity == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleIdentity = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleIdentity")) : class$org$apache$muse$ws$dm$muws$impl$SimpleIdentity);
        SimpleAnalyzer.addProperties(ManageabilityCharacteristics.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/ManageabilityCharacteristics");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/ManageabilityCharacteristics", class$org$apache$muse$ws$dm$muws$impl$SimpleManageabilityCharacteristics == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleManageabilityCharacteristics = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleManageabilityCharacteristics")) : class$org$apache$muse$ws$dm$muws$impl$SimpleManageabilityCharacteristics);
        SimpleAnalyzer.addProperties(CorrelatableProperties.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/CorrelatableProperties");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/CorrelatableProperties", class$org$apache$muse$ws$dm$muws$impl$SimpleCorrelatableProperties == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleCorrelatableProperties = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleCorrelatableProperties")) : class$org$apache$muse$ws$dm$muws$impl$SimpleCorrelatableProperties);
        SimpleAnalyzer.addProperties(Description.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/Description");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Description", class$org$apache$muse$ws$dm$muws$impl$SimpleDescription == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleDescription = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleDescription")) : class$org$apache$muse$ws$dm$muws$impl$SimpleDescription);
        SimpleAnalyzer.addProperties(OperationalStatus.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus", class$org$apache$muse$ws$dm$muws$impl$SimpleOperationalStatus == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleOperationalStatus = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleOperationalStatus")) : class$org$apache$muse$ws$dm$muws$impl$SimpleOperationalStatus);
        SimpleAnalyzer.addProperties(Metrics.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/Metrics");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Metrics", class$org$apache$muse$ws$dm$muws$impl$SimpleMetrics == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleMetrics = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleMetrics")) : class$org$apache$muse$ws$dm$muws$impl$SimpleMetrics);
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Configuration", class$org$apache$muse$ws$dm$muws$impl$SimpleConfiguration == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleConfiguration = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleConfiguration")) : class$org$apache$muse$ws$dm$muws$impl$SimpleConfiguration);
        SimpleAnalyzer.addProperties(State.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/State");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/State", class$org$apache$muse$ws$dm$muws$impl$SimpleState == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleState = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleState")) : class$org$apache$muse$ws$dm$muws$impl$SimpleState);
        SimpleAnalyzer.addProperties(Relationships.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships");
        _qnameCapabilityMap.put(MuwsConstants.QUERY_RELATIONSHIPS_QNAME, "http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships", class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleRelationships")) : class$org$apache$muse$ws$dm$muws$impl$SimpleRelationships);
        _internalActionMap.put(MuwsConstants.QUERY_RELATIONSHIPS_QNAME, "http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships/QueryRelationshipsByType");
        SimpleAnalyzer.addProperties(RelationshipResource.PROPERTIES, "http://docs.oasis-open.org/wsdm/muws/capabilities/RelationshipResource");
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/RelationshipResource", class$org$apache$muse$ws$dm$muws$impl$SimpleRelationshipResource == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleRelationshipResource = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.impl.SimpleRelationshipResource")) : class$org$apache$muse$ws$dm$muws$impl$SimpleRelationshipResource);
        _internalImplMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Advertisement", class$org$apache$muse$ws$dm$muws$adv$impl$SimpleAdvertisement == null ? (class$org$apache$muse$ws$dm$muws$adv$impl$SimpleAdvertisement = SimpleAnalyzer.class$("org.apache.muse.ws.dm.muws.adv.impl.SimpleAdvertisement")) : class$org$apache$muse$ws$dm$muws$adv$impl$SimpleAdvertisement);
        SimpleAnalyzer.addProperties(ServiceGroup.PROPERTIES, "http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroup");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroup", class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup == null ? (class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup = SimpleAnalyzer.class$("org.apache.muse.ws.resource.sg.impl.SimpleServiceGroup")) : class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup);
        SimpleAnalyzer.addProperties(Entry.PROPERTIES, "http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry", class$org$apache$muse$ws$resource$sg$impl$SimpleEntry == null ? (class$org$apache$muse$ws$resource$sg$impl$SimpleEntry = SimpleAnalyzer.class$("org.apache.muse.ws.resource.sg.impl.SimpleEntry")) : class$org$apache$muse$ws$resource$sg$impl$SimpleEntry);
        _internalActionMap.put("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupRegistration/AddRequest", "http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupRegistration");
        _internalImplMap.put("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupRegistration", class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroupRegistration == null ? (class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroupRegistration = SimpleAnalyzer.class$("org.apache.muse.ws.resource.sg.impl.SimpleServiceGroupRegistration")) : class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroupRegistration);
        _qnameCapabilityMap.put(WsnConstants.NOTIFY_QNAME, "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer");
        _internalImplMap.put("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer", class$org$apache$muse$ws$notification$impl$SimpleNotificationConsumer == null ? (class$org$apache$muse$ws$notification$impl$SimpleNotificationConsumer = SimpleAnalyzer.class$("org.apache.muse.ws.notification.impl.SimpleNotificationConsumer")) : class$org$apache$muse$ws$notification$impl$SimpleNotificationConsumer);
        _internalActionMap.put(WsnConstants.NOTIFY_QNAME, "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/NotifyRequest");
        SimpleAnalyzer.addProperties(NotificationProducer.PROPERTIES, "http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        _qnameCapabilityMap.put(WsnConstants.SUBSCRIBE_QNAME, "http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        _qnameCapabilityMap.put(WsnConstants.GET_CURRENT_QNAME, "http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        _internalImplMap.put("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer", class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer == null ? (class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer = SimpleAnalyzer.class$("org.apache.muse.ws.notification.impl.SimpleNotificationProducer")) : class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer);
        _internalActionMap.put(WsnConstants.SUBSCRIBE_QNAME, "http://docs.oasis-open.org/wsn/bw-2/NotificationProducer/SubscribeRequest");
        _internalActionMap.put(WsnConstants.GET_CURRENT_QNAME, "http://docs.oasis-open.org/wsn/bw-2/NotificationProducer/GetCurrentMessageRequest");
        SimpleAnalyzer.addProperties(SubscriptionManager.PROPERTIES, "http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        _qnameCapabilityMap.put(WsnConstants.PAUSE_QNAME, "http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        _qnameCapabilityMap.put(WsnConstants.RESUME_QNAME, "http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        _internalImplMap.put("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager", class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager == null ? (class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager = SimpleAnalyzer.class$("org.apache.muse.ws.notification.impl.SimpleSubscriptionManager")) : class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager);
        _internalActionMap.put(WsnConstants.PAUSE_QNAME, "http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager/PauseSubscriptionRequest");
        _internalActionMap.put(WsnConstants.RESUME_QNAME, "http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager/ResumeSubscriptionRequest");
        REQUIRED_PARAMETERS = new ConfigurationDataDescriptor[]{ConfigurationData.DESCRIPTOR_DOCUMENT_CONFIGURATION};
    }
}

