/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.projectizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.projectizer.Projectizer;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.tools.generator.util.OverwriteHelper;
import org.apache.muse.util.FileUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractProjectizer
implements Projectizer {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$projectizer$AbstractProjectizer == null ? (class$org$apache$muse$tools$generator$projectizer$AbstractProjectizer = AbstractProjectizer.class$("org.apache.muse.tools.generator.projectizer.AbstractProjectizer")) : class$org$apache$muse$tools$generator$projectizer$AbstractProjectizer));
    private static Logger _logger = Logger.getLogger((class$org$apache$muse$tools$generator$Wsdl2Java == null ? (class$org$apache$muse$tools$generator$Wsdl2Java = AbstractProjectizer.class$("org.apache.muse.tools.generator.Wsdl2Java")) : class$org$apache$muse$tools$generator$Wsdl2Java).getPackage().getName());
    protected static final String DEFAULT_WSDL_NAME_SUFFIX = ".wsdl";
    protected static final String DEFAULT_RMD_NAME_SUFFIX = ".rmd";
    protected static final String PLACE_HOLDER = "XXX";
    private int _resourceCounter = 1;
    private OverwriteHelper _overwriteHelper = null;
    protected File _targetDirectory;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$projectizer$AbstractProjectizer;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$Wsdl2Java;

    protected void writeToFileCheck(Node node, File destination) throws Exception {
        if (this.canOverwrite(destination)) {
            this.checkParentDirectory(destination);
            this.writeStringtoFile(XmlUtils.toString((Node)node), destination);
            this._overwriteHelper.add(destination, this._targetDirectory);
        } else {
            _logger.info(_MESSAGES.get("NotOverwriting", (Object[])new String[]{destination.getPath()}));
        }
    }

    protected void writeToFileCheck(String string, File destination) throws Exception {
        this.writeToFileCheck(string, destination, true);
    }

    protected void writeToFileCheck(String string, File destination, boolean overwritable) throws Exception {
        if (this.canOverwrite(destination)) {
            this.checkParentDirectory(destination);
            this.writeStringtoFile(string, destination);
            if (overwritable) {
                this._overwriteHelper.add(destination, this._targetDirectory);
            }
        } else {
            _logger.info(_MESSAGES.get("NotOverwriting", (Object[])new String[]{destination.getPath()}));
        }
    }

    protected void copyStreamCheck(InputStream inputStream, File destination) throws Exception {
        if (this.canOverwrite(destination)) {
            this.checkParentDirectory(destination);
            FileUtils.copyFile((InputStream)inputStream, (File)destination);
            this._overwriteHelper.add(destination, this._targetDirectory);
        } else {
            _logger.warning(_MESSAGES.get("NotOverwriting", (Object[])new String[]{destination.getPath()}));
        }
    }

    protected String loadString(InputStream inputStream, Object[] filler) throws Exception {
        StringBuffer result = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        int i = 0;
        while ((line = br.readLine()) != null) {
            if (line.indexOf(PLACE_HOLDER) > 0 && i < filler.length) {
                line = line.replaceFirst(PLACE_HOLDER, filler[i++].toString());
            }
            result.append(line + "\n");
        }
        return result.toString();
    }

    protected void copyTemplate(File sourceDir, File destinationDir) throws Exception {
        File[] files = sourceDir.listFiles();
        File destination = null;
        for (int i = 0; i < files.length; ++i) {
            destination = new File(destinationDir, files[i].getName());
            if (files[i].isDirectory()) {
                this.checkDirectory(destination);
                this.copyTemplate(files[i], destination);
                continue;
            }
            this.copyFileCheck(files[i], destination);
        }
    }

    private void copyFileCheck(File source, File destination) throws Exception {
        if (this.canOverwrite(destination)) {
            this.checkParentDirectory(destination);
            FileUtils.copy((File)source, (File)destination);
            this._overwriteHelper.add(destination, this._targetDirectory);
        } else {
            _logger.info(_MESSAGES.get("NotOverwriting", (Object[])new String[]{destination.getPath()}));
        }
    }

    private boolean canOverwrite(File file) {
        return this._overwriteHelper.canOverwrite(file, this._targetDirectory);
    }

    protected void createRouterEntries(File routerEntriesDir, String serviceName, Map capabilities) throws Exception {
        if (capabilities.keySet().contains("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager") || capabilities.keySet().contains("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry")) {
            return;
        }
        Document routerEntryDocument = XmlUtils.createDocument();
        Element parametersElement = XmlUtils.createElement((Document)routerEntryDocument, (QName)WsaConstants.PARAMETERS_QNAME);
        routerEntryDocument.appendChild(parametersElement);
        File serviceDir = new File(routerEntriesDir, serviceName);
        File routerEntryFile = new File(serviceDir, this.getResourceFileName());
        this.writeToFileCheck(routerEntryDocument, routerEntryFile);
    }

    private String getResourceFileName() {
        return "resource-instance-XXX.xml".replaceFirst(PLACE_HOLDER, String.valueOf(this._resourceCounter++));
    }

    protected void createJavaSources(File javaSourceDir, Map[] filesMaps) throws Exception {
        this.createJavaSources(javaSourceDir, filesMaps, null);
    }

    protected void createJavaSources(File javaSourceDir, Map[] filesMaps, Set[] ignoreSets) throws Exception {
        for (int i = 0; i < filesMaps.length; ++i) {
            Map files = filesMaps[i];
            Iterator j = files.keySet().iterator();
            while (j.hasNext()) {
                String file = (String)j.next();
                File javaFile = new File(javaSourceDir, file);
                boolean overwritable = true;
                if (ignoreSets != null && ignoreSets[i] != null) {
                    overwritable = !ignoreSets[i].contains(new File(file));
                }
                this.writeToFileCheck((String)files.get(file), javaFile, overwritable);
            }
        }
    }

    protected void copyJars(String[] moduleNames, File baseModulesDir, File destDir) throws Exception {
        this.copyJars(moduleNames, baseModulesDir, destDir, null);
    }

    protected void copyJars(String[] moduleNames, File baseModulesDir, File destDir, FileFilter filter) throws Exception {
        if (!baseModulesDir.exists()) {
            throw new FileNotFoundException();
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new RuntimeException();
        }
        File curDir = null;
        File destFile = null;
        for (int i = 0; i < moduleNames.length; ++i) {
            curDir = new File(baseModulesDir, moduleNames[i]);
            if (!curDir.exists()) {
                throw new FileNotFoundException(curDir.getAbsolutePath());
            }
            File[] files = curDir.listFiles(filter);
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].getName().toLowerCase().endsWith(".jar")) continue;
                destFile = new File(destDir, files[j].getName());
                this.copyFileCheck(files[j], destFile);
            }
        }
    }

    protected void writeStringtoFile(String string, File destination) throws Exception {
        FileWriter fileWriter = new FileWriter(destination);
        fileWriter.write(string);
        fileWriter.close();
    }

    protected void checkParentDirectory(File destination) throws Exception {
        File parent = destination.getAbsoluteFile().getParentFile();
        this.checkDirectory(parent);
    }

    protected void checkDirectory(File directory) throws Exception {
        if (!directory.exists() && !directory.mkdirs()) {
            Object[] filler = new Object[]{directory};
            throw new Exception(_MESSAGES.get("CouldNotMakeDir", filler));
        }
    }

    protected void setTargetDirectory(File targetDirectory, boolean overwrite) {
        this._targetDirectory = targetDirectory == null ? FileUtils.CURRENT_DIR : targetDirectory;
        this._overwriteHelper = new OverwriteHelper(this._targetDirectory, overwrite);
    }

    protected void createOverwriteManifest() throws Exception {
        this._overwriteHelper.writeToDirectory(this._targetDirectory);
    }

    protected String getWsdlFileName(String wsdlRelativePath, Document wsdl) {
        String wsdlFileName = WsdlUtils.getServiceName((Element)wsdl.getDocumentElement()) + DEFAULT_WSDL_NAME_SUFFIX;
        return this.createClassloadablePath(wsdlRelativePath, wsdlFileName);
    }

    protected String getMetadataFileName(String wsdlRelativePath, Document wsdl) {
        String rmdFileName = WsdlUtils.getServiceName((Element)wsdl.getDocumentElement()) + DEFAULT_RMD_NAME_SUFFIX;
        return this.createClassloadablePath(wsdlRelativePath, rmdFileName);
    }

    protected String createClassloadablePath(String directory, String filename) {
        File file = new File(directory, filename);
        return file.getPath().replace(File.separatorChar, '/');
    }

    protected void updatePortType(Document wsdl, MetadataDescriptor metadata, File metadataFile) {
        Element portType = WsdlUtils.getFirstPortType((Node)wsdl);
        portType.setAttributeNS("http://docs.oasis-open.org/wsrf/rmd-1", WsrmdConstants.DESCRIPTOR_ATTR_QNAME.getLocalPart(), metadata.getName());
        portType.setAttributeNS("http://docs.oasis-open.org/wsrf/rmd-1", WsrmdConstants.DESCRIPTOR_LOCATION_ATTR_QNAME.getLocalPart(), metadataFile.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void projectize(ConfigurationData var1) throws Exception;

    public abstract /* synthetic */ ConfigurationDataDescriptor[] getConfigurationDataDescriptions();
}

