/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.tools.generator.util.DeploymentDescriptorHelper;
import org.apache.muse.tools.generator.util.MuseRuntimeException;
import org.apache.muse.tools.generator.util.SimpleLogFormatter;
import org.apache.muse.tools.generator.util.WsdlEnvironment;
import org.apache.muse.util.CommandLine;
import org.apache.muse.util.FileUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.resource.metadata.impl.SimpleMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.impl.WsrmdUtils;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractCommandLineApp {
    public static final String TOP_LEVEL_PACKAGE = "org.apache.muse.tools";
    public static final String PATH_TO_POM_PROPERTIES = "/META-INF/maven/muse/muse-tools/pom.properties";
    public static final String VERSION_PROPERTY = "version";
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$util$AbstractCommandLineApp == null ? (class$org$apache$muse$tools$generator$util$AbstractCommandLineApp = AbstractCommandLineApp.class$("org.apache.muse.tools.generator.util.AbstractCommandLineApp")) : class$org$apache$muse$tools$generator$util$AbstractCommandLineApp));
    protected static Logger _logger = Logger.getLogger((class$org$apache$muse$tools$generator$util$AbstractCommandLineApp == null ? (class$org$apache$muse$tools$generator$util$AbstractCommandLineApp = AbstractCommandLineApp.class$("org.apache.muse.tools.generator.util.AbstractCommandLineApp")) : class$org$apache$muse$tools$generator$util$AbstractCommandLineApp).getPackage().getName());
    static /* synthetic */ Class class$org$apache$muse$tools$generator$util$AbstractCommandLineApp;

    public static void handleMessage(String message) {
        _logger.info(message);
    }

    public static void handleErrorAndExit(String message) {
        _logger.severe(message);
        System.exit(1);
    }

    public static void handleErrorAndExit(String message, Exception exception) {
        _logger.log(Level.SEVERE, message, exception);
        System.exit(1);
    }

    public static void handleExit() {
        System.exit(0);
    }

    public static Object[] getFiller(Exception e) {
        String message = e.getMessage();
        Object[] filler = new Object[]{message == null ? new String() : message};
        return filler;
    }

    public static Document[] getWSDLDocuments(File deploymentDescriptorFile, Document deploymentDescriptorDocument) throws Exception {
        WsdlEnvironment env = null;
        File[] wsdlFiles = DeploymentDescriptorHelper.getWsdls(deploymentDescriptorFile, deploymentDescriptorDocument);
        Document[] wsdlDocuments = new Document[wsdlFiles.length];
        for (int i = 0; i < wsdlFiles.length; ++i) {
            env = new WsdlEnvironment(wsdlFiles[i].getAbsoluteFile().getParentFile());
            wsdlDocuments[i] = AbstractCommandLineApp.getWSDLDocument(wsdlFiles[i].getName(), (Environment)env);
        }
        return wsdlDocuments;
    }

    public static MetadataDescriptor[] getMetadataDescriptors(File descriptorFile, Document descriptorDocument) throws Exception {
        WsdlEnvironment env = null;
        File[] wsdlFiles = DeploymentDescriptorHelper.getWsdls(descriptorFile, descriptorDocument);
        MetadataDescriptor[] metadatas = new MetadataDescriptor[wsdlFiles.length];
        for (int i = 0; i < wsdlFiles.length; ++i) {
            env = new WsdlEnvironment(wsdlFiles[i].getAbsoluteFile().getParentFile());
            metadatas[i] = AbstractCommandLineApp.getMetadataDescriptor(wsdlFiles[i].getName(), env);
        }
        return metadatas;
    }

    public static MetadataDescriptor getMetadataDescriptor(String wsdlPath, WsdlEnvironment env) {
        return AbstractCommandLineApp.getMetadataDescriptor(wsdlPath, (Environment)env, env.getDocument(wsdlPath));
    }

    public static MetadataDescriptor getMetadataDescriptor(String wsdlPath, Environment env, Document wsdlDocument) {
        SimpleMetadataDescriptor metadata = null;
        Element portType = WsdlUtils.getFirstPortType((Node)wsdlDocument);
        if (portType != null) {
            QName descQname = WsrmdConstants.DESCRIPTOR_ATTR_QNAME;
            String descName = portType.getAttributeNS(descQname.getNamespaceURI(), descQname.getLocalPart());
            QName locationQname = WsrmdConstants.DESCRIPTOR_LOCATION_ATTR_QNAME;
            String locationName = portType.getAttributeNS(locationQname.getNamespaceURI(), locationQname.getLocalPart());
            if (descName.length() != 0 && locationName.length() != 0) {
                String relativePath = env.createRelativePath(wsdlPath, locationName);
                Document doc = env.getDocument(relativePath);
                Element rmdDoc = WsrmdUtils.getMetadataDescriptor((Document)doc, (String)descName);
                if (rmdDoc == null) {
                    Object[] filler = new Object[]{descName, relativePath, AbstractCommandLineApp.getEnvFile(env, wsdlPath)};
                    throw new MuseRuntimeException("BadRMDName", _MESSAGES.get("BadRMDName", filler));
                }
                metadata = new SimpleMetadataDescriptor(rmdDoc);
            }
        }
        return metadata;
    }

    private static Object getEnvFile(Environment env, String wsdlPath) {
        return new File(env.getRealDirectory(), wsdlPath);
    }

    public static Document getWSDLDocument(String wsdlPath, Environment env) throws Exception {
        if (wsdlPath == null) {
            throw new IllegalArgumentException(_MESSAGES.get("NullWSDL"));
        }
        try {
            Document wsdl = WsdlUtils.createWSDL((Environment)env, (String)wsdlPath, (boolean)true);
            WsdlUtils.removeSchemaReferences((Element)wsdl.getDocumentElement());
            WsdlUtils.removeWsdlReferences((Element)wsdl.getDocumentElement());
            return wsdl;
        }
        catch (Exception e) {
            Object[] filler = AbstractCommandLineApp.getFiller(e);
            throw new RuntimeException(_MESSAGES.get("FailedLoadingWSDL", filler), e);
        }
    }

    public static boolean hasNoArguments(CommandLine arguments) {
        return arguments.getNumberOfArguments() + arguments.getNumberOfFlags() == 0;
    }

    protected static void createLogger(CommandLine arguments) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleLogFormatter());
        _logger = Logger.getLogger(TOP_LEVEL_PACKAGE);
        _logger.setLevel(Level.INFO);
        _logger.setUseParentHandlers(false);
        _logger.addHandler(handler);
        if (arguments.hasFlag("-verbose")) {
            _logger.setLevel(Level.ALL);
        } else if (arguments.hasFlag("-quiet")) {
            _logger.setLevel(Level.OFF);
        } else {
            _logger.setLevel(Level.FINE);
        }
    }

    protected static boolean checkOverwriteArg(CommandLine arguments) {
        return arguments.hasFlag("-overwrite");
    }

    public static String getVersion() {
        String version = _MESSAGES.get("DefaultVersion");
        InputStream versionIS = FileUtils.loadFromContext((Class)(class$org$apache$muse$tools$generator$util$AbstractCommandLineApp == null ? (class$org$apache$muse$tools$generator$util$AbstractCommandLineApp = AbstractCommandLineApp.class$("org.apache.muse.tools.generator.util.AbstractCommandLineApp")) : class$org$apache$muse$tools$generator$util$AbstractCommandLineApp), (String)PATH_TO_POM_PROPERTIES);
        if (versionIS != null) {
            Properties properties = new Properties();
            try {
                properties.load(versionIS);
                return properties.getProperty(VERSION_PROPERTY);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }

    public static void checkParentDirectory(File destination) throws Exception {
        File parent = destination.getAbsoluteFile().getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            Object[] filler = new Object[]{parent};
            throw new Exception(_MESSAGES.get("CouldNotMakeDir", filler));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

