/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.util;

import com.ibm.wsdl.extensions.schema.SchemaConstants;
import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.util.AbstractCommandLineApp;
import org.apache.muse.tools.generator.util.DefinitionConstants;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefinitionInfo
implements DefinitionConstants {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$util$DefinitionInfo == null ? (class$org$apache$muse$tools$generator$util$DefinitionInfo = DefinitionInfo.class$("org.apache.muse.tools.generator.util.DefinitionInfo")) : class$org$apache$muse$tools$generator$util$DefinitionInfo));
    private Definition _definition;
    private PortType _portType;
    private HashMap _operationNameMap = new HashMap();
    private WSDLFactory _factory;
    private String _uri;
    private String _prefix;
    private int _prefixCounter = 0;
    private Element _propertiesElementSequence;
    private Document _document;
    private Binding _binding;
    private ExtensionRegistry _registry;
    private Schema _schema;
    private Set _schemaImports = new HashSet();
    private HashMap _schemas = new HashMap();
    static /* synthetic */ Class class$org$apache$muse$tools$generator$util$DefinitionInfo;
    static /* synthetic */ Class class$javax$wsdl$Types;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$BindingFault;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingInput;
    static /* synthetic */ Class class$javax$wsdl$Port;

    public DefinitionInfo(Definition definition, String uri) {
        this._uri = uri;
        this._factory = DefinitionInfo.getFactory();
        this._registry = this._factory.newPopulatedExtensionRegistry();
        if (definition == null) {
            this._definition = this.createDefinition();
            this._prefix = this.addPrefix(this._uri);
            this.addPrefix("http://docs.oasis-open.org/wsrf/rp-2");
            this.addPrefix("http://www.w3.org/2005/08/addressing");
        } else {
            this._definition = definition;
        }
        this.extractOperations();
    }

    public DefinitionInfo(String uri) {
        this(null, uri);
    }

    public DefinitionInfo(Definition definition) {
        this(definition, null);
    }

    public Definition getDefinition() {
        return this._definition;
    }

    public Collection getOperations() {
        return this._operationNameMap.values();
    }

    public Types getTypes() {
        return this._definition.getTypes();
    }

    private void extractOperations() {
        Map portTypes = this._definition.getPortTypes();
        if (portTypes.size() != 1) {
            return;
        }
        this._portType = (PortType)portTypes.values().iterator().next();
        Iterator i = this._portType.getOperations().iterator();
        while (i.hasNext()) {
            Operation nextOperation = (Operation)i.next();
            String name = nextOperation.getName();
            this._operationNameMap.put(name, nextOperation);
        }
    }

    private Operation createOperation(Operation operation, Map localMessageMap) {
        String name = operation.getName();
        Operation newOperation = this._definition.createOperation();
        newOperation.setName(name);
        newOperation.setInput(this.createInput(operation.getInput(), localMessageMap));
        newOperation.setOutput(this.createOutput(operation.getOutput(), localMessageMap));
        Iterator i = operation.getFaults().values().iterator();
        while (i.hasNext()) {
            newOperation.addFault(this.createFault((Fault)i.next(), localMessageMap));
        }
        newOperation.setUndefined(false);
        return newOperation;
    }

    private Fault createFault(Fault fault, Map localMessageMap) {
        Fault newFault = this._definition.createFault();
        newFault.setName(fault.getName());
        Message newMessage = this.createMessage(fault.getMessage());
        this._definition.addMessage(newMessage);
        newFault.setMessage(newMessage);
        return newFault;
    }

    private Output createOutput(Output output, Map localMessageMap) {
        Output newOutput = this._definition.createOutput();
        newOutput.setName(output.getName());
        Message newMessage = this.createMessage(output.getMessage());
        this._definition.addMessage(newMessage);
        newOutput.setMessage(newMessage);
        Iterator i = output.getExtensionAttributes().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            Object value = next.getValue();
            Object key = next.getKey();
            newOutput.setExtensionAttribute((QName)key, value);
        }
        return newOutput;
    }

    private Input createInput(Input input, Map localMessageMap) {
        Input newInput = this._definition.createInput();
        newInput.setName(input.getName());
        Message newMessage = this.createMessage(input.getMessage());
        this._definition.addMessage(newMessage);
        newInput.setMessage(newMessage);
        Iterator i = input.getExtensionAttributes().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            Object value = next.getValue();
            Object key = next.getKey();
            newInput.setExtensionAttribute((QName)key, value);
        }
        return newInput;
    }

    private Message createMessage(Message message) {
        Message newMessage = this._definition.createMessage();
        newMessage.setQName(this.makeLocalQName(message.getQName()));
        Iterator i = message.getParts().values().iterator();
        while (i.hasNext()) {
            Part nextPart = (Part)i.next();
            Part newPart = this._definition.createPart();
            newPart.setName(nextPart.getName());
            QName qname = nextPart.getElementName();
            if (qname == null) {
                qname = nextPart.getTypeName();
                newPart.setTypeName(qname);
            } else {
                newPart.setElementName(qname);
            }
            this.addPrefix(qname.getNamespaceURI());
            newMessage.addPart(newPart);
        }
        newMessage.setUndefined(false);
        return newMessage;
    }

    private Definition createDefinition() {
        Definition definition = this._factory.newDefinition();
        definition.setTargetNamespace(this._uri);
        PortType portType = definition.createPortType();
        portType.setQName(new QName(this._uri, "PortType"));
        portType.setExtensionAttribute(WsrpConstants.DEFAULT_DOCUMENT_QNAME, (Object)new QName(this._uri, "ResourceProperties"));
        portType.setUndefined(false);
        definition.addPortType(portType);
        this._schema = (Schema)this.createExtension(class$javax$wsdl$Types == null ? (class$javax$wsdl$Types = DefinitionInfo.class$("javax.wsdl.Types")) : class$javax$wsdl$Types, SchemaConstants.Q_ELEM_XSD_2001);
        this._schema.setElement(this.createEmptyProperties());
        Types types = definition.createTypes();
        types.addExtensibilityElement((ExtensibilityElement)this._schema);
        definition.setTypes(types);
        return definition;
    }

    private Element createEmptyProperties() {
        this._document = XmlUtils.createDocument();
        Element schema = XmlUtils.createElement((Document)this._document, (QName)XsdUtils.SCHEMA_QNAME);
        Element element = XmlUtils.createElement((Document)this._document, (QName)XsdUtils.ELEMENT_QNAME);
        Element complexType = XmlUtils.createElement((Document)this._document, (QName)XsdUtils.COMPLEX_TYPE_QNAME);
        Element sequence = XmlUtils.createElement((Document)this._document, (QName)XsdUtils.SEQUENCE_QNAME);
        complexType.appendChild(sequence);
        element.appendChild(complexType);
        element.setAttribute("name", "ResourceProperties");
        schema.appendChild(element);
        schema.setAttribute("targetNamespace", this._uri);
        this._propertiesElementSequence = sequence;
        return schema;
    }

    public void addOperation(Operation operation, Map localMessageMap) {
        String name = operation.getName();
        if (this._operationNameMap.containsKey(name)) {
            Object[] filler = new Object[]{name};
            AbstractCommandLineApp.handleMessage(_MESSAGES.get("DuplicateOperation", filler));
        }
        Operation newOperation = this.createOperation(operation, localMessageMap);
        this._portType.addOperation(newOperation);
        this._operationNameMap.put(name, newOperation);
    }

    public void addSchema(Schema schema) {
        String uri = schema.getElement().getAttribute("targetNamespace");
        if (uri != null && !this._schemas.containsKey(uri)) {
            this._schemas.put(uri, schema);
            this._definition.getTypes().addExtensibilityElement((ExtensibilityElement)schema);
        }
    }

    public void mergeProperties(DefinitionInfo sourceDefinition) {
        Element[] properties = sourceDefinition.getPropertiesDef();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                Element property = (Element)this._document.importNode(properties[i], true);
                String ref = property.getAttribute("ref");
                QName qname = XmlUtils.parseQName((String)ref, (Element)properties[i]);
                String uri = qname.getNamespaceURI();
                String prefix = this.addPrefix(uri);
                property.setAttribute("ref", this.makeQName(prefix, qname));
                this._propertiesElementSequence.appendChild(property);
                this.addImport(qname);
            }
        }
    }

    private void addImport(QName qname) {
        if (!this._schemaImports.contains(qname.getNamespaceURI())) {
            Element importElement = XmlUtils.createElement((Document)this._schema.getElement().getOwnerDocument(), (QName)XsdUtils.IMPORT_QNAME);
            importElement.setAttribute("namespace", qname.getNamespaceURI());
            Element firstElement = XmlUtils.getFirstElement((Node)this._schema.getElement());
            this._schema.getElement().insertBefore(importElement, firstElement);
            this._schemaImports.add(qname.getNamespaceURI());
        }
    }

    public void createBinding() {
        this._binding = this._definition.createBinding();
        this._binding.setPortType(this._portType);
        this._binding.setQName(new QName(this._uri, "Binding"));
        this._binding.setUndefined(false);
        SOAPBinding binding = (SOAPBinding)this.createExtension(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = DefinitionInfo.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, SOAPConstants.Q_ELEM_SOAP_BINDING);
        binding.setStyle("document");
        this.addPrefix("http://schemas.xmlsoap.org/soap/http");
        this.addPrefix("http://schemas.xmlsoap.org/wsdl/soap/");
        binding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        this._binding.addExtensibilityElement((ExtensibilityElement)binding);
        this._definition.addBinding(this._binding);
        Iterator i = this._portType.getOperations().iterator();
        while (i.hasNext()) {
            BindingOperation bindingOperation = this.createOperationBinding((Operation)i.next());
            this._binding.addBindingOperation(bindingOperation);
        }
    }

    public BindingOperation createOperationBinding(Operation operation) {
        BindingOperation bindingOperation = this._definition.createBindingOperation();
        bindingOperation.setName(operation.getName());
        SOAPOperation soapOperation = (SOAPOperation)this.createExtension(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = DefinitionInfo.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, SOAPConstants.Q_ELEM_SOAP_OPERATION);
        bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
        bindingOperation.setBindingInput(this.createInputBinding(operation.getInput()));
        bindingOperation.setBindingOutput(this.createOutputBinding(operation.getOutput()));
        Iterator i = operation.getFaults().values().iterator();
        while (i.hasNext()) {
            bindingOperation.addBindingFault(this.createFaultBinding((Fault)i.next()));
        }
        return bindingOperation;
    }

    private BindingFault createFaultBinding(Fault fault) {
        BindingFault bindingFault = this._definition.createBindingFault();
        bindingFault.setName(fault.getName());
        SOAPFault soapFault = (SOAPFault)this.createExtension(class$javax$wsdl$BindingFault == null ? (class$javax$wsdl$BindingFault = DefinitionInfo.class$("javax.wsdl.BindingFault")) : class$javax$wsdl$BindingFault, SOAPConstants.Q_ELEM_SOAP_FAULT);
        soapFault.setUse("literal");
        soapFault.setName(fault.getName());
        bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
        return bindingFault;
    }

    private BindingOutput createOutputBinding(Output output) {
        BindingOutput bindingOutput = this._definition.createBindingOutput();
        bindingOutput.setName(output.getName());
        SOAPBody soapBody = (SOAPBody)this.createExtension(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = DefinitionInfo.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, SOAPConstants.Q_ELEM_SOAP_BODY);
        soapBody.setUse("literal");
        ArrayList<String> list = new ArrayList<String>();
        list.add("http://schemas.xmlsoap.org/soap/encoding/");
        soapBody.setEncodingStyles(list);
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
        return bindingOutput;
    }

    private BindingInput createInputBinding(Input input) {
        BindingInput bindingInput = this._definition.createBindingInput();
        bindingInput.setName(input.getName());
        SOAPBody soapBody = (SOAPBody)this.createExtension(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = DefinitionInfo.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, SOAPConstants.Q_ELEM_SOAP_BODY);
        soapBody.setUse("literal");
        ArrayList<String> list = new ArrayList<String>();
        list.add("http://schemas.xmlsoap.org/soap/encoding/");
        soapBody.setEncodingStyles(list);
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
        return bindingInput;
    }

    public void createService(String location) {
        Service service = this._definition.createService();
        service.setQName(new QName(this._uri, "Service"));
        Port port = this._definition.createPort();
        port.setBinding(this._binding);
        port.setName("Port");
        service.addPort(port);
        SOAPAddress soapAddress = (SOAPAddress)this.createExtension(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = DefinitionInfo.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, SOAPConstants.Q_ELEM_SOAP_ADDRESS);
        soapAddress.setLocationURI(location);
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        this._definition.addService(service);
    }

    private String addPrefix(String uri) {
        String prefix = this.getPrefix(uri);
        this._definition.addNamespace(prefix, uri);
        return prefix;
    }

    private Object createExtension(Class targetClass, QName qname) {
        try {
            return this._registry.createExtension(targetClass, qname);
        }
        catch (WSDLException e) {
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("WsdlExtensionFailed"), (Exception)((Object)e));
            return null;
        }
    }

    private QName makeLocalQName(QName name) {
        return new QName(this._uri, name.getLocalPart(), this._prefix);
    }

    private String getPrefix(String uri) {
        String prefix = this._definition.getPrefix(uri);
        if (prefix == null) {
            prefix = "pfx" + this._prefixCounter++;
        }
        return prefix;
    }

    private static WSDLFactory getFactory() {
        try {
            return WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            throw new RuntimeException("Could not get factory");
        }
    }

    private String makeQName(String prefix, QName qname) {
        return prefix + ":" + qname.getLocalPart();
    }

    private Element[] getPropertiesDef() {
        QName qname;
        Element propertiesElement;
        if (this._portType == null) {
            return null;
        }
        Object propertiesDef = this._portType.getExtensionAttribute(WsrpConstants.DEFAULT_DOCUMENT_QNAME);
        if (propertiesDef != null && propertiesDef instanceof QName && (propertiesElement = this.find(qname = (QName)propertiesDef)) != null) {
            return XmlUtils.findInSubTree((Element)propertiesElement, (QName)XsdUtils.ELEMENT_QNAME);
        }
        return null;
    }

    private Element find(QName qname) {
        Types types = this._definition.getTypes();
        Iterator i = types.getExtensibilityElements().iterator();
        while (i.hasNext()) {
            Schema nextSchema;
            Element type;
            Object next = i.next();
            if (!(next instanceof Schema) || (type = WsdlUtils.getElementDeclaration((Node)(nextSchema = (Schema)next).getElement(), (QName)qname)) == null) continue;
            return type;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

