/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.muse.core.AbstractEnvironment;
import org.apache.muse.util.FileUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.addressing.EndpointReference;

public class LocalEnvironment
extends AbstractEnvironment {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$util$LocalEnvironment == null ? (class$org$apache$muse$tools$generator$util$LocalEnvironment = LocalEnvironment.class$("org.apache.muse.tools.generator.util.LocalEnvironment")) : class$org$apache$muse$tools$generator$util$LocalEnvironment));
    private static final URI LOCAL_URI = URI.create("http://localhost");
    private EndpointReference _deploy = new EndpointReference(LOCAL_URI);
    private EndpointReference _target = null;
    private File _realDirectory = null;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$util$LocalEnvironment;

    public LocalEnvironment() {
        this(true);
    }

    public LocalEnvironment(File realDirectory) {
        this(realDirectory, true);
    }

    public LocalEnvironment(boolean createSoapClient) {
        this(FileUtils.CURRENT_DIR, createSoapClient);
    }

    public LocalEnvironment(File realDirectory, boolean createSoapClient) {
        super(createSoapClient);
        this.setRealDirectory(realDirectory);
    }

    public EndpointReference getDeploymentEPR() {
        return new EndpointReference(this._deploy);
    }

    public File getRealDirectory() {
        return this._realDirectory;
    }

    public EndpointReference getTargetEPR() {
        return this._target;
    }

    public final void setRealDirectory(File realDirectory) {
        if (realDirectory == null) {
            throw new NullPointerException(_MESSAGES.get("NullRealDirectory"));
        }
        this._realDirectory = realDirectory;
    }

    public void setTargetEPR(EndpointReference target) {
        this._target = target;
    }

    public URL getDataResource(String path) {
        if (path == null) {
            throw new NullPointerException(_MESSAGES.get("NullResourcePath"));
        }
        File file = new File(this._realDirectory, path);
        try {
            return file.toURL();
        }
        catch (MalformedURLException error) {
            throw new RuntimeException(error);
        }
    }

    public InputStream getDataResourceStream(String path) {
        if (path == null) {
            throw new NullPointerException(_MESSAGES.get("NullResourcePath"));
        }
        File file = new File(this.getRealDirectory(), path);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException error) {
            Object[] filler = new Object[]{file.getAbsolutePath()};
            String message = _MESSAGES.get("InvalidFile", filler);
            throw new RuntimeException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

