/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;

public class OverwriteHelper {
    private static final String COMMENT_CHAR = "#";
    private static final String OVERWRITE_MANIFEST_FILE = ".overwrite";
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$util$OverwriteHelper == null ? (class$org$apache$muse$tools$generator$util$OverwriteHelper = OverwriteHelper.class$("org.apache.muse.tools.generator.util.OverwriteHelper")) : class$org$apache$muse$tools$generator$util$OverwriteHelper));
    private Set _overwriteSet = null;
    private boolean _overwriteAll = false;
    private boolean _modifiable;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$util$OverwriteHelper;

    public OverwriteHelper(File targetDirectory, boolean overwriteAll) {
        this._overwriteSet = this.loadOverwriteSet(targetDirectory);
        this._overwriteAll = overwriteAll;
        if (this._overwriteSet == null) {
            this._overwriteSet = new HashSet();
            this._modifiable = true;
        } else {
            this._modifiable = this.canOverwrite(new File(targetDirectory, OVERWRITE_MANIFEST_FILE), targetDirectory);
            if (this._modifiable) {
                this._overwriteAll = true;
            }
        }
    }

    public boolean canOverwrite(File file, File directory) {
        return !file.exists() || this._overwriteAll || this.overwriteSetContains(file, directory);
    }

    private boolean overwriteSetContains(File file, File directory) {
        return this._overwriteSet.contains(this.getBaseFile(file, directory));
    }

    private File getBaseFile(File file, File directory) {
        try {
            String basePath = directory.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            return new File(filePath.substring(basePath.length() + 1));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private Set loadOverwriteSet(File targetDirectory) {
        File overwriteManifest = new File(targetDirectory, OVERWRITE_MANIFEST_FILE);
        if (!overwriteManifest.exists()) {
            return null;
        }
        HashSet<File> overwriteSet = new HashSet<File>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(overwriteManifest));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(COMMENT_CHAR)) continue;
                overwriteSet.add(new File(line));
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(_MESSAGES.get("FailedOverwriteManifest"), e);
        }
        return overwriteSet;
    }

    public void writeToDirectory(File directory) throws Exception {
        File overwriteManifest = new File(directory, OVERWRITE_MANIFEST_FILE);
        if (this.canOverwrite(overwriteManifest, directory)) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(overwriteManifest));
            Object[] files = this._overwriteSet.toArray();
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                bw.write(files[i].toString() + "\n");
            }
            bw.close();
        }
    }

    public void add(File file, File directory) {
        if (this._modifiable) {
            this._overwriteSet.add(this.getBaseFile(file, directory));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

