/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.birt.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.dc.birt.helper.CBESeverityCount;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.spi.OutboundContext;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.cosmos.dc.runtime.RetryException;
import org.eclipse.cosmos.dc.spec.capabilitiy.CBEQueryCapability;
import org.eclipse.cosmos.dc.spec.capabilitiy.StatisticalQueryCapability;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalHelper {
    private static LocalHelper instance = new LocalHelper();
    private static RuntimeHost host;

    public static LocalHelper getLocalHelperInstance() {
        return instance;
    }

    public void setRuntimeHost(RuntimeHost host) {
        LocalHelper.host = host;
        host.getRegistry();
    }

    protected void verifyRuntimeHost() throws Exception {
        if (host == null) {
            throw new RetryException("COSMOS Runtime Host not initialized");
        }
    }

    public String[] getDatasetsForSourceKeyset(String source, String keyset) throws Exception {
        this.verifyRuntimeHost();
        ProviderRegistry reg = host.getRegistry();
        System.out.println("Database Home is " + System.getProperty("derby.system.home"));
        System.out.println("Getting dataset list");
        Collection ds = reg.getDataSetsForSource(source);
        ArrayList<String> list = new ArrayList<String>();
        if (ds != null) {
            for (DataSet set : ds) {
                if (!set.getDataFlow().getDimensionSet().getName().equals(keyset)) continue;
                try {
                    this.getStatDataForSource(set.getName(), keyset, 0, 1000);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                list.add(set.getName());
                System.out.println("Adding dataset:" + set.getName());
            }
        }
        System.out.println("Returning " + list.size() + " datasets");
        System.out.println("Database Home is " + System.getProperty("derby.system.home"));
        return list.toArray(new String[0]);
    }

    public String getLatestDatasetForSourceKeyset(String source, String keyset) throws Exception {
        this.verifyRuntimeHost();
        ProviderRegistry reg = host.getRegistry();
        DataSet ds = reg.getLatestDataSetForSourceKeyset(source, keyset);
        if (ds != null) {
            return ds.getName();
        }
        return null;
    }

    public Collection<StatisticalTuple> getStatDataForSource(String dataset, String keyset, int start, int size) throws Exception {
        this.verifyRuntimeHost();
        IDataCollectionContext context = host.loadContext("StatQuery.xml");
        context.materialize();
        OutboundContext outbound = (OutboundContext)context;
        IDataQueryService rootQuery = outbound.getRootQuery();
        DataSet set = host.getRegistry().getDataSet(dataset);
        if (rootQuery instanceof StatisticalQueryCapability) {
            StatisticalQueryCapability statQuery = (StatisticalQueryCapability)rootQuery;
            IDataQueryResult result = statQuery.keysetQuery("StatisticalTuple", dataset, keyset, set.getStart(), set.getStop());
            System.out.println("Statquery Returning:" + result.getRawResponseCollection().size());
            return result.getRawResponseCollection();
        }
        return null;
    }

    public Collection<CommonBaseEvent> getAllCBE(String dataset) throws Exception {
        this.verifyRuntimeHost();
        IDataCollectionContext context = host.loadContext("CBEQuery.xml");
        context.materialize();
        OutboundContext outbound = (OutboundContext)context;
        IDataQueryService rootQuery = outbound.getRootQuery();
        if (rootQuery instanceof CBEQueryCapability) {
            CBEQueryCapability cbeQuery = (CBEQueryCapability)rootQuery;
            IDataQueryResult result = cbeQuery.getAllCBE(dataset);
            return result.getRawResponseCollection();
        }
        return null;
    }

    @Deprecated
    public Collection<CBESeverityCount> getCBECountBySeverity(String dataset) throws Exception {
        return null;
    }
}

