/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.broker.client.BrokerClient;
import org.w3c.dom.Element;

public class BrokerTestClient {
    private BrokerClient brokerClient = null;
    static BrokerTestClient brokerTest = new BrokerTestClient();

    public void registerBroker() {
        if (this.brokerClient == null) {
            EndpointReference epr = null;
            epr = this.getBrokerEpr();
            this.brokerClient = new BrokerClient(epr);
        }
        if (this.brokerClient != null) {
            try {
                this.brokerClient.register();
                System.out.println("Broker has been registered with management domain.");
            }
            catch (Exception e) {
                System.err.println("Unable to register broker with management domain.");
            }
        }
    }

    private EndpointReference getBrokerEpr() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Broker EPR (terminate by an empty line):");
        StringBuffer eprBuffer = new StringBuffer();
        try {
            String line;
            while (!(line = br.readLine()).trim().equals("")) {
                eprBuffer.append(line);
            }
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read broker EPR");
            return null;
        }
        try {
            Element eprElement = XmlUtils.createDocument((String)eprBuffer.toString()).getDocumentElement();
            EndpointReference epr = new EndpointReference(eprElement);
            return epr;
        }
        catch (Exception e) {
            System.err.println("Invalid EPR");
            return null;
        }
    }

    public void getDataManagers(String classfication) {
        if (this.brokerClient == null) {
            EndpointReference epr = null;
            epr = this.getBrokerEpr();
            this.brokerClient = new BrokerClient(epr);
        }
        if (this.brokerClient != null) {
            try {
                String[] eprs = this.brokerClient.getAllServices();
                if (eprs.length == 0) {
                    System.out.println("No data managers are registered.");
                } else {
                    System.out.println("EPR of data mangers:");
                    int i = 0;
                    while (i < eprs.length) {
                        System.out.println("Data Manager " + (i + 1) + ":");
                        System.out.println(eprs[i]);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error occurred while retrieving data manager EPRs.");
            }
        }
    }

    public void handleCommand(String commandline) {
        StringTokenizer st = new StringTokenizer(commandline);
        if (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (command.equals("register")) {
                this.registerBroker();
            } else if (command.equals("getDataManagers")) {
                String classfication = "";
                if (st.hasMoreElements()) {
                    classfication = st.nextToken();
                    this.getDataManagers(classfication);
                } else {
                    this.getDataManagers("all");
                }
            } else {
                BrokerTestClient.printusage();
            }
        }
    }

    public static void printusage() {
        System.out.println("Commands: \nbroker register\nbroker getDataManagers\nexit");
    }
}

