/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.logging.datamgr.client.LoggingDataManagerClient;
import org.eclipse.cosmos.dc.logging.datamgr.common.CBESeverityCount;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;

public class LoggingTestClient {
    public void getAllCBE(String logfile) {
        Object address = null;
        LoggingDataManagerClient dmc = null;
        Collection e = null;
        CommonBaseEvent c2 = null;
        EndpointReference epr = this.getDataManagerEpr();
        dmc = new LoggingDataManagerClient(epr);
        try {
            e = dmc.getAllCBE(logfile);
        }
        catch (CosmosException ex) {
            System.out.println("Request failed.");
        }
        if (e != null) {
            for (CommonBaseEvent c2 : e) {
                System.out.println(c2.toString());
            }
        } else {
            System.out.println("No CBEs were returned.");
        }
    }

    void getCBECountBySeverity(String logfile) {
        Object address = null;
        LoggingDataManagerClient dmc = null;
        Collection sev = null;
        Iterator I = null;
        CBESeverityCount s2 = null;
        EndpointReference epr = this.getDataManagerEpr();
        dmc = new LoggingDataManagerClient(epr);
        try {
            sev = dmc.getCBECountBySeverity(logfile);
        }
        catch (CosmosException ex) {
            ex.printStackTrace();
            System.out.println("Request failed.");
        }
        if (sev != null) {
            for (CBESeverityCount s2 : sev) {
                s2.Print();
            }
        } else {
            System.out.println("No CBEs were returned.");
        }
    }

    public static void printusage() {
        System.out.println("Commands: \nlogging getDatasets\nlogging getAllCBE\nlogging getCBECountBySeverity");
    }

    public void handleCommand(String commandline) {
        StringTokenizer st = new StringTokenizer(commandline);
        if (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (command.equals("getDatasets")) {
                this.getDatasets();
            } else if (command.equals("getAllCBE")) {
                if (st.hasMoreElements()) {
                    String logfile = st.nextToken();
                    this.getAllCBE(logfile);
                } else {
                    LoggingTestClient.printusage();
                }
            } else if (command.equals("getCBECountBySeverity")) {
                if (st.hasMoreElements()) {
                    String logfile = st.nextToken();
                    this.getCBECountBySeverity(logfile);
                } else {
                    LoggingTestClient.printusage();
                }
            } else {
                LoggingTestClient.printusage();
            }
        }
    }

    public void getDatasets() {
        Object address = null;
        LoggingDataManagerClient dmc = null;
        Collection ret = null;
        Iterator I = null;
        String l2 = null;
        EndpointReference epr = this.getDataManagerEpr();
        dmc = new LoggingDataManagerClient(epr);
        try {
            ret = dmc.getDatasets();
        }
        catch (CosmosException ex) {
            System.out.println("Request failed.");
        }
        if (ret != null) {
            for (String l2 : ret) {
                System.out.println(l2);
            }
        } else {
            System.out.println("No datasets were returned.");
        }
    }

    private EndpointReference getDataManagerEpr() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("DataManager EPR (terminate by an empty line):");
        StringBuffer eprBuffer = new StringBuffer();
        try {
            String line;
            while (!(line = br.readLine()).trim().equals("")) {
                eprBuffer.append(line);
            }
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read DataManager EPR");
            return null;
        }
        try {
            Element eprElement = XmlUtils.createDocument((String)eprBuffer.toString()).getDocumentElement();
            EndpointReference epr = new EndpointReference(eprElement);
            return epr;
        }
        catch (Exception e) {
            System.err.println("Invalid EPR");
            return null;
        }
    }
}

