/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts.ItemReference;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipEndpoint;

public class RelationshipEndpoint
extends ItemReference
implements IRelationshipEndpoint {
    private int minimum;
    private int maximum;
    private int type;

    public RelationshipEndpoint(int type) {
        this.type = type;
        this.minimum = -1;
        this.maximum = -1;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public int getType() {
        return this.type;
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        String relationshipType = this.getType() == 0 ? "sourceTemplate" : "targetTemplate";
        writer.write("<" + relationshipType + " ");
        CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"ref", (String)this.getRef().getId());
        if (this.getMinimum() != -1) {
            writer.write(" ");
            CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"minimum", (String)Integer.toString(this.getMinimum()));
        }
        if (this.getMaximum() != -1) {
            writer.write(" ");
            CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"maximum", (String)Integer.toString(this.getMaximum()));
        }
        writer.write("/>" + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.maximum;
        result = 31 * result + this.minimum;
        result = 31 * result + (this.getRef() == null ? 0 : this.getRef().hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationshipEndpoint other = (RelationshipEndpoint)obj;
        if (this.maximum != other.maximum) {
            return false;
        }
        if (this.minimum != other.minimum) {
            return false;
        }
        if (this.getRef() == null ? other.getRef() != null : !this.getRef().equals(other.getRef())) {
            return false;
        }
        return this.type == other.type;
    }
}

