/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.script.FilterPassController;
import org.eclipse.birt.data.engine.script.NEvaluator;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static boolean isFilterNeedMultiPass(IFilterDefinition filter) {
        return filter.getExpression() instanceof IConditionalExpression && FilterUtil.isMultiPassFilterOperator(((IConditionalExpression)filter.getExpression()).getOperator());
    }

    private static boolean isMultiPassFilterOperator(int operatorId) {
        return operatorId == 15 || operatorId == 17 || operatorId == 14 || operatorId == 16;
    }

    public static void prepareFilterExpression(IBaseExpression expr, FilterPassController filterPass, IExecutorHelper helper) throws DataException {
        ConditionalExpression ce;
        int operator;
        if (expr instanceof IConditionalExpression && ((operator = (ce = (ConditionalExpression)expr).getOperator()) == 14 || operator == 16 || operator == 15 || operator == 17)) {
            Object handle = expr.getHandle();
            if (handle instanceof NEvaluator) {
                return;
            }
            NEvaluator evaluator = NEvaluator.newInstance(operator, ce.getExpression(), ce.getOperand1(), filterPass, helper);
            expr.setHandle(evaluator);
        }
    }

    public static boolean hasMultiPassFilters(FilterByRow filterByRow) throws DataException {
        if (filterByRow == null) {
            return false;
        }
        if (filterByRow.isFilterSetExist(5)) {
            return true;
        }
        if (filterByRow.isFilterSetExist(2)) {
            return true;
        }
        List list = filterByRow.getFilterList(3);
        if (list == null) {
            return false;
        }
        int j = 0;
        while (j < list.size()) {
            if (FilterUtil.isFilterNeedMultiPass((IFilterDefinition)list.get(j))) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static boolean hasMutipassFilters(List list) {
        int j = 0;
        while (j < list.size()) {
            if (FilterUtil.isFilterNeedMultiPass((IFilterDefinition)list.get(j))) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

