/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator");
dojo.require("dijit.Menu");
dojo.require("dijit.Tree");
dojo.require("dijit.TitlePane");
dojo.require("dijit.layout.ContentPane");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore");


dojo.declare(
	// class
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator",

	// superclass	
	[dijit.Tree],
	
	// member variables/functions
	{
	    initQueryHandler: null,
	    initQuery: null,
		create: function(params, srcNodeRef) {
			if (params.initQueryHandler != null){
				if ((params.contextMap) && (params.contextMap.object)){
					params.initQueryHandler = params.initQueryHandler+"&id="+params.contextMap.object;
				}
				params.store=new org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore({url:params.initQueryHandler});
				params.store.UIContext = params.UIContext;														
				org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.create.apply(this, arguments);
			}
		},
		getIconClass: function(/*dojo.data.Item*/ item){
			// summary: user overridable function to return CSS class name to display icon
		    if ((item) && (item.nodeClass)){
				initParam = this.dataMap[item.nodeClass];
				if (initParam){
					return initParam.icon;
					}
			}			
		},		
		postMixInProperties: function(){
			//call superclass
			var cell = document.createElement("ul");
			cell.setAttribute("style", "display:none;");
			cell.setAttribute("id", this.id+"_menu");
			this.parentWidget.domNode.appendChild(cell);
			this.menu = new dijit.Menu({},cell);	
			org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.postMixInProperties.apply(this, arguments);
		},
		createContextMenu: function(e){
			var menu = this.menu;
			this.menu.getChildren().forEach(function(i){menu.removeChild(i);});
			var tn = dijit.getEnclosingWidget(e.target);
			var itemMap = this.dataMap[tn.item.nodeClass];
			var contextMenuFactory = null;
			if ((itemMap) && (itemMap.menuType)){
				contextMenuFactory = this.UIContext.createObject(itemMap.menuType);
			}
			
			if (contextMenuFactory != null){
				contextMenuFactory.sourceObject=this;			
				contextMenuFactory.createContextMenu(this.menu,tn,tn.item.nodeClass);
			}
		},
	    treeHandler: function(message){
		  if (message.event != 'execute') {
    		return;
  			}
			if (typeof(this.publish) != 'undefined'){
					for (i=0;i < this.publish.length;i++){
					 	    //lets clone the information we're going to send to another widget since we don't want the other
					 	    //widget modifying our content
							var cloneMap = new Object();
					 	    dojo.mixin(cloneMap,message.node.item);
					 	    //let tag the data we're going to send so that the consumer of this data knows where the data came from
					 	    cloneMap.nodeClass = this.attachPoint + " " +cloneMap.nodeClass;
							dojo.publish(this.publish[i], [{contextMap:cloneMap}]);
		 			}
 			}	    
	    },
		mayHaveChildren: function(/*dojo.data.Item*/ item){
			var initParam = this.dataMap[item.nodeClass];
			var hasChildren = false;			
			//check to see if this node has an expand query
			if ((initParam) && (typeof(initParam['expandQuery'])!='undefined')){
				//append query to item so that we don't have to make lookup again
				item.expandQuery = initParam.expandQuery;
				hasChildren = true;
			}						
			else{		
				hasChildren = org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.mayHaveChildren.apply(this, arguments);
			}
			return hasChildren;
	
		},
		makeNodeFolder: function(el){
		    if (el.item.nodeClass){
				initParam = this.dataMap[el.item.nodeClass];			
				if (initParam){
						//check to see if this node has an expand query
						if (typeof(initParam['expandQuery'])!='undefined'){
							el.item.isExpandable = true;
							}
				}
		    }
			dojo.connect(el,"addChild", this, "makeNodeFolder");
		},	    
		postCreate: function(){
			// when we right-click anywhere on the tree, make sure we open the menu		  	
			this.menu.bindDomNode(this.domNode);				
			dojo.connect(this.menu, "_openMyself", this, this.createContextMenu);
			//subscribe to node selection topic
		  	dojo.subscribe(this.id, this, this.treeHandler);
		  	dojo.connect(this, "addChild", this, this.makeNodeFolder);
			org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.postCreate.apply(this, arguments);
		},
		addTreeNode:function(newItem, parent){
		// summary:
		//		Add a item to a node.
			console.debug(parent);
			if (typeof(parent) == 'undefined')
				parent = this.treeNode.item;
			try{
				if (dojo.isArray(newItem)) {
					for (var x=0; x < newItem.length; x++){
						this.addTreeNode(newItem[x], parent);			   
					}
				}
				else{		
				
					var parentObject = this.store.newItem(newItem, {parent:parent,attribute:'children'});
					//expand parent node
					var parentNode = this._itemNodeMap[this.store.getIdentity(parent)];
					this._expandNode(parentNode);
					
				}
			}catch(e){
				cosmos.log.logError(e);
			}
		},	
		deleteTreeNode:function(treeNode){
		// summary:
		//		Remove a node from the tree.					
			this.store.deleteItem(treeNode);
		},		
		getItemChildren: function(parentItem, onComplete){
			// summary
			// 		User overridable function that return array of child items of given parent item,
			//		or if parentItem==null then return top items in tree
			var store = this.store;
			if(parentItem == null){
				// get top level nodes
				store.fetch({ query: this.query, onComplete: onComplete});
			}else{
				// get children of specified node
				var childItems = [];
				var self = this;
				function setChildrenArray(children){
					childItems= childItems.concat(children);
					// count how many items need to be loaded
					var _waitCount = 0;
					dojo.forEach(childItems, function(item){ if(!store.isItemLoaded(item)){ _waitCount++; } });
					if(_waitCount == 0){
						// all items are already loaded.  proceed..
						onComplete(childItems);
					}else{
						// still waiting for some or all of the items to load
						function onItem(item){
							if(--_waitCount == 0){
								// all nodes have been loaded, send them to the tree
								onComplete(childItems);
							}
						}
						dojo.forEach(childItems, function(item){
							if(!store.isItemLoaded(item)){
								store.loadItem({item: item, onItem: onItem});
							}
						});
					}
				}
				
				//only support 1 child attribute
				store.getValues(parentItem, this.childrenAttr[0], setChildrenArray);				
			}
		}
	}
	
);	

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryMenu",
	// superclass	
	null,
	{
		constructor: function(params){
			dojo.mixin(this,params);
		},
		widgetClass:'cosmos:QueryMenu',
		cmdbfQuery:null,
		createContextMenu: function(menu, store, className){
			//check for specific node class
			this.populateMenu(menu, store, className);
		},
		populateMenu:function(menu, store, className){
			var self = this;
			menu.addChild(new dijit.MenuItem({item:this,UIContext:this.UIContext, store:store, sourceObject: this.sourceObject,onClick:function(){
				var sourceObject = this.sourceObject; 
				var store = this.store;
				console.debug('sourceObjecdt');
				console.debug(sourceObject);
		    	var queryObject = this.UIContext.createObject(self.query);
				this.UIContext.submitQuery({queryObject:queryObject, item:store.item, onItem:function(items){
					sourceObject.addTreeNode(items.items, store.item);
					}, queryProp:"query"});
			},
			label:this.label
			}));
		}
	}
);

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.RemoveMenu",
	// superclass	
	org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryMenu,
	{
		widgetClass:'cosmos:RemoveMenu',
		createContextMenu: function(menu, store, className){
			this.inherited(arguments);
		},
		populateMenu:function(menu, store, className){
			menu.addChild(new dijit.MenuItem({onClick:function(){
				store.tree.deleteTreeNode(store.item);
			},
			label:this.label
			}));
		}
	}
); 
