/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.Report");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportMenu",
	// superclass	
	null,
	{
		constructor: function(params){
			dojo.mixin(this,params);
		},
		createContextMenu: function(menu, store, className){
			//check for specific node class
			this.populateMenu(menu, store, className);
		},
		populateMenu:function(menu, store, className){
			var self = this;
	    	var queryObject = this.UIContext.createObject(this.query);
			this.UIContext.submitQuery({queryObject:queryObject, item:store.item, onItem:function(items){
				for (i=0;i < items.length;i++){
					menu.addChild(new dijit.MenuItem({item:store.item,publish:self.publish, value:items[i], onClick:function(){
						if (typeof(this.publish) != 'undefined'){
							//clone item since we don't want to modify the original item
							var contextMap = this.item;
							dojo.mixin(contextMap, this.value);
							for (y=0;y < this.publish.length;y++){
								dojo.publish(this.publish[y], [{contextMap:contextMap}]);
				 			}
						}	    
						
					},
					label:items[i].caption
					}));				
				}
			}, queryProp:"query"});
			
		}
	}
);

//This demonstrates a query unit   
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportQuery",
	// superclass	
   [org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery],
	{
		bindInput: function(data, callbackMethod){		
				callbackMethod("func=list&value="+data.classification);
		}
	}
); 

dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportContentQuery",
			// superclass	
		   [org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery],
			{
				URLEncode: function(sStr) {
			    return escape(sStr)
		  			.replace(/\+/g, '%2B')
		     			.replace(/\"/g,'%22')
		        			.replace(/\'/g, '%27');
				}
			}
		); 

		     			
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.CBEReportContentQuery",
	// superclass	
   [org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportContentQuery],
	{
		bindInput: function(data, callbackMethod){
			if ((typeof(data)!= 'undefined') && (typeof(data.value) != 'undefined') && (typeof(data.epr)!= 'undefined')){
				console.debug(data);
	    		var reportId = this.URLEncode(data.value);	
				var logfile = this.URLEncode(data.logfile);
				var epr = this.URLEncode(data.epr);
				console.debug(epr + "here");
				callbackMethod("func=url&reportId="+reportId+"&EPR="+epr+"&LogFile="+logfile);
				return true;
			}
			else{
				return false;
			}
		}
	}
); 

dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.StatReportContentQuery",
			// superclass	
		   [org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportContentQuery],
			{
				bindInput: function(data, callbackMethod){
					if ((typeof(data)!= 'undefined') && (typeof(data.value) != 'undefined') && (typeof(data.epr)!= 'undefined')){
						console.debug(data);
			    		var reportId = this.URLEncode(data.value);	
						var datasource = this.URLEncode(data.datasource);
						var keyset = this.URLEncode(data.classification);
						var epr = this.URLEncode(data.epr);
						console.debug(epr + "here");
						callbackMethod("func=url&reportId="+reportId+"&EPR="+epr+"&DataSource="+datasource+"&KeySet="+keyset);
						return true;
					}
					else{
						return false;
					}
				}
			}
		); 