/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.logging.datamgr.api;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResourceCapability;
import org.w3c.dom.Element;

@ManagedResourceCapability(namespace=ILogEventCollector.NAMESPACE_URI)
public interface ILogEventCollector {
	
	public static final String NAMESPACE_URI = "http://www.eclipse.org/cosmos/logEventCollector";
	
	String PREFIX = "cbe";
	
	String GET_LOG_ID_OP_URI = NAMESPACE_URI + "/getLogFileIdentifiers";
	QName GET_LOG_ID_OP_QNAME = new QName(NAMESPACE_URI, "getLogFileIdentifiers", PREFIX);
	
	String GET_ALL_CBE_OP_URI = NAMESPACE_URI + "/getCBEs";
	QName GET_ALL_CBE_OP_QNAME = new QName(NAMESPACE_URI, "getAllCBE", PREFIX);
	QName GET_ALL_CBE_LOG_FILE_QNAME = new QName(GET_ALL_CBE_OP_URI, "logfile", PREFIX);

	String GET_CBE_COUNT_BY_SEV_OP_URI = NAMESPACE_URI + "/getCBECountBySeverity";
	QName GET_CBE_COUNT_BY_SEV_OP_QNAME = new QName(NAMESPACE_URI, "getCBECountBySeverity", PREFIX);
	QName GET_CBE_COUNT_BY_SEV_LOG_FILE_QNAME = new QName(GET_CBE_COUNT_BY_SEV_OP_URI, "logfile", PREFIX);

	@ManagedOperation
	public String[] getLogFileIdentifiers() throws CosmosException;

	@ManagedOperation
	public Element getCBEs(String logfile) throws CosmosException;
	
	@ManagedOperation
	public String[] getCBESeverityCount(String logfile) throws CosmosException;
	
}
