/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class ResultSetUtil {
    public static void writeResultObject(DataOutputStream dos, IResultObject resultObject, int count, Set nameSet) throws DataException, IOException {
        if (resultObject.getResultClass() == null) {
            return;
        }
        int i = 1;
        while (i <= count) {
            if (nameSet != null && (nameSet.contains(resultObject.getResultClass().getFieldName(i)) || nameSet.contains(resultObject.getResultClass().getFieldAlias(i)))) {
                IOUtil.writeObject((DataOutputStream)dos, (Object)resultObject.getFieldValue(i));
            }
            ++i;
        }
    }

    public static IResultObject readResultObject(DataInputStream dis, IResultClass rsMeta, int count) throws IOException {
        Object[] obs = new Object[count];
        int i = 0;
        while (i < count) {
            obs[i] = IOUtil.readObject((DataInputStream)dis);
            ++i;
        }
        return new ResultObject(rsMeta, obs);
    }

    public static Set getRsColumnRequestMap(Map cacheRequestMap) throws DataException {
        HashSet resultSetNameSet = new HashSet();
        if (cacheRequestMap != null) {
            Set exprSet = cacheRequestMap.entrySet();
            Iterator iter = exprSet.iterator();
            List dataSetColumnList = null;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                List list = dataSetColumnList = entry.getValue() == null ? null : ExpressionCompilerUtil.extractDataSetColumnExpression(((IBinding)entry.getValue()).getExpression());
                if (dataSetColumnList == null) continue;
                resultSetNameSet.addAll(dataSetColumnList);
            }
        }
        return resultSetNameSet;
    }
}

