/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.script.JSMethodRunner;
import org.mozilla.javascript.Scriptable;

public class DataSourceJSEventHandler
implements IBaseDataSourceEventHandler {
    private IBaseDataSourceDesign design;
    private JSMethodRunner runner;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.DataSourceJSEventHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DataSourceJSEventHandler(IBaseDataSourceDesign dataSourceDesign) {
        if (!$assertionsDisabled && dataSourceDesign == null) {
            throw new AssertionError();
        }
        this.design = dataSourceDesign;
    }

    protected IBaseDataSourceDesign getBaseDesign() {
        return this.design;
    }

    protected JSMethodRunner getRunner(Scriptable scope) {
        if (this.runner == null) {
            String scopeName = "DataSource[" + this.design.getName() + "]";
            this.runner = new JSMethodRunner(scope, scopeName);
        }
        return this.runner;
    }

    public void handleBeforeOpen(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getBeforeOpenScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("beforeOpen", script);
        }
    }

    public void handleBeforeClose(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getBeforeCloseScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("beforeClose", script);
        }
    }

    public void handleAfterOpen(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getAfterOpenScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("afterOpen", script);
        }
    }

    public void handleAfterClose(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getAfterCloseScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("afterClose", script);
        }
    }
}

