/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.sql.Date;
import java.sql.Time;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.script.DataExceptionMocker;
import org.eclipse.birt.data.engine.script.NEvaluator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ScriptEvalUtil {
    private static Logger logger;
    private static Pattern s_JSReExprPattern;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.ScriptEvalUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    private ScriptEvalUtil() {
    }

    public static ExprTextAndValue newExprInfo(String exprText, Object value) {
        return ExprTextAndValue.newInstance(exprText, value);
    }

    public static Object evalConditionalExpr(Object obj, int operator, Object o1, Object o2) throws DataException {
        Class<?> clazz;
        ExprTextAndValue op1 = ScriptEvalUtil.createExprTextAndValueInstance(o1);
        ExprTextAndValue op2 = ScriptEvalUtil.createExprTextAndValueInstance(o2);
        Object resultObject = obj;
        Object resultOp1 = op1.value;
        Object resultOp2 = op2.value;
        Object[] obArray = MiscUtil.isComparable(obj, operator, op1, op2);
        if (obArray != null) {
            resultObject = obArray[0];
            resultOp1 = obArray[1];
            resultOp2 = obArray[2];
        }
        if (logger.isLoggable(Level.FINER)) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.ScriptEvalUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz2.getName(), "evalConditionalExpr", "evalConditionalExpr() resultObject=" + LogUtil.toString(resultObject) + ", operator=" + operator + (resultOp1 == null ? null : ", resultOp1=" + LogUtil.toString(resultOp1)) + (resultOp2 == null ? null : ", resultOp2=" + LogUtil.toString(resultOp2)));
        }
        boolean result = false;
        switch (operator) {
            case 1: {
                result = ScriptEvalUtil.compare(resultObject, resultOp1) == 0;
                break;
            }
            case 2: {
                result = ScriptEvalUtil.compare(resultObject, resultOp1) != 0;
                break;
            }
            case 3: {
                result = ScriptEvalUtil.compare(resultObject, resultOp1) < 0;
                break;
            }
            case 4: {
                result = ScriptEvalUtil.compare(resultObject, resultOp1) <= 0;
                break;
            }
            case 5: {
                result = ScriptEvalUtil.compare(resultObject, resultOp1) >= 0;
                break;
            }
            case 6: {
                result = ScriptEvalUtil.compare(resultObject, resultOp1) > 0;
                break;
            }
            case 7: {
                result = ScriptEvalUtil.between(resultObject, resultOp1, resultOp2);
                break;
            }
            case 8: {
                result = !ScriptEvalUtil.between(resultObject, resultOp1, resultOp2);
                break;
            }
            case 9: {
                result = resultObject == null;
                break;
            }
            case 10: {
                result = resultObject != null;
                break;
            }
            case 11: {
                result = ScriptEvalUtil.isTrueOrFalse(resultObject, Boolean.TRUE);
                break;
            }
            case 12: {
                result = ScriptEvalUtil.isTrueOrFalse(resultObject, Boolean.FALSE);
                break;
            }
            case 13: {
                result = ScriptEvalUtil.like(resultObject, resultOp1);
                break;
            }
            case 20: {
                result = !ScriptEvalUtil.like(resultObject, resultOp1);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                throw new DataException("data.engine.UnsupportedCondOp", "Top/Bottom(N) outside of row filters");
            }
            case 19: {
                result = ScriptEvalUtil.match(resultObject, resultOp1);
                break;
            }
            case 21: {
                result = !ScriptEvalUtil.match(resultObject, resultOp1);
                break;
            }
            default: {
                throw new DataException("data.engine.UnsupportedCondOp", new Integer(operator));
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.ScriptEvalUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "evalConditionalExpr", new Boolean(result));
        return new Boolean(result);
    }

    private static ExprTextAndValue createExprTextAndValueInstance(Object o) {
        ExprTextAndValue op = !(o instanceof ExprTextAndValue) ? ExprTextAndValue.newInstance("", o) : (ExprTextAndValue)o;
        return op;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int compare(Object obj1, Object obj2) throws DataException {
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            return 0;
        }
        try {
            if (MiscUtil.isSameType(obj1, obj2)) {
                if (obj1 instanceof Boolean) {
                    if (obj1.equals(obj2)) {
                        return 0;
                    }
                    Boolean bool = (Boolean)obj1;
                    if (bool.equals(Boolean.TRUE)) {
                        return 1;
                    }
                    return -1;
                }
                if (obj1 instanceof Comparable) {
                    return ((Comparable)obj1).compareTo(obj2);
                }
                return obj1.toString().compareTo(obj2.toString());
            }
            if (MiscUtil.isNumericOrString(obj1) && MiscUtil.isNumericOrString(obj2)) {
                try {
                    return DataTypeUtil.toDouble((Object)obj1).compareTo(DataTypeUtil.toDouble((Object)obj2));
                }
                catch (Exception exception) {
                    return DataTypeUtil.toString((Object)obj1).compareTo(DataTypeUtil.toString((Object)obj2));
                }
            }
            if (MiscUtil.isDateOrString(obj1) && MiscUtil.isDateOrString(obj2)) {
                try {
                    return DataTypeUtil.toDate((Object)obj1).compareTo(DataTypeUtil.toDate((Object)obj2));
                }
                catch (Exception exception) {
                    return DataTypeUtil.toString((Object)obj1).compareTo(DataTypeUtil.toString((Object)obj2));
                }
            }
            if (MiscUtil.isBooleanOrString(obj1) && MiscUtil.isBooleanOrString(obj2)) {
                try {
                    boolean b1 = DataTypeUtil.toBoolean((Object)obj1);
                    boolean b2 = DataTypeUtil.toBoolean((Object)obj2);
                    if (b1 == b2) {
                        return 0;
                    }
                    if (!b1 && b2) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception exception) {
                    return DataTypeUtil.toString((Object)obj1).compareTo(DataTypeUtil.toString((Object)obj2));
                }
            }
            throw new DataException("data.engine.BadDataTypeCondExpr");
        }
        catch (BirtException e) {
            throw new DataException("data.engine.DataConversionError", e);
        }
    }

    private static boolean between(Object resultObject, Object resultOp1, Object resultOp2) throws DataException {
        Object max;
        Object min;
        if (ScriptEvalUtil.compare(resultOp1, resultOp2) <= 0) {
            min = resultOp1;
            max = resultOp2;
        } else {
            min = resultOp2;
            max = resultOp1;
        }
        return ScriptEvalUtil.compare(resultObject, min) >= 0 && ScriptEvalUtil.compare(resultObject, max) <= 0;
    }

    private static boolean isTrueOrFalse(Object obj, Boolean bln) {
        if (obj == null) {
            return false;
        }
        try {
            return DataTypeUtil.toBoolean((Object)obj).equals(bln);
        }
        catch (BirtException birtException) {
            return false;
        }
    }

    private static Matcher getJSReExprPatternMatcher(String patternStr) {
        if (s_JSReExprPattern == null) {
            s_JSReExprPattern = Pattern.compile("^/(.*)/([a-zA-Z]*)$");
        }
        return s_JSReExprPattern.matcher(patternStr);
    }

    private static boolean match(Object source, Object pattern) throws DataException {
        String sourceStr = source == null ? "" : source.toString();
        String patternStr = pattern == null ? "" : pattern.toString();
        Matcher jsReExprMatcher = ScriptEvalUtil.getJSReExprPatternMatcher(patternStr);
        int flags = 0;
        if (jsReExprMatcher.matches()) {
            String flagStr = patternStr.substring(jsReExprMatcher.start(2), jsReExprMatcher.end(2));
            int i = 0;
            while (i < flagStr.length()) {
                switch (flagStr.charAt(i)) {
                    case 'm': {
                        flags |= 8;
                        break;
                    }
                    case 'i': {
                        flags |= 2;
                        break;
                    }
                    case 'g': {
                        break;
                    }
                    default: {
                        throw new DataException("data.engine.MatchError", patternStr);
                    }
                }
                ++i;
            }
            patternStr = patternStr.substring(jsReExprMatcher.start(1), jsReExprMatcher.end(1));
        }
        try {
            Matcher m = Pattern.compile(patternStr, flags).matcher(sourceStr);
            return m.lookingAt();
        }
        catch (PatternSyntaxException e) {
            throw new DataException("data.engine.MatchError", (Throwable)e, patternStr);
        }
    }

    private static boolean like(Object source, Object pattern) throws DataException {
        String sourceStr = source == null ? "" : source.toString();
        String patternStr = pattern == null ? "" : pattern.toString();
        int patternLen = patternStr.length();
        StringBuffer buffer = new StringBuffer(patternLen * 2);
        int i = 0;
        while (i < patternLen) {
            char c = patternStr.charAt(i);
            if (c == '\\') {
                if (++i < patternLen) {
                    c = patternStr.charAt(i);
                    if (c == '%' || c == '_') {
                        buffer.append(c);
                    } else if (c == '\\') {
                        buffer.append("\\\\");
                    }
                } else {
                    buffer.append("\\\\");
                }
            } else if (c == '%') {
                buffer.append(".*");
            } else if (c == '_') {
                buffer.append(".");
            } else {
                if ("([{^$|)?*+.".indexOf(c) >= 0) {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            ++i;
        }
        try {
            String newPatternStr = buffer.toString();
            Pattern p = Pattern.compile(newPatternStr);
            Matcher m = p.matcher(sourceStr.toString());
            return m.matches();
        }
        catch (PatternSyntaxException e) {
            throw new DataException("data.engine.MatchError", (Throwable)e, pattern);
        }
    }

    public static Object evalExpr(IBaseExpression expr, Context cx, Scriptable scope, String source, int lineNo) throws DataException {
        Object result;
        if (logger.isLoggable(Level.FINER)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.ScriptEvalUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz.getName(), "evalExpr", "evalExpr() expr=" + LogUtil.toString(expr) + ", source=" + source + ", lineNo=" + lineNo);
        }
        if (expr == null) {
            result = null;
        } else if (expr instanceof IConditionalExpression) {
            Object handle = expr.getHandle();
            if (handle instanceof NEvaluator) {
                result = ((NEvaluator)handle).evaluate(cx, scope);
            } else {
                ConditionalExpression ConditionalExpr = (ConditionalExpression)expr;
                Object expression = ScriptEvalUtil.evalExpr(ConditionalExpr.getExpression(), cx, scope, source, lineNo);
                Object Op1 = ScriptEvalUtil.evalExpr(MiscUtil.constructValidScriptExpression(ConditionalExpr.getOperand1()), cx, scope, source, lineNo);
                Object Op2 = ScriptEvalUtil.evalExpr(MiscUtil.constructValidScriptExpression(ConditionalExpr.getOperand2()), cx, scope, source, lineNo);
                result = ScriptEvalUtil.evalConditionalExpr(expression, ConditionalExpr.getOperator(), Op1, Op2);
            }
        } else {
            IScriptExpression jsExpr = (IScriptExpression)expr;
            result = jsExpr.getText() != null && jsExpr.getHandle() != null ? ((CompiledExpression)jsExpr.getHandle()).evaluate(cx, scope) : ScriptEvalUtil.evaluateJSAsExpr(cx, scope, jsExpr.getText(), source, lineNo);
        }
        if (logger.isLoggable(Level.FINER)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.ScriptEvalUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz.getName(), "evalExpr", result);
        }
        return result;
    }

    public static Object evaluateJSAsExpr(Context cx, Scriptable scope, String scriptText, String source, int lineNo) throws DataException {
        Object result;
        if (logger.isLoggable(Level.FINER)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.ScriptEvalUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz.getName(), "evaluateJSExpr", "evaluateJSExpr() scriptText=" + scriptText + ", source=" + source + ", lineNo=" + lineNo);
        }
        try {
            result = JavascriptEvalUtil.evaluateScript((Context)cx, (Scriptable)scope, (String)scriptText, (String)source, (int)lineNo);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        if (result instanceof DataExceptionMocker) {
            throw DataException.wrap(((DataExceptionMocker)((Object)result)).getCause());
        }
        return result;
    }

    public static class ExprTextAndValue {
        String exprText;
        Object value;

        public static ExprTextAndValue newInstance(String exprText, Object value) {
            return new ExprTextAndValue(exprText, value);
        }

        public ExprTextAndValue(String exprText, Object value) {
            this.exprText = exprText;
            this.value = value;
        }
    }

    private static class MiscUtil {
        private MiscUtil() {
        }

        private static boolean isSameType(Object resultExpr, Object resultOp1) {
            return resultExpr.getClass().equals(resultOp1.getClass());
        }

        private static boolean isNumericOrString(Object result) {
            return result instanceof Number || result instanceof String;
        }

        private static boolean isDateOrString(Object result) {
            return result instanceof java.util.Date || result instanceof String;
        }

        private static boolean isBooleanOrString(Object result) {
            return result instanceof Boolean || result instanceof String;
        }

        private static Object[] isComparable(Object obj, int operator, ExprTextAndValue op1, ExprTextAndValue op2) throws DataException {
            if (MiscUtil.needFormat(obj, operator, op1, op2)) {
                return MiscUtil.formatToComparable(obj, op1, op2);
            }
            return null;
        }

        private static boolean needFormat(Object obj, int operator, ExprTextAndValue op1, ExprTextAndValue op2) {
            if (operator < 1 || operator > 8 || obj == null || op1.value == null) {
                return false;
            }
            return operator != 7 && operator != 8 || op2.value != null;
        }

        private static Object[] formatToComparable(Object obj, ExprTextAndValue op1, ExprTextAndValue op2) throws DataException {
            Object[] obArray = new Object[]{obj, op1.value, op2.value};
            if (MiscUtil.isSameType(obj, obArray[1]) && (obArray[2] == null || obArray[2] != null && MiscUtil.isSameType(obj, obArray[2]))) {
                return obArray;
            }
            try {
                if (obj instanceof Number) {
                    obArray[0] = DataTypeUtil.toDouble((Object)obj);
                    obArray[1] = DataTypeUtil.toDouble((Object)obArray[1]);
                    if (obArray[2] != null) {
                        obArray[2] = DataTypeUtil.toDouble((Object)obArray[2]);
                    }
                } else if (obj instanceof Date) {
                    obArray[0] = DataTypeUtil.toSqlDate((Object)obj);
                    obArray[1] = DataTypeUtil.toSqlDate((Object)obArray[1]);
                    if (obArray[2] != null) {
                        obArray[2] = DataTypeUtil.toSqlDate((Object)obArray[2]);
                    }
                } else if (obj instanceof Time) {
                    obArray[0] = DataTypeUtil.toSqlTime((Object)obj);
                    obArray[1] = DataTypeUtil.toSqlTime((Object)obArray[1]);
                    if (obArray[2] != null) {
                        obArray[2] = DataTypeUtil.toSqlTime((Object)obArray[2]);
                    }
                } else if (obj instanceof java.util.Date) {
                    obArray[0] = DataTypeUtil.toDate((Object)obj);
                    obArray[1] = DataTypeUtil.toDate((Object)obArray[1]);
                    if (obArray[2] != null) {
                        obArray[2] = DataTypeUtil.toDate((Object)obArray[2]);
                    }
                } else if (obj instanceof Boolean) {
                    obArray[0] = DataTypeUtil.toBoolean((Object)obj);
                    obArray[1] = DataTypeUtil.toBoolean((Object)obArray[1]);
                }
            }
            catch (BirtException birtException) {
                try {
                    MiscUtil.makeObjectArrayStringArray(obArray);
                }
                catch (BirtException birtException2) {}
            }
            return obArray;
        }

        private static void makeObjectArrayStringArray(Object[] obArray) throws BirtException {
            int i = 0;
            while (i < obArray.length) {
                if (obArray[i] != null) {
                    obArray[i] = DataTypeUtil.toString((Object)obArray[i]);
                }
                ++i;
            }
        }

        private static IScriptExpression constructValidScriptExpression(IScriptExpression ise) {
            return ise != null && ise.getText().trim().length() > 0 ? ise : new ScriptExpression("null");
        }
    }
}

