/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.remote.wsdm.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.notification.remote.NotificationConsumerClient;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.remote.wsdm.spec.SpecSerializer;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalQueryClient
extends NotificationConsumerClient {
    private static final QName KEYSET_QUERY_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "keysetQuery");
    private static final QName PARAMETER_1 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm1");
    private static final QName PARAMETER_2 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm2");
    private static final QName PARAMETER_3 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm3");
    private static final QName PARAMETER_4 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm4");
    private static final QName PARAMETER_5 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm5");
    private static final QName PARAMETER_6 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm6");
    private static final QName PARAMETER_7 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm7");
    private static final QName PARAMETER_8 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "parm8");

    public StatisticalQueryClient(EndpointReference destination) {
        super(destination);
    }

    private Collection<StatisticalTuple> processReturnList(Element result) throws Exception {
        Element responseElement = XmlUtils.getElement((Node)result, (QName)IDataQueryResult.QUERY_RESULT_QNAME);
        Element collectionElement = XmlUtils.getElement((Node)responseElement, (QName)IDataQueryResult.QUERY_RESULT_COLLECTION_QNAME);
        ArrayList<StatisticalTuple> retList = new ArrayList<StatisticalTuple>();
        if (collectionElement != null) {
            Element[] tupleElements;
            Element[] elementArray = tupleElements = XmlUtils.getAllElements((Node)collectionElement, (String)StatisticalTuple.STAT_TUPLE_QNAME.getNamespaceURI(), (String)StatisticalTuple.STAT_TUPLE_QNAME.getLocalPart());
            int n = tupleElements.length;
            int n2 = 0;
            while (n2 < n) {
                Element tuple = elementArray[n2];
                retList.add((StatisticalTuple)SpecSerializer.getStatisticalTupleSerializer().fromXML(tuple));
                ++n2;
            }
        }
        return retList;
    }

    public Collection<StatisticalTuple> keysetQuery(String dataset, String keyset, Date start, Date stop) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability/keysetQuery";
        Element soapBody = XmlUtils.createElement((QName)KEYSET_QUERY_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent("StatisticalTuple");
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_2);
        parm.setTextContent(dataset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_3);
        parm.setTextContent(keyset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_4, (Object)start);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_5, (Object)stop);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        System.out.println("Dataset:" + dataset);
        System.out.println(XmlUtils.toString((Node)result));
        return this.processReturnList(result);
    }

    public Collection<StatisticalTuple> dimensionQuery(String dataset, String keyset, String dimension, Date start, Date stop) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability/dimensionQuery";
        Element soapBody = XmlUtils.createElement((QName)KEYSET_QUERY_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent("StatisticalTuple");
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_2);
        parm.setTextContent(dataset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_3);
        parm.setTextContent(keyset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_4);
        parm.setTextContent(dimension);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_5, (Object)start);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_6, (Object)stop);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        System.out.println("Dataset:" + dataset);
        System.out.println(XmlUtils.toString((Node)result));
        return this.processReturnList(result);
    }

    public Collection<StatisticalTuple> partialKeysetQuery(String dataset, String keyset, String[] dimension, Date start, Date stop) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability/partialKeysetQuery";
        Element soapBody = XmlUtils.createElement((QName)KEYSET_QUERY_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent("StatisticalTuple");
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_2);
        parm.setTextContent(dataset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_3);
        parm.setTextContent(keyset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_4);
        QName dimName = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "dim");
        String[] stringArray = dimension;
        int n = dimension.length;
        int n2 = 0;
        while (n2 < n) {
            String dim = stringArray[n2];
            Element dimElement = XmlUtils.createElement((QName)dimName);
            dimElement.setTextContent(dim);
            parm.appendChild(dimElement);
            ++n2;
        }
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_5, (Object)start);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_6, (Object)stop);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        System.out.println("Dataset:" + dataset);
        System.out.println(XmlUtils.toString((Node)result));
        return this.processReturnList(result);
    }

    public Collection<StatisticalTuple> pagedKeysetQuery(String dataset, String keyset, Date start, Date stop, int pageStart, int pageSize) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability/pagedKeysetQuery";
        Element soapBody = XmlUtils.createElement((QName)KEYSET_QUERY_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent("StatisticalTuple");
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_2);
        parm.setTextContent(dataset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_3);
        parm.setTextContent(keyset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_4, (Object)start);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_5, (Object)stop);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_6, (Object)pageStart);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_7, (Object)pageSize);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        System.out.println("Dataset:" + dataset);
        System.out.println(XmlUtils.toString((Node)result));
        return this.processReturnList(result);
    }

    public Collection<StatisticalTuple> pagedDimensionQuery(String dataset, String keyset, String dimension, Date start, Date stop, int pageStart, int pageSize) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability/pagedDimensionQuery";
        Element soapBody = XmlUtils.createElement((QName)KEYSET_QUERY_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent("StatisticalTuple");
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_2);
        parm.setTextContent(dataset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_3);
        parm.setTextContent(keyset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_4);
        parm.setTextContent(dimension);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_5, (Object)start);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_6, (Object)stop);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_7, (Object)pageStart);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_8, (Object)pageSize);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        System.out.println("Dataset:" + dataset);
        System.out.println(XmlUtils.toString((Node)result));
        return this.processReturnList(result);
    }

    public Collection<StatisticalTuple> pagedPartialKeysetQuery(String dataset, String keyset, String[] dimension, Date start, Date stop, int pageStart, int pageSize) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability/pagedPartialKeysetQuery";
        Element soapBody = XmlUtils.createElement((QName)KEYSET_QUERY_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent("StatisticalTuple");
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_2);
        parm.setTextContent(dataset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_3);
        parm.setTextContent(keyset);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_4);
        QName dimName = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/StatisticalQueryCapability", "dim");
        String[] stringArray = dimension;
        int n = dimension.length;
        int n2 = 0;
        while (n2 < n) {
            String dim = stringArray[n2];
            Element dimElement = XmlUtils.createElement((QName)dimName);
            dimElement.setTextContent(dim);
            parm.appendChild(dimElement);
            ++n2;
        }
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_5, (Object)start);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_6, (Object)stop);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_7, (Object)pageStart);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_8, (Object)pageSize);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        System.out.println("Dataset:" + dataset);
        System.out.println(XmlUtils.toString((Node)result));
        return this.processReturnList(result);
    }
}

