/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.spi.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryComponent;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.spi.BindingService;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.common.spi.IWireTerminal;
import org.eclipse.cosmos.dc.common.spi.OutboundContext;
import org.eclipse.cosmos.dc.common.spi.impl.AbstractCollectionContext;
import org.eclipse.cosmos.dc.common.spi.impl.DescriptorNode;
import org.eclipse.cosmos.dc.common.spi.impl.FilterDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.QueryDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.ResponseDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.TransformDescriptor;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagementProxy;
import org.eclipse.cosmos.dc.runtime.Runtime;

@ManagedResource(advertise=true, advertisementConsumer="Dispatch-Consumer")
public class OutboundDataContext
extends AbstractCollectionContext
implements OutboundContext,
IDataCollectionContext {
    private Runtime runtime;
    private IDataQueryService rootQuery = null;
    private ContributionManager manager;
    private OutboundContext _proxy;
    private boolean hasBrokenWire = false;
    private boolean hasCompleteWire = false;

    public void setRootQuery(IDataQueryService rootQuery) {
        this.rootQuery = rootQuery;
    }

    public OutboundDataContext(Runtime runtime, ContributionManager manager) {
        this.runtime = runtime;
        this.manager = manager;
        this.setOperationalStatus(3);
        this._proxy = (OutboundContext)manager.manage((Object)this);
    }

    public void materialize() throws Exception {
        this.resolveContext();
        if (this.isValid()) {
            this.wireContext();
            if (this.hasCompleteWire && this.hasBrokenWire) {
                this.setWired(2);
            } else if (this.hasCompleteWire) {
                this.setWired(1);
            } else {
                this.setWired(0);
            }
        }
        if (this.isValid()) {
            if (this.isFullyWired()) {
                this.setOperationalStatus(0);
            } else if (this.isWired()) {
                this.setOperationalStatus(2);
            } else {
                this.setOperationalStatus(1);
            }
        }
    }

    protected void resolveContext() throws Exception {
        DescriptorNode[] children;
        QueryDescriptor queryDescriptor = this.rootDescriptor.getQuery();
        BindingService bindingService = this.getBindingService(queryDescriptor);
        if (bindingService == null) {
            this.setValid(false);
            return;
        }
        IDataQueryService root = bindingService.bindQuery(queryDescriptor, queryDescriptor.getBindingElement());
        this.manager.manage((Object)root);
        this._proxy.setRootQuery(root);
        DescriptorNode[] descriptorNodeArray = children = queryDescriptor.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ManagementProxy proxy;
            DescriptorNode child = descriptorNodeArray[n2];
            if (child instanceof FilterDescriptor) {
                bindingService = this.getBindingService(child);
                IDataFilterService filter = bindingService.bindFilter((FilterDescriptor)child, child.getBindingElement());
                if (!(filter instanceof IDataQueryComponent)) {
                    throw new Exception("Component must be an instance of IDataQueryComponent:" + ((FilterDescriptor)child).getFactoryName());
                }
                proxy = (ManagementProxy)this.manager.manage((Object)filter);
                this.rootQuery.addWireTarget((IDataFilterService)proxy.getProxiedObject());
                this.resolveChildren(child, filter);
            } else if (child instanceof TransformDescriptor) {
                bindingService = this.getBindingService(child);
                IDataTransformService transform = bindingService.bindTransform((TransformDescriptor)child, child.getBindingElement());
                if (!(transform instanceof IDataQueryComponent)) {
                    throw new Exception("Component must be an instance of IDataQueryComponent:" + ((FilterDescriptor)child).getFactoryName());
                }
                this.manager.manage((Object)transform);
                this.rootQuery.addWireTarget(transform);
                this.resolveChildren(child, transform);
            } else if (child instanceof ResponseDescriptor) {
                bindingService = this.getBindingService(child);
                IDataResponseService response = bindingService.bindResponse((ResponseDescriptor)child, child.getBindingElement());
                if (!(response instanceof IDataQueryComponent)) {
                    throw new Exception("Component must be an instance of IDataQueryComponent:" + ((FilterDescriptor)child).getFactoryName());
                }
                proxy = (ManagementProxy)this.manager.manage((Object)response);
                this.rootQuery.addWireTarget((IDataSinkService)proxy.getProxiedObject());
                this.rootQuery.addResponse(response);
            } else {
                throw new Exception("Invalid configuration - unexpected descriptor child for inbound Source");
            }
            ++n2;
        }
    }

    protected void resolveChildren(DescriptorNode node, IWireSource source) throws Exception {
        DescriptorNode[] children;
        BindingService bindingService = null;
        DescriptorNode[] descriptorNodeArray = children = node.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ManagementProxy proxy;
            DescriptorNode child = descriptorNodeArray[n2];
            if (child instanceof FilterDescriptor) {
                bindingService = this.getBindingService(child);
                IDataFilterService filter = bindingService.bindFilter((FilterDescriptor)child, child.getBindingElement());
                if (!(filter instanceof IDataQueryComponent)) {
                    throw new Exception("Component must be an instance of IDataQueryComponent:" + ((FilterDescriptor)child).getFactoryName());
                }
                proxy = (ManagementProxy)this.manager.manage((Object)filter);
                source.addWireTarget((IDataFilterService)proxy.getProxiedObject());
                this.resolveChildren(child, filter);
            } else if (child instanceof TransformDescriptor) {
                bindingService = this.getBindingService(child);
                IDataTransformService transform = bindingService.bindTransform((TransformDescriptor)child, child.getBindingElement());
                if (!(transform instanceof IDataQueryComponent)) {
                    throw new Exception("Component must be an instance of IDataQueryComponent:" + ((FilterDescriptor)child).getFactoryName());
                }
                this.manager.manage((Object)transform);
                source.addWireTarget(transform);
                this.resolveChildren(child, transform);
            } else if (child instanceof ResponseDescriptor) {
                bindingService = this.getBindingService(child);
                IDataResponseService response = bindingService.bindResponse((ResponseDescriptor)child, child.getBindingElement());
                if (!(response instanceof IDataQueryComponent)) {
                    throw new Exception("Component must be an instance of IDataQueryComponent:" + ((FilterDescriptor)child).getFactoryName());
                }
                proxy = (ManagementProxy)this.manager.manage((Object)response);
                source.addWireTarget((IDataResponseService)proxy.getProxiedObject());
                this.rootQuery.addResponse(response);
            } else {
                throw new Exception("Invalid configuration - unexpected descriptor child for inbound Source");
            }
            ++n2;
        }
    }

    private BindingService getBindingService(DescriptorNode node) throws Exception {
        String namespace = node.getBindingNamespace();
        if (namespace == null) {
            throw new Exception("No Binding specified for Config Element" + node);
        }
        BindingService bindingService = this.runtime.getBindingServiceForNamespace(namespace);
        if (bindingService == null) {
            throw new Exception("No Binding service available for Namespace " + namespace);
        }
        return bindingService;
    }

    protected void wireContext() throws Exception {
        Class[] rootTypes = this.rootQuery.getOutputTypes();
        IWireTarget[] targets = this.rootQuery.getWireTargets();
        if (targets.length == 0) {
            this.hasCompleteWire = true;
        }
        IWireTarget[] iWireTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IWireTarget target = iWireTargetArray[n2];
            Method targetMethod = this.wireTarget(target, rootTypes);
            if (targetMethod == null) {
                this.hasBrokenWire = true;
            }
            target.setWireMethod(targetMethod);
            ++n2;
        }
        if (this.rootQuery instanceof IWireTerminal) {
            this.rootQuery.prepare();
        }
    }

    private Method wireTarget(IWireTarget target, Class[] types) {
        Method returnMethod = null;
        if (target instanceof IDataFilterService) {
            Class[] computedTypes = this.computeIntersection(((IDataFilterService)target).getAcceptableTypes(), types);
            returnMethod = ((IDataFilterService)target).getFilterMethod(computedTypes[0]);
            if (target instanceof IWireSource) {
                IWireTarget[] targets;
                IWireTarget[] iWireTargetArray = targets = ((IWireSource)((Object)target)).getWireTargets();
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    IWireTarget wireTarget = iWireTargetArray[n2];
                    Method wireMethod = this.wireTarget(wireTarget, computedTypes);
                    if (wireMethod == null) {
                        this.hasBrokenWire = true;
                    }
                    wireTarget.setWireMethod(wireMethod);
                    ++n2;
                }
            }
        } else if (target instanceof IDataTransformService) {
            Class inType = null;
            Class<?> outType = null;
            Class[] classArray = types;
            int n = types.length;
            int n3 = 0;
            while (n3 < n) {
                Class type = classArray[n3];
                if (target.acceptType(type)) {
                    inType = type;
                    break;
                }
                ++n3;
            }
            if (target instanceof IWireSource) {
                IWireTarget[] targets;
                IWireTarget[] iWireTargetArray = targets = ((IWireSource)((Object)target)).getWireTargets();
                int n4 = targets.length;
                n = 0;
                while (n < n4) {
                    IWireTarget wireTarget = iWireTargetArray[n];
                    Method wireMethod = this.wireTarget(wireTarget, ((IDataTransformService)target).getTransformTypes(inType));
                    wireTarget.setWireMethod(wireMethod);
                    if (wireMethod != null) {
                        outType = wireMethod.getParameterTypes()[0];
                    } else {
                        this.hasBrokenWire = true;
                    }
                    ++n;
                }
            }
            returnMethod = ((IDataTransformService)target).getTransformMethod(outType, inType);
        } else if (target instanceof IDataResponseService) {
            Class[] computedTypes = this.computeIntersection(((IDataResponseService)target).getAcceptableTypes(), types);
            if (computedTypes.length > 0) {
                returnMethod = ((IDataResponseService)target).getResponseMethod(computedTypes[0]);
            }
            if (returnMethod == null) {
                this.hasBrokenWire = true;
            } else {
                this.hasCompleteWire = true;
            }
        }
        return returnMethod;
    }

    protected Class[] computeIntersection(Class[] targetClasses, Class[] sourceClasses) {
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] classArray = targetClasses;
        int n = targetClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class target = classArray[n2];
            Class[] classArray2 = sourceClasses;
            int n3 = sourceClasses.length;
            int n4 = 0;
            while (n4 < n3) {
                Class source = classArray2[n4];
                if (source.equals(target)) {
                    result.add(source);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new Class[0]);
    }

    public void dispatch() throws Exception {
    }

    public IDataQueryService getRootQuery() {
        return this.rootQuery;
    }
}

