/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.mozilla.javascript.Scriptable;

public class DataEngineContext {
    public static final int MODE_GENERATION = 1;
    public static final int MODE_PRESENTATION = 2;
    public static final int DIRECT_PRESENTATION = 3;
    public static final int MODE_UPDATE = 4;
    public static final int CACHE_USE_DEFAULT = 1;
    public static final int CACHE_USE_DISABLE = 2;
    public static final int CACHE_USE_ALWAYS = 3;
    public static final int CACHE_MODE_IN_MEMORY = 1;
    public static final int CACHE_MODE_IN_DISK = 2;
    private int mode;
    private Scriptable scope;
    private IDocArchiveReader reader;
    private IDocArchiveWriter writer;
    private ULocale currentLocale;
    private int cacheOption;
    private int cacheCount;
    private String tmpDir = System.getProperty("java.io.tmpdir");
    public static final int VERSION_INFO_STREAM = 11;
    public static final int DATASET_DATA_STREAM = 21;
    public static final int DATASET_META_STREAM = 22;
    public static final int EXPR_VALUE_STREAM = 31;
    public static final int EXPR_META_STREAM = 32;
    public static final int EXPR_ROWLEN_STREAM = 33;
    public static final int GROUP_INFO_STREAM = 41;
    public static final int SUBQUERY_INFO_STREAM = 42;
    public static final int QUERY_DEFN_STREAM = 43;
    public static final int ORIGINAL_QUERY_DEFN_STREAM = 44;
    public static final int ROW_INDEX_STREAM = 51;
    public static final int QUERYID_INFO_STREAM = 61;
    public static final int SUBQUERY_PARENTINDEX_STREAM = 71;
    public static final int META_STREAM = 99;
    public static final int META_INDEX_STREAM = 100;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.api.DataEngineContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.api.DataEngineContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public static DataEngineContext newInstance(int mode, Scriptable scope, IDocArchiveReader reader, IDocArchiveWriter writer) throws BirtException {
        return new DataEngineContext(mode, scope, reader, writer);
    }

    private DataEngineContext(int mode, Scriptable scope, IDocArchiveReader reader, IDocArchiveWriter writer) throws BirtException {
        Object[] params = new Object[]{new Integer(mode), scope, reader, writer};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.api.DataEngineContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "DataEngineContext", params);
        if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
            throw new DataException("data.engine.InvalidMode");
        }
        if (writer == null && mode == 1) {
            throw new DataException("data.engine.InvalidArchive");
        }
        if (reader == null && mode == 2) {
            throw new DataException("data.engine.InvalidArchive");
        }
        if ((writer == null || reader == null) && mode == 4) {
            throw new DataException("data.engine.InvalidArchive");
        }
        this.mode = mode;
        this.scope = scope;
        this.reader = reader;
        this.writer = writer;
        this.cacheOption = 1;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.api.DataEngineContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "DataEngineContext");
    }

    public int getMode() {
        return this.mode;
    }

    public Scriptable getJavaScriptScope() {
        return this.scope;
    }

    public int getCacheOption() {
        return this.cacheOption;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void setCacheOption(int option, int cacheCount) throws BirtException {
        if (this.mode != 3) {
            throw new DataException("data.engine.cacheFunctionWrongMode");
        }
        this.cacheOption = option;
        this.cacheCount = cacheCount;
    }

    public RAOutputStream getOutputStream(String streamID, String subStreamID, int streamType) throws DataException {
        if (!$assertionsDisabled && this.writer == null) {
            throw new AssertionError();
        }
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        try {
            RAOutputStream outputStream = this.writer.openRandomAccessStream(relativePath);
            if (outputStream == null) {
                throw new DataException("data.engine.GetSaveStreamError");
            }
            return outputStream;
        }
        catch (IOException e) {
            throw new DataException("data.engine.GetSaveStreamError", e);
        }
    }

    public boolean hasOutStream(String streamID, String subStreamID, int streamType) {
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        if (this.writer != null) {
            return this.writer.exists(relativePath);
        }
        return false;
    }

    public boolean hasInStream(String streamID, String subStreamID, int streamType) {
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        if (this.reader != null) {
            return this.reader.exists(relativePath);
        }
        return false;
    }

    public void dropStream(String streamID, String subStreamID, int streamType) {
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        if (this.writer != null) {
            this.writer.dropStream(relativePath);
        }
    }

    public void dropStream(String streamPath) {
        if (this.writer != null) {
            this.writer.dropStream(streamPath);
        }
    }

    public RAInputStream getInputStream(String streamID, String subStreamID, int streamType) throws DataException {
        if (!$assertionsDisabled && this.reader == null) {
            throw new AssertionError();
        }
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        try {
            RAInputStream inputStream = this.reader.getStream(relativePath);
            if (inputStream == null) {
                throw new DataException("data.engine.GetLoadStreamError");
            }
            return inputStream;
        }
        catch (IOException e) {
            throw new DataException("data.engine.GetLoadStreamError", e);
        }
    }

    public void setLocale(Locale locale) {
        this.currentLocale = ULocale.forLocale((Locale)locale);
        DataException.setLocale(this.currentLocale);
    }

    public ULocale getLocale() {
        return this.currentLocale;
    }

    public String getTmpdir() {
        if (!this.tmpDir.endsWith(File.separator)) {
            return String.valueOf(this.tmpDir) + File.separator;
        }
        return this.tmpDir;
    }

    public void setTmpdir(String tmpdir) {
        this.tmpDir = tmpdir;
    }

    public IDocArchiveReader getDocReader() {
        return this.reader;
    }

    public IDocArchiveWriter getDocWriter() {
        return this.writer;
    }

    public static String getPath(String streamID, String subStreamID, int streamType) {
        if (streamType == 11) {
            return "/DataEngine/VesionInfo";
        }
        String relativePath = null;
        switch (streamType) {
            case 21: {
                relativePath = "DataSetData";
                break;
            }
            case 22: {
                relativePath = "ResultClass";
                break;
            }
            case 31: {
                relativePath = "ExprValue";
                break;
            }
            case 33: {
                relativePath = "ExprRowLen";
                break;
            }
            case 32: {
                relativePath = "ExprMetaInfo";
                break;
            }
            case 41: {
                relativePath = "GroupInfo";
                break;
            }
            case 42: {
                relativePath = "SubQueryInfo";
                break;
            }
            case 43: {
                relativePath = "QueryDefn";
                break;
            }
            case 44: {
                relativePath = "OriginalQueryDefn";
                break;
            }
            case 51: {
                relativePath = "RowIndex";
                break;
            }
            case 61: {
                relativePath = "QueryIDInfo";
                break;
            }
            case 71: {
                relativePath = "ParentIndex";
                break;
            }
            case 99: {
                relativePath = "Meta";
                break;
            }
            case 100: {
                relativePath = "MetaIndex";
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        String streamRoot = "/" + streamID + "/";
        if (subStreamID != null) {
            streamRoot = String.valueOf(streamRoot) + subStreamID + "/";
        }
        return String.valueOf(streamRoot) + relativePath;
    }
}

