/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignPackage;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.util.DesignValidator;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;

public class DesignUtil {
    private static Diagnostician sm_diagnostician;
    private static final String sm_loggerName = "org.eclipse.datatools.connectivity.oda.design.util";
    private static String sm_className;
    private static Logger sm_logger;

    private DesignUtil() {
    }

    public static void validateObject(EObject eObject) throws IllegalStateException {
        String context = "validateObject";
        Diagnostic diagnostic = DesignUtil.diagnoseObject(eObject);
        if (diagnostic == null || diagnostic.getSeverity() == 0) {
            return;
        }
        if (diagnostic.getSeverity() == 4) {
            String errWarnMsg = DesignUtil.getDiagnosticMessages(diagnostic, 4, 2);
            throw new IllegalStateException(errWarnMsg);
        }
        String diagnosticMsg = DesignUtil.getDiagnosticMessages(diagnostic, 2, 1);
        if (diagnostic.getSeverity() == 2) {
            DiagnosticException ex = new DiagnosticException(diagnostic);
            DesignUtil.getLogger().logp(Level.WARNING, sm_className, "validateObject", diagnosticMsg, (Throwable)ex);
        } else {
            DesignUtil.getLogger().logp(Level.INFO, sm_className, "validateObject", diagnosticMsg);
        }
    }

    public static Diagnostic diagnoseObject(EObject eObject) {
        Diagnostician designDiagnostician = DesignUtil.getDiagnostician();
        return designDiagnostician.validate(eObject);
    }

    private static Diagnostician getDiagnostician() {
        if (sm_diagnostician == null) {
            EValidator.Registry eValidatorRegistry = EValidator.Registry.INSTANCE;
            eValidatorRegistry.put((Object)DesignPackage.Literals.DATA_SET_QUERY.eContainer(), (Object)new DesignValidator());
            sm_diagnostician = new Diagnostician(eValidatorRegistry);
        }
        return sm_diagnostician;
    }

    private static String getDiagnosticMessages(Diagnostic diagnostic, int messageType1, int messageType2) {
        if (diagnostic == null) {
            return null;
        }
        String errMsg = diagnostic.getMessage();
        Iterator i = diagnostic.getChildren().iterator();
        while (i.hasNext()) {
            Diagnostic childDiagnostic = (Diagnostic)i.next();
            if (childDiagnostic.getSeverity() != messageType1 && childDiagnostic.getSeverity() != messageType2) continue;
            errMsg = errMsg + "\n" + childDiagnostic.getMessage();
        }
        return errMsg;
    }

    public static java.util.Properties convertDataSourceProperties(DataSourceDesign dataSourceDesign) {
        java.util.Properties publicProps = DesignUtil.convertDesignProperties(dataSourceDesign.getPublicProperties());
        java.util.Properties propCollection = DesignUtil.convertDesignProperties(dataSourceDesign.getPrivateProperties());
        propCollection.putAll((Map<?, ?>)publicProps);
        return propCollection;
    }

    public static java.util.Properties convertDesignProperties(Properties designProps) {
        java.util.Properties utilProps = new java.util.Properties();
        if (designProps == null || designProps.isEmpty()) {
            return utilProps;
        }
        Iterator itr = designProps.getProperties().iterator();
        while (itr.hasNext()) {
            Property designProp = (Property)itr.next();
            if (designProp.getNameValue() == null || designProp.getNameValue().getName() == null || designProp.getNameValue().getValue() == null) continue;
            utilProps.setProperty(designProp.getNameValue().getName(), designProp.getNameValue().getValue());
        }
        return utilProps;
    }

    public static Properties convertToDesignProperties(java.util.Properties utilProps) {
        Properties designProps = DesignFactory.eINSTANCE.createProperties();
        if (utilProps == null || utilProps.size() == 0) {
            return designProps;
        }
        Iterator<Map.Entry<Object, Object>> iter = utilProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> utilProp = iter.next();
            designProps.setProperty((String)utilProp.getKey(), (String)utilProp.getValue());
        }
        return designProps;
    }

    public static String validateRequestSession(DesignSessionRequest requestSession) throws IllegalStateException {
        if (requestSession == null) {
            throw new IllegalStateException(Messages.design_nullArgument);
        }
        DesignUtil.validateObject(requestSession);
        DataSourceDesign dataSourceDesign = requestSession.getDataSourceDesign();
        if (dataSourceDesign == null) {
            throw new IllegalStateException(Messages.design_missingDataSourceDesign);
        }
        String odaDataSourceId = dataSourceDesign.getOdaExtensionDataSourceId();
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            throw new IllegalStateException(Messages.design_missingId);
        }
        return odaDataSourceId;
    }

    public static void validateDataSourceDesign(DataSourceDesign dataSourceDesign) throws IllegalStateException {
        if (dataSourceDesign == null) {
            throw new IllegalStateException(Messages.design_nullArgument);
        }
        DesignUtil.validateObject(dataSourceDesign);
    }

    public static File convertPathToFile(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        try {
            URL url = new URL(filePath);
            return new File(FileLocator.toFileURL((URL)url).getPath());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String convertFileToPath(File aFile) {
        if (aFile == null) {
            return null;
        }
        return aFile.getPath();
    }

    private static Logger getLogger() {
        if (sm_logger == null) {
            sm_className = DesignUtil.class.getName();
            sm_logger = Logger.getLogger(sm_loggerName);
        }
        return sm_logger;
    }
}

