/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.w3c.dom.css.CSSValue;

public abstract class HTMLAbstractLM
implements ILayoutManager {
    protected static final int LAYOUT_MANAGER_UNKNOW = -1;
    protected static final int LAYOUT_MANAGER_LEAF = 0;
    protected static final int LAYOUT_MANAGER_BLOCK = 1;
    protected static final int LAYOUT_MANAGER_PAGE = 2;
    protected static final int LAYOUT_MANAGER_TABLE = 3;
    protected static final int LAYOUT_MANAGER_TABLE_BAND = 4;
    protected static final int LAYOUT_MANAGER_ROW = 5;
    protected static final int LAYOUT_MANAGER_LIST = 6;
    protected static final int LAYOUT_MANAGER_LIST_BAND = 7;
    protected static final int LAYOUT_MANAGER_GROUP = 8;
    protected static final int STATUS_INTIALIZE = 0;
    protected static final int STATUS_START = 1;
    protected static final int STATUS_INPROGRESS = 2;
    protected static final int STATUS_END = 3;
    protected static final int STATUS_END_WITH_PAGE_BREAK = 4;
    protected static Logger logger;
    protected HTMLReportLayoutEngine engine;
    protected HTMLLayoutContext context;
    protected HTMLAbstractLM parent;
    protected IContent content;
    protected IReportItemExecutor executor;
    protected IContentEmitter emitter;
    protected int status = 0;
    protected boolean isOutput = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public HTMLAbstractLM(HTMLLayoutManagerFactory factory) {
        this.engine = factory.getLayoutEngine();
        this.context = this.engine.getContext();
    }

    public int getType() {
        return -1;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        this.parent = parent;
        this.content = content;
        this.executor = executor;
        this.emitter = emitter;
        this.status = 0;
    }

    public HTMLAbstractLM getParent() {
        return this.parent;
    }

    protected abstract void start();

    protected void startContent() {
        if (this.parent != null && !this.parent.isOutput) {
            this.parent.startContent();
        }
        if (this.emitter != null) {
            ContentEmitterUtil.startContent(this.content, this.emitter);
        }
        this.isOutput = true;
    }

    protected void end() {
        if (this.emitter != null) {
            ContentEmitterUtil.endContent(this.content, this.emitter);
        }
    }

    public boolean layout() {
        switch (this.status) {
            case 0: {
                if (this.handleVisibility()) {
                    this.status = 3;
                    return false;
                }
                if (this.isPageBreakBefore()) {
                    this.status = 1;
                    this.context.endContentWithPageBreak(null);
                    return true;
                }
            }
            case 1: {
                this.context.startContent(this.content);
            }
            case 2: {
                if (this.status == 2) {
                    this.context.continueContent(this.content);
                }
                this.start();
                boolean hasNext = this.layoutChildren();
                this.end();
                this.status = this.isChildrenFinished() ? 3 : 2;
                if (hasNext) {
                    this.context.endContentWithPageBreak(this.content);
                    return true;
                }
                this.context.endContent(this.content);
                return this.isPageBreakAfter();
            }
        }
        return false;
    }

    protected abstract boolean layoutChildren();

    protected abstract boolean isChildrenFinished();

    public boolean isFinished() {
        return this.status == 3;
    }

    protected IContentEmitter getEmitter() {
        return this.emitter;
    }

    protected boolean isPageBreakBefore() {
        if (this.canPageBreak()) {
            return this.needPageBreakBefore();
        }
        return false;
    }

    protected boolean isPageBreakAfter() {
        if (this.canPageBreak()) {
            return this.needPageBreakAfter();
        }
        return false;
    }

    protected boolean allowPageBreak() {
        return true;
    }

    protected boolean canPageBreak() {
        if (!this.context.allowPageBreak()) {
            return false;
        }
        if (!this.allowPageBreak()) {
            return false;
        }
        HTMLAbstractLM p = this.parent;
        while (p != null) {
            if (!p.allowPageBreak()) {
                return false;
            }
            p = p.getParent();
        }
        return true;
    }

    protected boolean needPageBreakBefore() {
        if (this.content == null) {
            return false;
        }
        boolean ret = this.hasMasterPageChanged();
        IStyle style = this.content.getStyle();
        CSSValue pageBreak = style.getProperty(46);
        if (IStyle.ALWAYS_VALUE.equals(pageBreak) || IStyle.RIGHT_VALUE.equals(pageBreak) || IStyle.LEFT_VALUE.equals(pageBreak) || IStyle.SOFT_VALUE.equals(pageBreak)) {
            return true;
        }
        return ret;
    }

    protected boolean needPageBreakAfter() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        CSSValue pageBreak = style.getProperty(51);
        return IStyle.ALWAYS_VALUE.equals(pageBreak) || IStyle.RIGHT_VALUE.equals(pageBreak) || IStyle.LEFT_VALUE.equals(pageBreak);
    }

    protected boolean hasMasterPageChanged() {
        MasterPageDesign masterPageDesign;
        PageSetupDesign pageSetup;
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        if (style == null) {
            return false;
        }
        String newMasterPage = style.getMasterPage();
        if (newMasterPage == null || "".equals(newMasterPage)) {
            return false;
        }
        String masterPage = this.context.getMasterPage();
        if (!newMasterPage.equalsIgnoreCase(masterPage) && (pageSetup = this.content.getReportContent().getDesign().getPageSetup()).getMasterPageCount() > 0 && (masterPageDesign = pageSetup.findMasterPage(newMasterPage)) != null) {
            this.context.setMasterPage(newMasterPage);
            return true;
        }
        return false;
    }

    protected MasterPageDesign getMasterPage(IReportContent report) {
        String masterPage = this.context.getMasterPage();
        MasterPageDesign pageDesign = null;
        if (masterPage != null && !"".equals(masterPage) && (pageDesign = report.getDesign().findMasterPage(masterPage)) != null) {
            return pageDesign;
        }
        return this.getDefaultMasterPage(report);
    }

    private MasterPageDesign getDefaultMasterPage(IReportContent report) {
        PageSetupDesign pageSetup = report.getDesign().getPageSetup();
        int pageCount = pageSetup.getMasterPageCount();
        if (pageCount > 0) {
            MasterPageDesign pageDesign = pageSetup.getMasterPage(0);
            this.context.setMasterPage(pageDesign.getName());
            return pageDesign;
        }
        return null;
    }

    protected boolean isHidden(IContent content) {
        if (content != null) {
            IStyle style = content.getStyle();
            if (!IStyle.NONE_VALUE.equals(style.getProperty(33))) {
                return this.isHiddenByVisibility(content);
            }
            return true;
        }
        return false;
    }

    private boolean isHiddenByVisibility(IContent content) {
        ICellContent cell;
        IColumn column;
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        IStyle style = content.getStyle();
        String formats = style.getVisibleFormat();
        String format = null;
        if (this.emitter != null) {
            format = this.emitter.getOutputFormat();
        }
        if (format != null && this.contains(formats, format)) {
            return true;
        }
        if (content.getContentType() == 1 && (column = (cell = (ICellContent)content).getColumnInstance()) != null) {
            formats = column.getVisibleFormat();
            if (format != null && this.contains(formats, format)) {
                return true;
            }
        }
        return false;
    }

    private boolean contains(String formats, String format) {
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0 || formats.indexOf(format) >= 0);
    }

    protected boolean handleVisibility() {
        if (!$assertionsDisabled && this.content == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.executor == null) {
            throw new AssertionError();
        }
        if (this.isHidden(this.content)) {
            this.traverse(this.executor);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void traverse(IReportItemExecutor executor) {
        if (HTMLAbstractLM.$assertionsDisabled || executor != null) ** GOTO lbl9
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            child = executor.getNextChild();
            if (child == null) continue;
            child.execute();
            this.traverse(child);
            child.close();
lbl9:
            // 3 sources

            ** while (executor.hasNextChild())
        }
lbl10:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    protected void execute(IContent content, IReportItemExecutor executor) {
        if (!HTMLAbstractLM.$assertionsDisabled && executor == null) {
            throw new AssertionError();
        }
        if (HTMLAbstractLM.$assertionsDisabled || content != null) ** GOTO lbl13
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            childExecutor = executor.getNextChild();
            if (childExecutor == null) continue;
            childContent = childExecutor.execute();
            if (childContent != null && !content.getChildren().contains(childContent)) {
                content.getChildren().add(childContent);
            }
            this.execute(childContent, childExecutor);
            childExecutor.close();
lbl13:
            // 3 sources

            ** while (executor.hasNextChild())
        }
lbl14:
        // 1 sources

    }

    public void close() {
    }

    public void cancel() {
        this.status = 3;
    }
}

