/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutNoNestEmitter;

public class HTMLTableLM
extends HTMLBlockStackingLM {
    protected HTMLTableLayoutNoNestEmitter tableEmitter;
    boolean isFirstLayout = true;

    public HTMLTableLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 3;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        this.tableEmitter = new HTMLTableLayoutNoNestEmitter(emitter, this.context);
        super.initialize(parent, content, executor, this.tableEmitter);
        this.isFirstLayout = true;
    }

    protected void repeatHeader() {
        ITableBandContent header;
        ITableContent table;
        if (!this.isFirstLayout && (table = (ITableContent)this.content).isHeaderRepeat() && (header = table.getHeader()) != null) {
            boolean pageBreak = this.context.allowPageBreak();
            boolean isEmpty = this.context.isPageEmpty();
            this.context.setPageEmpty(true);
            this.context.setAllowPageBreak(false);
            this.engine.layout((ILayoutManager)this, header, this.emitter);
            this.context.setAllowPageBreak(pageBreak);
            this.context.setPageEmpty(isEmpty);
            this.context.continueContent(null);
        }
        this.isFirstLayout = false;
    }

    protected boolean layoutChildren() {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        if (!this.isOutput) {
            this.startContent();
        }
        if (hasNext) {
            this.context.addLayoutHint(this.content, !hasNext);
        }
        return hasNext;
    }
}

