/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.BufferedReportEmitter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.buffermgr.TableContentLayout;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutEmitter;

public class HTMLTableLayoutNestEmitter
extends HTMLTableLayoutEmitter {
    protected Stack tableLayouts = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutNestEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HTMLTableLayoutNestEmitter(IContentEmitter emitter, HTMLLayoutContext context) {
        super(emitter, context);
    }

    public void startTable(ITableContent table) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTable(table);
        } else {
            this.emitter.startTable(table);
        }
        this.pushTableLayout(table);
    }

    public void endTable(ITableContent table) {
        this.flush();
        this.emitter.endTable(table);
        this.popTableLayout(table);
    }

    public void startTableGroup(ITableGroupContent group) {
        int groupLevel = group.getGroupLevel();
        this.groupStack.push(new Integer(groupLevel));
        if (this.hasDropCell()) {
            this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(0, group));
        } else {
            this.emitter.startTableGroup(group);
        }
    }

    public void endTableGroup(ITableGroupContent group) {
        int groupLevel = this.getGroupLevel();
        this.resolveCellsOfDrop(groupLevel, false, this.isContentFinished(group));
        this.resolveCellsOfDrop(groupLevel, true, this.isContentFinished(group));
        if (!$assertionsDisabled && this.groupStack.isEmpty()) {
            throw new AssertionError();
        }
        this.groupStack.pop();
        if (this.hasDropCell()) {
            this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(2, group));
        } else {
            this.emitter.endTableGroup(group);
        }
    }

    public void startTableBand(ITableBandContent band) {
        if (band.getBandType() == 4) {
            int groupLevel = this.getGroupLevel();
            this.resolveCellsOfDrop(groupLevel, false, true);
        }
        if (this.hasDropCell()) {
            this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(1, band));
        } else {
            this.flush();
            this.emitter.startTableBand(band);
        }
    }

    public void endTableBand(ITableBandContent band) {
        if (band.getBandType() == 4) {
            int groupLevel = this.getGroupLevel();
            this.resolveCellsOfDrop(groupLevel, true, this.isContentFinished(band));
        }
        if (this.hasDropCell()) {
            this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(3, band));
        } else {
            this.flush();
            this.emitter.endTableBand(band);
        }
    }

    public void startRow(IRowContent row) {
        boolean isHidden = LayoutUtil.isRowHidden(row, this.emitter.getOutputFormat());
        if (!isHidden) {
            this.layout.createRow(row, isHidden);
            row.setRowID(this.layout.getCurrentRowID());
            if (this.hasDropCell()) {
                this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(4, new HTMLTableLayoutEmitter.StartInfo(row.getRowID(), 0)));
            } else {
                this.emitter.startRow(row);
            }
        }
    }

    public void endRow(IRowContent row) {
        if (this.layout.isRowHidden(row)) {
            return;
        }
        if (!this.hasDropCell()) {
            this.flush();
            this.emitter.endRow(row);
        }
    }

    public void startCell(ICellContent cell) {
        if (!this.layout.isVisible(cell)) {
            this.cellEmitter = new ContentEmitterAdapter();
            return;
        }
        int colId = cell.getColumn();
        int colSpan = cell.getColSpan();
        int rowSpan = cell.getRowSpan();
        String dropType = null;
        BufferedReportEmitter buffer = null;
        CellDesign cellDesign = (CellDesign)cell.getGenerateBy();
        if (cellDesign != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
            rowSpan = this.createDropID(this.getGroupLevel(), dropType);
        }
        if (!this.hasDropCell() && rowSpan < 0) {
            this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(5, new HTMLTableLayoutEmitter.StartInfo(this.layout.getRowCount() - 1, colId)));
        }
        if (this.hasDropCell() || rowSpan < 0) {
            buffer = new BufferedReportEmitter(this.emitter);
            this.cellEmitter = buffer;
        }
        this.createCell(colId, rowSpan, colSpan, new HTMLTableLayoutEmitter.CellContent(cell, buffer));
        if (this.hasDropCell()) {
            return;
        }
        this.emitter.startCell(cell);
    }

    public void endCell(ICellContent cell) {
        if (this.cellEmitter != null) {
            this.cellEmitter = null;
        } else {
            this.emitter.endCell(cell);
        }
    }

    void pushTableLayout(ITableContent table) {
        TableLayout tableLayout = new TableLayout();
        tableLayout.layout = this.layout;
        tableLayout.layoutEvents = this.layoutEvents;
        tableLayout.emitter = this.emitter;
        tableLayout.cellEmitter = this.cellEmitter;
        tableLayout.groupStack = this.groupStack;
        tableLayout.hasDropCell = this.hasDropCell;
        this.tableLayouts.push(tableLayout);
        this.layout = new TableContentLayout(table, "viewer");
        this.layoutEvents = new Stack();
        this.groupStack = new Stack();
        this.emitter = tableLayout.cellEmitter != null ? tableLayout.cellEmitter : tableLayout.emitter;
        this.cellEmitter = null;
        this.hasDropCell = false;
    }

    void popTableLayout(ITableContent table) {
        if (!$assertionsDisabled && this.layout == null) {
            throw new AssertionError();
        }
        this.resolveAll(this.isContentFinished(table));
        this.flush();
        TableLayout tableLayout = (TableLayout)this.tableLayouts.pop();
        this.layout = tableLayout.layout;
        this.layoutEvents = tableLayout.layoutEvents;
        this.emitter = tableLayout.emitter;
        this.cellEmitter = tableLayout.cellEmitter;
        this.groupStack = tableLayout.groupStack;
        this.hasDropCell = tableLayout.hasDropCell;
    }

    protected class TableLayout {
        TableContentLayout layout;
        Stack layoutEvents;
        IContentEmitter emitter;
        IContentEmitter cellEmitter;
        Stack groupStack;
        boolean hasDropCell;

        protected TableLayout() {
        }
    }
}

