/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.cache.TableAreaLayout;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class PDFTableLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    private ITableContent tableContent;
    protected boolean repeatHeader;
    protected int columnNumber;
    protected int tableWidth;
    protected TableLayoutInfo layoutInfo = null;
    protected ITableBandContent currentBand = null;
    protected int repeatRowCount = 0;
    protected Stack groupStack = new Stack();
    protected ColumnWidthResolver columnWidthResolver;
    protected int rowCount = 0;
    protected boolean isNewArea = true;
    protected TableAreaLayout layout;
    protected TableAreaLayout regionLayout = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.PDFTableLM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PDFTableLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.tableContent = (ITableContent)content;
        this.columnWidthResolver = new ColumnWidthResolver(this.tableContent);
        this.repeatHeader = this.tableContent.isHeaderRepeat();
        this.columnNumber = this.tableContent.getColumnCount();
    }

    protected boolean traverseChildren() {
        if (this.isNewArea) {
            this.repeat();
            this.isNewArea = false;
        }
        this.skipCachedRow();
        return super.traverseChildren();
    }

    public boolean isCellVisible(ICellContent cell) {
        return true;
    }

    protected void repeat() {
        this.addCaption(this.tableContent.getCaption());
        this.repeatHeader();
    }

    public void startGroup(IGroupContent groupContent) {
        int groupLevel = groupContent.getGroupLevel();
        this.groupStack.push(new Integer(groupLevel));
    }

    public void endGroup(IGroupContent groupContent) {
        int groupLevel = groupContent.getGroupLevel();
        this.updateUnresolvedCell(groupLevel, false);
        this.updateUnresolvedCell(groupLevel, true);
        if (!$assertionsDisabled && this.groupStack.isEmpty()) {
            throw new AssertionError();
        }
        this.groupStack.pop();
    }

    protected int getGroupLevel() {
        if (!this.groupStack.isEmpty()) {
            return (Integer)this.groupStack.peek();
        }
        return -1;
    }

    private int createDropID(int groupIndex, String dropType) {
        int dropId = -10 * (groupIndex + 1);
        if ("all".equals(dropType)) {
            --dropId;
        }
        return dropId;
    }

    public int getRowSpan(ICellContent cell) {
        String dropType;
        CellDesign cellDesign;
        int groupLevel = this.getGroupLevel();
        int rowSpan = cell.getRowSpan();
        if (groupLevel >= 0 && (cellDesign = (CellDesign)cell.getGenerateBy()) != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
            return this.createDropID(groupLevel, dropType);
        }
        return rowSpan;
    }

    protected void createRoot() {
        this.root = AreaFactory.createTableArea((ITableContent)this.content);
        this.root.setWidth(this.tableWidth);
        if (!this.isFirst) {
            this.root.getStyle().setProperty(53, IStyle.NUMBER_0);
        }
    }

    public TableLayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    protected void buildTableLayoutInfo() {
        this.layoutInfo = this.resolveTableFixedLayout((TableArea)this.root);
    }

    protected void initialize() {
        if (this.root == null) {
            this.isNewArea = true;
            this.createRoot();
            this.buildTableLayoutInfo();
            this.root.setWidth(this.layoutInfo.getTableWidth());
            this.maxAvaWidth = this.layoutInfo.getTableWidth();
            this.setCurrentIP(0);
            this.setCurrentBP(0);
            this.repeatRowCount = 0;
            this.rowCount = 0;
        }
        if (this.layout == null) {
            this.layout = new TableAreaLayout(this.tableContent, this.layoutInfo, 0, this.columnNumber);
            this.layout.initTableLayout(this.context.getUnresolvedRowHint(this.tableContent));
        }
        if (this.parent != null) {
            this.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        } else {
            this.root.setAllocatedHeight(this.context.getMaxHeight());
        }
        this.maxAvaHeight = this.root.getContentHeight();
    }

    protected void closeLayout() {
        this.regionLayout = null;
        if (this.root == null) {
            return;
        }
        int borderHeight = 0;
        if (this.layout != null) {
            this.layout.resolveAll();
            borderHeight = this.layout.resolveBottomBorder();
            this.layout.remove((TableArea)this.root);
        }
        this.root.setHeight(this.getCurrentBP() + this.getOffsetY() + borderHeight);
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void resolveBorderConflict(CellArea cellArea, boolean isFirst) {
        if (this.layout != null) {
            this.layout.resolveBorderConflict(cellArea, isFirst);
        }
    }

    private boolean isColumnHidden(IColumn column) {
        String format = this.context.getFormat();
        String formats = column.getVisibleFormat();
        return formats != null && formats.length() > 0 && (formats.toUpperCase().indexOf(format.toUpperCase()) >= 0 || formats.toUpperCase().indexOf("all".toUpperCase()) >= 0);
    }

    public void updateUnresolvedCell(int groupLevel, boolean dropAll) {
        String dropType = dropAll ? "all" : "detail";
        int dropValue = this.createDropID(groupLevel, dropType);
        if (this.layout != null) {
            this.layout.resolveDropCells(dropValue);
        }
    }

    public void skipRow(RowArea row) {
        if (this.layout != null) {
            this.layout.skipRow(row);
        }
    }

    protected void validateBoxProperty(IStyle style) {
        int maxWidth = 0;
        if (this.parent != null) {
            maxWidth = this.parent.getCurrentMaxContentWidth();
        }
        int leftMargin = this.getDimensionValue(style.getProperty(31), maxWidth);
        int rightMargin = this.getDimensionValue(style.getProperty(32), maxWidth);
        int topMargin = this.getDimensionValue(style.getProperty(53), maxWidth);
        int bottomMargin = this.getDimensionValue(style.getProperty(52), maxWidth);
        int[] vs = new int[]{rightMargin, leftMargin};
        this.resolveBoxConflict(vs, maxWidth);
        int[] hs = new int[]{bottomMargin, topMargin};
        this.resolveBoxConflict(hs, this.context.getMaxHeight());
        style.setProperty(31, new FloatValue(1, vs[1]));
        style.setProperty(32, new FloatValue(1, vs[0]));
        style.setProperty(53, new FloatValue(1, hs[1]));
        style.setProperty(52, new FloatValue(1, hs[0]));
    }

    private TableLayoutInfo resolveTableFixedLayout(TableArea area) {
        if (!$assertionsDisabled && this.parent == null) {
            throw new AssertionError();
        }
        int parentMaxWidth = this.parent.maxAvaWidth;
        IStyle style = area.getStyle();
        this.validateBoxProperty(style);
        int marginWidth = this.getDimensionValue(style.getProperty(31)) + this.getDimensionValue(style.getProperty(32));
        return new TableLayoutInfo(this.columnWidthResolver.resolveFixedLayout(parentMaxWidth - marginWidth));
    }

    private TableLayoutInfo resolveTableLayoutInfo(TableArea area) {
        if (!$assertionsDisabled && this.parent == null) {
            throw new AssertionError();
        }
        int avaWidth = this.parent.getCurrentMaxContentWidth() - this.parent.getCurrentIP();
        int parentMaxWidth = this.parent.getCurrentMaxContentWidth();
        IStyle style = area.getStyle();
        this.validateBoxProperty(style);
        int marginWidth = this.getDimensionValue(style.getProperty(31)) + this.getDimensionValue(style.getProperty(32));
        int specifiedWidth = this.getDimensionValue(this.tableContent.getWidth(), parentMaxWidth);
        if (specifiedWidth + marginWidth > parentMaxWidth) {
            specifiedWidth = 0;
        }
        boolean isInline = PropertyUtil.isInlineElement(this.content);
        if (specifiedWidth == 0) {
            this.tableWidth = isInline ? (avaWidth - marginWidth > parentMaxWidth / 4 ? avaWidth - marginWidth : parentMaxWidth - marginWidth) : avaWidth - marginWidth;
            return new TableLayoutInfo(this.handleColummVisibity(this.columnWidthResolver.resolve(this.tableWidth, this.tableWidth)));
        }
        if (!isInline) {
            this.tableWidth = Math.min(specifiedWidth, avaWidth - marginWidth);
            return new TableLayoutInfo(this.handleColummVisibity(this.columnWidthResolver.resolve(this.tableWidth, avaWidth - marginWidth)));
        }
        this.tableWidth = Math.min(specifiedWidth, parentMaxWidth - marginWidth);
        return new TableLayoutInfo(this.handleColummVisibity(this.columnWidthResolver.resolve(this.tableWidth, parentMaxWidth - marginWidth)));
    }

    private int[] handleColummVisibity(int[] columns) {
        int[] colWidth = new int[this.columnNumber];
        int i = 0;
        while (i < this.columnNumber) {
            IColumn column = this.tableContent.getColumn(i);
            colWidth[i] = this.isColumnHidden(column) ? 0 : columns[i];
            ++i;
        }
        return colWidth;
    }

    public void updateRow(RowArea row, int specifiedHeight, boolean finished) {
        if (this.layout != null) {
            this.layout.updateRow(row, specifiedHeight, finished);
        }
    }

    public void addRow(RowArea row, boolean finished, boolean repeated) {
        if (this.layout != null) {
            this.layout.addRow(row, finished, repeated);
        }
    }

    public int getXPos(int columnID) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getXPosition(columnID);
        }
        return 0;
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    public PDFTableRegionLM getTableRegionLayout() {
        PDFReportLayoutEngine engine = this.context.getLayoutEngine();
        PDFLayoutEngineContext con = new PDFLayoutEngineContext(engine);
        con.setFactory(new PDFLayoutManagerFactory(con));
        con.setFormat(this.context.getFormat());
        con.setReport(this.context.getReport());
        con.setMaxHeight(this.context.getMaxHeight());
        con.setMaxWidth(this.context.getMaxWidth());
        con.setAllowPageBreak(false);
        if (this.regionLayout == null) {
            this.regionLayout = new TableAreaLayout(this.tableContent, this.layoutInfo, 0, this.columnNumber);
        }
        return new PDFTableRegionLM(con, this.tableContent, this.layoutInfo, this.regionLayout);
    }

    protected void repeatHeader() {
        IContent content;
        if (this.isFirst) {
            return;
        }
        ITableBandContent header = this.tableContent.getHeader();
        if (!this.repeatHeader || header == null) {
            return;
        }
        if (header.getChildren().isEmpty()) {
            return;
        }
        if (this.child != null && (content = this.child.getContent()) instanceof ITableBandContent && ((ITableBandContent)content).getBandType() == 1) {
            return;
        }
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(header);
        headerExecutor.execute();
        PDFTableRegionLM regionLM = this.getTableRegionLayout();
        regionLM.initialize(header);
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.tableContent.getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getCurrentMaxContentHeight()) {
            Iterator iter = tableRegion.getChildren();
            RowArea row = null;
            while (iter.hasNext()) {
                row = (RowArea)iter.next();
                this.addArea(row, false, this.pageBreakAvoid);
                this.addRow(row, true, true);
                ++this.repeatRowCount;
            }
            if (row != null) {
                this.removeBottomBorder(row);
            }
        }
        this.tableContent.setExtension(1, null);
    }

    protected void addCaption(String caption) {
        if (caption == null || "".equals(caption)) {
            return;
        }
        IReportContent report = this.tableContent.getReportContent();
        ILabelContent captionLabel = report.createLabelContent();
        captionLabel.setText(caption);
        captionLabel.getStyle().setProperty(26, IStyle.CENTER_VALUE);
        ICellContent cell = report.createCellContent();
        cell.setColSpan(this.tableContent.getColumnCount());
        cell.setRowSpan(1);
        cell.setColumn(0);
        captionLabel.setParent(cell);
        cell.getChildren().add(captionLabel);
        IRowContent row = report.createRowContent();
        row.getChildren().add(cell);
        cell.setParent(row);
        ITableBandContent band = report.createTableBandContent();
        band.getChildren().add(row);
        row.setParent(band);
        band.setParent(this.tableContent);
        PDFTableRegionLM regionLM = this.getTableRegionLayout();
        regionLM.initialize(band);
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.content.getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getCurrentMaxContentHeight()) {
            Iterator iter = tableRegion.getChildren();
            while (iter.hasNext()) {
                RowArea rowArea = (RowArea)iter.next();
                this.addArea(rowArea, false, false);
                ++this.repeatRowCount;
            }
        }
        this.content.setExtension(1, null);
    }

    protected IReportItemExecutor createExecutor() {
        return this.executor;
    }

    protected boolean isRootEmpty() {
        return (this.root == null || this.root.getChildrenCount() <= this.repeatRowCount) && !this.isLast;
    }

    protected void skipCachedRow() {
        if (this.keepWithCache.isEmpty()) {
            return;
        }
        Iterator iter = this.keepWithCache.getChildren();
        while (iter.hasNext()) {
            ContainerArea container = (ContainerArea)iter.next();
            this.skip(container);
        }
    }

    protected void skip(ContainerArea area) {
        if (area instanceof RowArea) {
            this.skipRow((RowArea)area);
        } else {
            Iterator iter = area.getChildren();
            while (iter.hasNext()) {
                ContainerArea container = (ContainerArea)iter.next();
                this.skip(container);
            }
        }
    }

    private class ColumnWidthResolver {
        ITableContent table;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.PDFTableLM");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public ColumnWidthResolver(ITableContent table) {
            this.table = table;
        }

        protected void formalize(DimensionType[] columns, int tableWidth) {
            ArrayList<Integer> percentageList = new ArrayList<Integer>();
            ArrayList<Integer> unsetList = new ArrayList<Integer>();
            double total = 0.0;
            int fixedLength = 0;
            int i = 0;
            while (i < columns.length) {
                if (columns[i] == null) {
                    unsetList.add(new Integer(i));
                } else if ("%".equals(columns[i].getUnits())) {
                    percentageList.add(new Integer(i));
                    total += columns[i].getMeasure();
                } else {
                    int len = PDFTableLM.this.getDimensionValue(columns[i], tableWidth);
                    fixedLength += len;
                }
                ++i;
            }
            if (fixedLength >= tableWidth) {
                i = 0;
                while (i < unsetList.size()) {
                    Integer index = (Integer)unsetList.get(i);
                    columns[index.intValue()] = new DimensionType(0.0, "pt");
                    ++i;
                }
                i = 0;
                while (i < percentageList.size()) {
                    Integer index = (Integer)percentageList.get(i);
                    columns[index.intValue()] = new DimensionType(0.0, "pt");
                    ++i;
                }
            } else {
                float leftPercentage = (float)(tableWidth - fixedLength) / (float)tableWidth * 100.0f;
                if (unsetList.isEmpty()) {
                    double ratio = (double)leftPercentage / total;
                    int i2 = 0;
                    while (i2 < percentageList.size()) {
                        Integer index = (Integer)percentageList.get(i2);
                        columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                        ++i2;
                    }
                } else if (total < (double)leftPercentage) {
                    double delta = (double)leftPercentage - total;
                    int i3 = 0;
                    while (i3 < unsetList.size()) {
                        Integer index = (Integer)unsetList.get(i3);
                        columns[index.intValue()] = new DimensionType(delta / (double)unsetList.size(), "%");
                        ++i3;
                    }
                } else {
                    Integer index;
                    double ratio = (double)leftPercentage / total;
                    int i4 = 0;
                    while (i4 < unsetList.size()) {
                        index = (Integer)unsetList.get(i4);
                        columns[index.intValue()] = new DimensionType(0.0, "pt");
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 < percentageList.size()) {
                        index = (Integer)percentageList.get(i4);
                        columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                        ++i4;
                    }
                }
            }
        }

        protected int[] resolve(int tableWidth, DimensionType[] columns) {
            int[] cols;
            block11: {
                int total;
                block10: {
                    cols = new int[columns.length];
                    total = 0;
                    int i = 0;
                    while (i < columns.length) {
                        if (!"%".equals(columns[i].getUnits())) {
                            cols[i] = PDFTableLM.this.getDimensionValue(columns[i], tableWidth);
                            total += cols[i];
                        }
                        ++i;
                    }
                    if (total <= tableWidth) break block10;
                    i = 0;
                    while (i < columns.length) {
                        if ("%".equals(columns[i].getUnits())) {
                            cols[i] = 0;
                        }
                        ++i;
                    }
                    break block11;
                }
                int delta = tableWidth - total;
                boolean hasPercentage = false;
                int i = 0;
                while (i < columns.length) {
                    if ("%".equals(columns[i].getUnits())) {
                        cols[i] = (int)((double)tableWidth * columns[i].getMeasure() / 100.0);
                        hasPercentage = true;
                    }
                    ++i;
                }
                if (hasPercentage) break block11;
                int size = 0;
                int i2 = 0;
                while (i2 < columns.length) {
                    if (cols[i2] > 0) {
                        ++size;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < columns.length) {
                    if (cols[i2] > 0) {
                        int n = i2;
                        cols[n] = cols[n] + delta / size;
                    }
                    ++i2;
                }
            }
            return cols;
        }

        public int[] resolveFixedLayout(int maxWidth) {
            int columnNumber = this.table.getColumnCount();
            DimensionType[] columns = new DimensionType[columnNumber];
            int i = 0;
            while (i < columnNumber) {
                IColumn column = this.table.getColumn(i);
                DimensionType w = column.getWidth();
                columns[i] = PDFTableLM.this.isColumnHidden(column) ? new DimensionType(0.0, "pt") : (w == null ? null : new DimensionType(w.getMeasure(), w.getUnits()));
                ++i;
            }
            int specifiedWidth = PDFTableLM.this.getDimensionValue(PDFTableLM.this.tableContent.getWidth(), maxWidth);
            int tableWidth = specifiedWidth > 0 ? specifiedWidth : maxWidth;
            this.formalize(columns, tableWidth);
            return this.resolve(tableWidth, columns);
        }

        public int[] resolve(int specifiedWidth, int maxWidth) {
            if (!$assertionsDisabled && specifiedWidth > maxWidth) {
                throw new AssertionError();
            }
            int columnNumber = this.table.getColumnCount();
            int[] columns = new int[columnNumber];
            int columnWithWidth = 0;
            int colSum = 0;
            int j = 0;
            while (j < this.table.getColumnCount()) {
                IColumn column = this.table.getColumn(j);
                int columnWidth = PDFTableLM.this.getDimensionValue(column.getWidth(), PDFTableLM.this.tableWidth);
                if (columnWidth > 0) {
                    columns[j] = columnWidth;
                    colSum += columnWidth;
                    ++columnWithWidth;
                } else {
                    columns[j] = -1;
                }
                ++j;
            }
            if (columnWithWidth == columnNumber) {
                if (colSum <= maxWidth) {
                    return columns;
                }
                float delta = colSum - maxWidth;
                int i = 0;
                while (i < columnNumber) {
                    int n = i;
                    columns[n] = columns[n] - (int)(delta * (float)columns[i] / (float)colSum);
                    ++i;
                }
                return columns;
            }
            if (specifiedWidth == 0) {
                if (colSum < maxWidth) {
                    this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
                } else {
                    this.redistributeWidth(columns, colSum - maxWidth + (columnNumber - columnWithWidth) * maxWidth / columnNumber, maxWidth, colSum);
                }
            } else if (colSum < specifiedWidth) {
                this.distributeLeftWidth(columns, (specifiedWidth - colSum) / (columnNumber - columnWithWidth));
            } else if (colSum < maxWidth) {
                this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
            } else {
                this.redistributeWidth(columns, colSum - specifiedWidth + (columnNumber - columnWithWidth) * specifiedWidth / columnNumber, specifiedWidth, colSum);
            }
            return columns;
        }

        private void redistributeWidth(int[] cols, int delta, int sum, int currentSum) {
            int avaWidth = sum / cols.length;
            int i = 0;
            while (i < cols.length) {
                if (cols[i] < 0) {
                    cols[i] = avaWidth;
                } else {
                    int n = i;
                    cols[n] = cols[n] - (int)((float)cols[i] * (float)delta / (float)currentSum);
                }
                ++i;
            }
        }

        private void distributeLeftWidth(int[] cols, int avaWidth) {
            int i = 0;
            while (i < cols.length) {
                if (cols[i] < 0) {
                    cols[i] = avaWidth;
                }
                ++i;
            }
        }
    }

    public class TableLayoutInfo {
        protected int columnNumber;
        protected int tableWidth;
        protected int[] colWidth = null;
        protected int[] xPositions = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.PDFTableLM");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public TableLayoutInfo(int[] colWidth) {
            this.colWidth = colWidth;
            this.columnNumber = colWidth.length;
            this.xPositions = new int[this.columnNumber];
            this.tableWidth = 0;
            int i = 0;
            while (i < this.columnNumber) {
                this.xPositions[i] = this.tableWidth;
                this.tableWidth += colWidth[i];
                ++i;
            }
        }

        public int getTableWidth() {
            return this.tableWidth;
        }

        public int getXPosition(int index) {
            return this.xPositions[index];
        }

        public int getCellWidth(int startColumn, int endColumn) {
            if (!$assertionsDisabled && startColumn >= endColumn) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.colWidth == null) {
                throw new AssertionError();
            }
            int sum = 0;
            int i = startColumn;
            while (i < endColumn) {
                sum += this.colWidth[i];
                ++i;
            }
            return sum;
        }
    }
}

