/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IGridEventHandler;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Grid;
import org.eclipse.birt.report.engine.script.internal.instance.GridInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;

public class GridScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(GridHandle gridHandle, ExecutionContext context) {
        try {
            Grid grid = new Grid(gridHandle);
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridHandle, context);
            if (eh != null) {
                eh.onPrepare(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ITableContent content, ExecutionContext context) {
        try {
            ReportItemDesign gridDesign = (ReportItemDesign)content.getGenerateBy();
            GridInstance grid = new GridInstance(content, context);
            if (GridScriptExecutor.handleJS(grid, gridDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridDesign, context);
            if (eh != null) {
                eh.onCreate(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(ITableContent content, ExecutionContext context) {
        try {
            ReportItemDesign gridDesign = (ReportItemDesign)content.getGenerateBy();
            GridInstance grid = new GridInstance(content, context);
            if (GridScriptExecutor.handleJS(grid, gridDesign.getOnRender(), context).didRun()) {
                return;
            }
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridDesign, context);
            if (eh != null) {
                eh.onRender(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(ITableContent content, ExecutionContext context) {
        try {
            ReportItemDesign gridDesign = (ReportItemDesign)content.getGenerateBy();
            GridInstance grid = new GridInstance(content, context);
            if (GridScriptExecutor.handleJS(grid, gridDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridDesign, context);
            if (eh != null) {
                eh.onPageBreak(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e);
        }
    }

    private static IGridEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        GridHandle handle = (GridHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return GridScriptExecutor.getEventHandler(handle, context);
    }

    private static IGridEventHandler getEventHandler(GridHandle handle, ExecutionContext context) {
        IGridEventHandler eh = null;
        try {
            eh = (IGridEventHandler)GridScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IGridEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            GridScriptExecutor.addClassCastException(context, e, string, clazz);
        }
        return eh;
    }
}

