/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEvent;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedProperty;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedRelation;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagedProxyInvocationHandler;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagementProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementProxyFactory {
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    private static void extractFields(Class clazz, HashMap<String, Field> map) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (map.get(field.getName()) == null) {
                map.put(field.getName(), field);
            }
            ++n2;
        }
    }

    private static void extractInterfaces(Class clazz, HashMap<Class, Class> map) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = clazz.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (map.get(interfaze) == null) {
                map.put(interfaze, interfaze);
            }
            ++n2;
        }
    }

    private static void processSimpleRelationship() {
    }

    private static void processNotificationRelationship() {
    }

    private static void processPropertyChangeNotification() {
    }

    private static void processOperationNotification() {
    }

    private static ManagedProxyInvocationHandler createHandler(Class resourceClass) {
        Method[] methods;
        ManagedEvent event_annotation;
        HashMap<String, Field> map = new HashMap<String, Field>();
        Class workingClass = resourceClass;
        while (workingClass != Object.class) {
            ManagementProxyFactory.extractFields(workingClass, map);
            workingClass = workingClass.getSuperclass();
        }
        Field[] fields = map.values().toArray(EMPTY_FIELD_ARRAY);
        resourceClass.getSuperclass();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            ManagedProperty property_annotation = field.getAnnotation(ManagedProperty.class);
            ManagedRelation relation_annotation = field.getAnnotation(ManagedRelation.class);
            event_annotation = field.getAnnotation(ManagedEvent.class);
            if (relation_annotation != null && event_annotation == null || relation_annotation != null && event_annotation != null || property_annotation != null) {
                // empty if block
            }
            ++n2;
        }
        Method[] methodArray = methods = resourceClass.getMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            Method method = methodArray[n];
            ManagedOperation operation_annotation = method.getAnnotation(ManagedOperation.class);
            event_annotation = method.getAnnotation(ManagedEvent.class);
            if (operation_annotation != null) {
                // empty if block
            }
            ++n;
        }
        return null;
    }

    public static Object getManagedProxy(Object obj) {
        Class[] interfaces;
        Class<?> objClass = obj.getClass();
        HashMap<Class, Class> map = new HashMap<Class, Class>();
        Class<?> workingClass = objClass;
        while (workingClass != Object.class) {
            ManagementProxyFactory.extractInterfaces(workingClass, map);
            workingClass = workingClass.getSuperclass();
        }
        if (!map.isEmpty()) {
            map.put(ManagementProxy.class, ManagementProxy.class);
        }
        if ((interfaces = map.values().toArray(EMPTY_CLASS_ARRAY)).length == 0) {
            return obj;
        }
        ManagedProxyInvocationHandler handler = new ManagedProxyInvocationHandler(obj);
        Object proxy = Proxy.newProxyInstance(obj.getClass().getClassLoader(), interfaces, (InvocationHandler)handler);
        handler.computeProxiedMethodMap(proxy);
        return proxy;
    }
}

