/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.chart;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.report.engine.emitter.excel.chart.DataHelper;
import org.eclipse.birt.report.engine.emitter.excel.chart.DataHelperFactory;
import org.eclipse.birt.report.engine.emitter.excel.chart.TableCell;
import org.eclipse.birt.report.engine.emitter.excel.chart.TableDataIterator;
import org.eclipse.birt.report.engine.emitter.excel.chart.TableDataSet;
import org.eclipse.birt.report.engine.emitter.excel.chart.TableRows;

public class TableGen {
    public static final String STRING = "string";
    public static final String NUMBER = "number";
    public static final String DATETIME = "datetime";
    private TableDataSet base = null;
    private Vector headers = new Vector();
    private Vector datasets = new Vector();
    boolean isNested = false;

    public TableDataIterator iterator() {
        if (this.isNested) {
            return new NestTableDataIterator(this.generateNestTable());
        }
        return new FlatTableDataIterator();
    }

    public void addSeriesDefinition(SeriesDefinition sd, String title) {
        if (sd == null) {
            return;
        }
        this.getOptionalGroup(sd);
        boolean first = true;
        int pos = this.headers.size();
        DataHelper helper = null;
        int i = 0;
        while (i < sd.getRunTimeSeries().size()) {
            Series series = (Series)sd.getRunTimeSeries().get(i);
            Object value = series.getDataSet().getValues();
            if (first) {
                helper = DataHelperFactory.createDataHelper(value);
                String[] names = helper.getColumnHeader(title, series);
                if (names != null) {
                    int j = 0;
                    while (j < names.length) {
                        this.headers.add(names[j]);
                        ++j;
                    }
                }
                first = false;
            }
            if (helper == null || !helper.analyseData(value)) {
                return;
            }
            String colIdentifier = series.getSeriesIdentifier() == null ? null : String.valueOf(series.getSeriesIdentifier());
            TableDataSet[] cols = helper.getTableDataSets(pos, colIdentifier);
            if (this.base == null) {
                this.base = cols[0];
            } else {
                int j = 0;
                while (j < cols.length) {
                    this.datasets.add(cols[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void getOptionalGroup(SeriesDefinition sd) {
        String opCol;
        if (!this.isNested && sd.getQuery() != null && (opCol = sd.getQuery().getDefinition()) != null && !"".equals(opCol)) {
            this.isNested = true;
            this.headers.add(opCol);
        }
    }

    private Map generateNestTable() {
        HashMap<Integer, TableRows> table = new HashMap<Integer, TableRows>();
        int width = this.headers.size();
        int i = 0;
        while (i < this.base.cells.size()) {
            table.put(new Integer(i), new TableRows(this.base.getCell(i), width));
            ++i;
        }
        i = 0;
        while (i < this.datasets.size()) {
            TableDataSet column = (TableDataSet)this.datasets.get(i);
            int j = 0;
            while (j < column.cells.size()) {
                if (column.cells.get(j) != null) {
                    TableRows grows = (TableRows)table.get(new Integer(j));
                    TableCell[] cells = grows.getRow(column.identifier);
                    cells[column.pos] = column.getCell(j);
                }
                ++j;
            }
            ++i;
        }
        return table;
    }

    private TableCell[] getEmptyRow() {
        return new TableCell[this.headers.size()];
    }

    private TableCell[] getTableHeaderCell() {
        TableCell[] row = this.getEmptyRow();
        int i = 0;
        while (i < this.headers.size()) {
            row[i] = new TableCell(STRING, (String)this.headers.get(i));
            ++i;
        }
        return row;
    }

    class FlatTableDataIterator
    implements TableDataIterator {
        private int curPos = -1;

        FlatTableDataIterator() {
        }

        public boolean hasNext() {
            return this.curPos < ((TableGen)TableGen.this).base.cells.size();
        }

        public TableCell[] nextRow() {
            ++this.curPos;
            if (this.curPos == 0) {
                return TableGen.this.getTableHeaderCell();
            }
            return this.getRow(this.curPos - 1);
        }

        private TableCell[] getRow(int pos) {
            TableCell[] row = TableGen.this.getEmptyRow();
            row[0] = TableGen.this.base.getCell(pos);
            int i = 1;
            while (i < row.length) {
                int j = 0;
                while (j < TableGen.this.datasets.size()) {
                    row[i] = ((TableDataSet)TableGen.this.datasets.get(j)).getCell(pos);
                    ++j;
                }
                ++i;
            }
            return row;
        }
    }

    class NestTableDataIterator
    implements TableDataIterator {
        private boolean first = true;
        private Iterator iter = null;

        public NestTableDataIterator(Map data) {
            Vector rows = new Vector();
            Iterator iter = data.values().iterator();
            while (iter.hasNext()) {
                rows.addAll(((TableRows)iter.next()).getAllRows());
            }
            this.iter = rows.iterator();
        }

        public boolean hasNext() {
            if (this.first) {
                return true;
            }
            return this.iter.hasNext();
        }

        public TableCell[] nextRow() {
            if (this.first) {
                this.first = false;
                return TableGen.this.getTableHeaderCell();
            }
            return this.getRow();
        }

        private TableCell[] getRow() {
            return (TableCell[])this.iter.next();
        }
    }
}

