/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;

public class PageDef {
    int width;
    int contentwidth;
    int topmargin;
    int bottommargin;
    int leftmargin;
    int rightmargin;
    int height;
    int footerheight;
    int headerheight;
    IStyle style;

    public PageDef(SimpleMasterPageDesign page, IStyle style) {
        this.parsePage(page);
        this.style = style;
    }

    private void parsePage(SimpleMasterPageDesign page) {
        this.width = ExcelUtil.covertDimensionType(page.getPageWidth(), 0);
        this.leftmargin = ExcelUtil.covertDimensionType(page.getLeftMargin(), this.width);
        this.rightmargin = ExcelUtil.covertDimensionType(page.getRightMargin(), this.width);
        this.contentwidth = this.width - this.leftmargin - this.rightmargin;
        this.height = ExcelUtil.covertDimensionType(page.getPageHeight(), 0);
        this.headerheight = ExcelUtil.covertDimensionType(page.getHeaderHeight(), this.height);
        this.footerheight = ExcelUtil.covertDimensionType(page.getFooterHeight(), this.height);
        this.topmargin = ExcelUtil.covertDimensionType(page.getTopMargin(), this.height);
        this.bottommargin = ExcelUtil.covertDimensionType(page.getBottomMargin(), this.height);
    }
}

