/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.Point;
import org.eclipse.birt.report.model.api.util.Rectangle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class MasterPageSizeValidator
extends AbstractElementValidator {
    private static MasterPageSizeValidator instance = new MasterPageSizeValidator();

    public static MasterPageSizeValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof MasterPage)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (MasterPage)element);
    }

    private List doValidate(Module module, MasterPage toValidate) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        Point size = toValidate.getSize(module);
        if (size.x <= 0.0 || size.y <= 0.0) {
            list.add(new SemanticError(toValidate, "Error.SemanticError.INVALID_PAGE_SIZE"));
        } else {
            Rectangle margins = toValidate.getContentArea(module);
            if (margins.x >= size.x || margins.y >= size.y || margins.height <= 0.0 || margins.width <= 0.0) {
                list.add(new SemanticError(toValidate, "Error.SemanticError.INVALID_PAGE_MARGINS"));
            }
        }
        return list;
    }
}

