/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionLoader;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SimpleEncryptionHelper;

public class EncryptionHelperExtensionLoader
extends ExtensionLoader {
    public static final String EXTENSION_POINT = "org.eclipse.birt.report.model.encryptionHelper";
    private static final String ENCRYPTION_HELPER_TAG = "encryptionHelper";

    public EncryptionHelperExtensionLoader() {
        super(EXTENSION_POINT);
    }

    protected void loadExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        EncryptionHelperElementLoader loader = new EncryptionHelperElementLoader();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement currentTag = configElements[i];
            if (ENCRYPTION_HELPER_TAG.equals(currentTag.getName())) {
                loader.loadElement(currentTag);
            }
            ++i;
        }
    }

    class EncryptionHelperElementLoader
    extends ExtensionLoader.ExtensionElementLoader {
        EncryptionHelperElementLoader() {
            super(EncryptionHelperExtensionLoader.this);
        }

        public void loadElement(IConfigurationElement elementTag) {
            String extensionName = elementTag.getAttribute("extensionName");
            String className = elementTag.getAttribute("class");
            if (!this.checkRequiredAttribute("extensionName", extensionName) || !this.checkRequiredAttribute("class", className)) {
                return;
            }
            try {
                IEncryptionHelper helper = (IEncryptionHelper)elementTag.createExecutableExtension("class");
                IEncryptionHelper registeredHelper = MetaDataDictionary.getInstance().getEncryptionHelper();
                if (registeredHelper != SimpleEncryptionHelper.getInstance()) {
                    EncryptionHelperExtensionLoader.this.handleError(new ExtensionException(new String[]{className}, "ENCYRPTION_EXTENSION_EXISTS"));
                    return;
                }
                MetaDataDictionary.getInstance().setEncryptionHelper(helper);
            }
            catch (FrameworkException frameworkException) {
                EncryptionHelperExtensionLoader.this.handleError(new ExtensionException(new String[]{className}, "FAILED_TO_CREATE_INSTANCE"));
                return;
            }
        }
    }
}

