/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts;

import java.io.StringWriter;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.AbstractGraphCollection;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphElementCollection
extends AbstractGraphCollection
implements IGraphElementCollection {
    private boolean idList;

    public GraphElementCollection(boolean idList, List<IGraphElement> elements) {
        this(idList);
        this.setElements(elements.toArray(new IGraphElement[elements.size()]));
    }

    public GraphElementCollection(boolean idList) {
        super(null);
        this.idList = idList;
    }

    protected abstract String getElementName(boolean var1);

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)this.getElementName(this.idList))) + ICMDBfServicesConstants.nl);
        if (this.idList) {
            int i = 0;
            int elementCount = this.getCollection().size();
            while (i < elementCount) {
                IGraphElement element = (IGraphElement)this.getCollection().get(i);
                IInstanceId[] instanceIds = element.getInstanceIds();
                int j = 0;
                while (j < instanceIds.length) {
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 1));
                    writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)"instanceId")) + ICMDBfServicesConstants.nl);
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 2));
                    writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)"mdrId")) + instanceIds[j].getMdrId().toString() + CMDBfServicesUtil.endTagFor((String)"mdrId") + ICMDBfServicesConstants.nl);
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 2));
                    writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)"localId")) + instanceIds[j].getLocalId().toString() + CMDBfServicesUtil.endTagFor((String)"localId") + ICMDBfServicesConstants.nl);
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 1));
                    writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"instanceId")) + ICMDBfServicesConstants.nl);
                    ++j;
                }
                ++i;
            }
        } else {
            CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), (List)this.getCollection());
        }
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)this.getElementName(this.idList))) + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getCollection() == null ? 0 : this.getCollection().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GraphElementCollection other = (GraphElementCollection)((Object)obj);
        return !(this.getCollection() == null ? other.getCollection() != null : !this.getCollection().equals(other.getCollection()));
    }
}

