/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.ScaleContext;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.AxisOrigin;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;

public final class AutoScale
extends Methods
implements Cloneable {
    private final int iType;
    private Object oMinimum;
    private Object oMaximum;
    private Object oMinimumWithMargin = null;
    private Object oMaximumWithMargin = null;
    private Object oStep;
    private Integer oStepNumber;
    private Object oUnit;
    private double dStartShift;
    private double dEndShift;
    private double dZoomFactor = 1.0;
    private int iMarginPercent = 0;
    private transient double dStart;
    private transient double dEnd;
    private AxisTickCoordinates atcTickCoordinates;
    private transient boolean[] baTickLabelVisible;
    private transient boolean[] baTickLabelStaggered;
    private transient DataSetIterator dsiData;
    private transient boolean bCategoryScale = false;
    private transient boolean bTickBetweenCategories = false;
    private RunTimeContext rtc;
    private static final int TICKS_MAX = 100;
    private static final String sNumericPattern = "0";
    private static int[] iaLinearDeltas = new int[]{1, 2, 5, 10};
    private static int[] iaLogarithmicDeltas = new int[]{10};
    private static int[] iaCalendarUnits = new int[]{13, 12, 11, 5, 2, 1};
    private static int[] iaSecondDeltas = new int[]{1, 5, 10, 15, 20, 30};
    private static int[] iaMinuteDeltas = new int[]{1, 5, 10, 15, 20, 30};
    private static int[] iaHourDeltas = new int[]{1, 2, 3, 4, 12};
    private static int[] iaDayDeltas = new int[]{1, 7, 14};
    private static int[] iaMonthDeltas = new int[]{1, 2, 3, 4, 6};
    private static int[][] iaCalendarDeltas;
    private boolean bIntegralZoom = true;
    private boolean bMinimumFixed = false;
    private boolean bMaximumFixed = false;
    private boolean bStepFixed = false;
    private int iScaleDirection = 0;
    private boolean bAxisLabelStaggered = false;
    private int iLabelShowingInterval = 0;
    private FormatSpecifier fs = null;
    private double dPrecision = 0.0;
    private static ILogger logger;

    static {
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = iaSecondDeltas;
        nArrayArray[1] = iaMinuteDeltas;
        nArrayArray[2] = iaHourDeltas;
        nArrayArray[3] = iaDayDeltas;
        nArrayArray[4] = iaMonthDeltas;
        iaCalendarDeltas = nArrayArray;
        logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation.withaxes");
    }

    AutoScale(int _iType) {
        this.iType = _iType;
    }

    public AutoScale(int _iType, Object _oMinimum, Object _oMaximum) {
        this.iType = _iType;
        this.oMinimum = _oMinimum;
        this.oMaximum = _oMaximum;
    }

    final void setFixed(boolean _bMinimum, boolean _bMaximum, boolean _bStep) {
        this.bMinimumFixed = _bMinimum;
        this.bMaximumFixed = _bMaximum;
        this.bStepFixed = _bStep;
    }

    public final void setDirection(int iValue) {
        this.iScaleDirection = iValue;
    }

    public int getDirection() {
        return this.iScaleDirection;
    }

    public final Object clone() {
        AutoScale sc = new AutoScale(this.iType, this.oMinimum, this.oMaximum);
        sc.oStep = this.oStep;
        sc.oStepNumber = this.oStepNumber;
        sc.dStart = this.dStart;
        sc.dEnd = this.dEnd;
        sc.oMaximumWithMargin = this.oMaximumWithMargin;
        sc.oMinimumWithMargin = this.oMinimumWithMargin;
        sc.iMarginPercent = this.iMarginPercent;
        sc.atcTickCoordinates = this.atcTickCoordinates;
        sc.dStartShift = this.dStartShift;
        sc.dEndShift = this.dEndShift;
        sc.dsiData = this.dsiData;
        sc.oUnit = this.oUnit;
        sc.bMaximumFixed = this.bMaximumFixed;
        sc.bMinimumFixed = this.bMinimumFixed;
        sc.bStepFixed = this.bStepFixed;
        sc.fs = this.fs;
        sc.rtc = this.rtc;
        sc.bIntegralZoom = this.bIntegralZoom;
        sc.bCategoryScale = this.bCategoryScale;
        sc.iScaleDirection = this.iScaleDirection;
        sc.baTickLabelVisible = this.baTickLabelVisible;
        sc.baTickLabelStaggered = this.baTickLabelStaggered;
        sc.bAxisLabelStaggered = this.bAxisLabelStaggered;
        sc.iLabelShowingInterval = this.iLabelShowingInterval;
        sc.bTickBetweenCategories = this.bTickBetweenCategories;
        return sc;
    }

    public final boolean zoomIn() {
        block24: {
            block21: {
                double dStep;
                block22: {
                    double dStep2;
                    block23: {
                        if (this.bStepFixed) {
                            return false;
                        }
                        if (ChartUtil.mathEqual(0.0, ((Number)this.oStep).doubleValue())) {
                            return false;
                        }
                        if ((this.iType & 1) != 1) break block21;
                        if ((this.iType & 4) != 4) break block22;
                        dStep2 = AutoScale.asDouble(this.oStep);
                        if (!(Math.log(dStep2) / LOG_10 > 1.0)) break block23;
                        this.oStep = new Double(dStep2 / 10.0);
                        break block24;
                    }
                    int n = iaLogarithmicDeltas.length;
                    int i = n - 1;
                    while (i >= 0) {
                        if ((int)dStep2 == iaLogarithmicDeltas[i]) {
                            if (i > 0) {
                                this.oStep = new Double(iaLogarithmicDeltas[i - 1]);
                                return true;
                            }
                            return false;
                        }
                        --i;
                    }
                    return false;
                }
                if ((this.iType & 2) != 2) break block24;
                double oldStep = dStep = AutoScale.asDouble(this.oStep).doubleValue();
                if (this.bIntegralZoom) {
                    double dPower = Math.log(dStep) / LOG_10;
                    dPower = Math.floor(dPower);
                    dPower = Math.pow(10.0, dPower);
                    dStep /= dPower;
                    dStep = Math.round(dStep);
                    int n = iaLinearDeltas.length;
                    int i = 0;
                    while (i < n) {
                        if ((int)dStep == iaLinearDeltas[i]) {
                            if (i > 0) {
                                dStep = (double)iaLinearDeltas[i - 1] * dPower;
                                break;
                            }
                            dStep = (double)iaLinearDeltas[n - 2] * (dPower /= 10.0);
                            break;
                        }
                        ++i;
                    }
                    if (dStep == oldStep) {
                        dStep /= 2.0;
                    }
                    this.oStep = new Double(dStep);
                } else {
                    this.oStep = new Double(dStep /= 2.0);
                }
                if (((Number)this.oStep).doubleValue() < this.dPrecision) {
                    this.oStep = new Double(oldStep);
                    return false;
                }
                break block24;
            }
            if ((this.iType & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(this.oStep);
                int iUnit = AutoScale.asInteger(this.oUnit);
                int icu = 0;
                while (icu < iaCalendarUnits.length) {
                    if (iUnit == iaCalendarUnits[icu]) {
                        ia = iaCalendarDeltas[icu];
                        if (ia == null) {
                            if (--iStep == 0) {
                                this.oStep = new Integer(iaMonthDeltas[iaMonthDeltas.length - 1]);
                                this.oUnit = new Integer(2);
                            }
                        } else {
                            int i = 0;
                            while (i < ia.length) {
                                if (ia[i] == iStep) break;
                                ++i;
                            }
                            if (i == 0) {
                                if (icu == 0) {
                                    return false;
                                }
                                ia = iaCalendarDeltas[icu - 1];
                                i = ia.length;
                                this.oUnit = new Integer(iaCalendarUnits[icu - 1]);
                            }
                            this.oStep = new Integer(ia[i - 1]);
                            break;
                        }
                    }
                    ++icu;
                }
            }
        }
        return true;
    }

    public final boolean zoomOut() {
        block23: {
            block20: {
                block21: {
                    double dStep;
                    block22: {
                        if (this.bStepFixed) {
                            return false;
                        }
                        if (((Number)this.oStep).doubleValue() >= Double.MAX_VALUE) {
                            return false;
                        }
                        if ((this.iType & 1) != 1) break block20;
                        if ((this.iType & 4) != 4) break block21;
                        dStep = AutoScale.asDouble(this.oStep);
                        if (!(Math.log(dStep) / LOG_10 >= 1.0)) break block22;
                        this.oStep = new Double(dStep * 10.0);
                        break block23;
                    }
                    int n = iaLogarithmicDeltas.length;
                    int i = 0;
                    while (i < n) {
                        if ((int)dStep == iaLogarithmicDeltas[i]) {
                            this.oStep = new Double(iaLogarithmicDeltas[i + 1]);
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                if ((this.iType & 2) != 2) break block23;
                double dStep = AutoScale.asDouble(this.oStep);
                if (this.bIntegralZoom) {
                    double dPower = Math.log(dStep) / LOG_10;
                    if (dPower < 0.0) {
                        dPower = Math.floor(dPower);
                    }
                    dPower = Math.pow(10.0, dPower);
                    dStep /= dPower;
                    dStep = Math.round(dStep);
                    int n = iaLinearDeltas.length;
                    int i = 0;
                    while (i < n) {
                        if (dStep == (double)iaLinearDeltas[i]) {
                            if (i < n - 1) {
                                dStep = (double)iaLinearDeltas[i + 1] * dPower;
                                if (!(dStep > 1.0)) break;
                                dStep = Math.round(dStep);
                                break;
                            }
                            dStep = (double)iaLinearDeltas[0] * (dPower *= 20.0);
                            if (!(dStep > 1.0)) break;
                            dStep = Math.round(dStep);
                            break;
                        }
                        ++i;
                    }
                    if (i == n) {
                        throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.step.zoom.out", new Object[]{new Double(dStep)}, Messages.getResourceBundle(this.rtc.getULocale()))));
                    }
                    if (((Number)this.oStep).doubleValue() == dStep) {
                        return false;
                    }
                    this.oStep = new Double(dStep);
                } else {
                    this.oStep = new Double(dStep *= 2.0);
                }
                break block23;
            }
            if ((this.iType & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(this.oStep);
                int iUnit = AutoScale.asInteger(this.oUnit);
                int icu = 0;
                while (icu < iaCalendarUnits.length) {
                    if (iUnit == iaCalendarUnits[icu]) {
                        ia = iaCalendarDeltas[icu];
                        if (ia == null) {
                            this.oStep = new Integer(++iStep);
                        } else {
                            int i = 0;
                            int n = ia.length;
                            while (i < n) {
                                if (ia[i] == iStep) break;
                                ++i;
                            }
                            if (i == n - 1) {
                                ia = iaCalendarDeltas[icu + 1];
                                this.oUnit = new Integer(iaCalendarUnits[icu + 1]);
                                if (ia == null) {
                                    this.oStep = new Integer(1);
                                    return false;
                                }
                                i = -1;
                            }
                            this.oStep = new Integer(ia[i + 1]);
                            break;
                        }
                    }
                    ++icu;
                }
            }
        }
        return true;
    }

    public final String getNumericPattern(double dValue) {
        if (dValue - (double)((int)dValue) == 0.0) {
            return sNumericPattern;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        String sMinimum = String.valueOf(dValue);
        int iDecimalPosition = sMinimum.indexOf(dfs.getDecimalSeparator());
        if (iDecimalPosition >= 0) {
            int n = sMinimum.length();
            int i = n - 1;
            while (i > 0) {
                if (sMinimum.charAt(i) != '0') break;
                --n;
                --i;
            }
            int iMantissaCount = n - 1 - iDecimalPosition;
            StringBuffer sb = new StringBuffer(sNumericPattern);
            sb.append('.');
            int i2 = 0;
            while (i2 < iMantissaCount) {
                sb.append('0');
                ++i2;
            }
            return sb.toString();
        }
        return sNumericPattern;
    }

    public final String getNumericPattern() {
        if (this.oMinimum == null || this.oStep == null) {
            return "0.00";
        }
        double dMinValue = AutoScale.asDouble(this.oMinimum);
        double dStep = AutoScale.asDouble(this.oStep);
        if ((this.iType & 4) == 4) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            String sMinimum = this.oMinimum.toString();
            int iDecimalPosition = sMinimum.indexOf(dfs.getDecimalSeparator());
            if (iDecimalPosition >= 0) {
                int n = sMinimum.length();
                int i = n - 1;
                while (i > 0) {
                    if (sMinimum.charAt(i) != '0') break;
                    --n;
                    --i;
                }
                int iMantissaCount = n - 1 - iDecimalPosition;
                StringBuffer sb = new StringBuffer(sNumericPattern);
                sb.append('.');
                int i2 = 0;
                while (i2 < iMantissaCount) {
                    sb.append('0');
                    ++i2;
                }
                return sb.toString();
            }
            return sNumericPattern;
        }
        if (dMinValue - (double)((int)dMinValue) == 0.0 && dStep - (double)((int)dStep) == 0.0) {
            return sNumericPattern;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        String sStep = this.oStep.toString();
        int iDecimalPosition = sStep.indexOf(dfs.getDecimalSeparator());
        if (iDecimalPosition >= 0) {
            int n = sStep.length();
            int i = n - 1;
            while (i > 0) {
                if (sStep.charAt(i) != '0') break;
                --n;
                --i;
            }
            int iMantissaCount = n - 1 - iDecimalPosition;
            StringBuffer sb = new StringBuffer(sNumericPattern);
            sb.append('.');
            int i3 = 0;
            while (i3 < iMantissaCount) {
                sb.append('0');
                ++i3;
            }
            return sb.toString();
        }
        return sNumericPattern;
    }

    public final int getType() {
        return this.iType;
    }

    public final void setData(DataSetIterator _oaData) {
        this.dsiData = _oaData;
    }

    public final FormatSpecifier getFormatSpecifier() {
        return this.fs;
    }

    public final void setFormatSpecifier(FormatSpecifier fs) {
        this.fs = fs;
    }

    public final Object getUnit() {
        return this.oUnit;
    }

    public final DataSetIterator getData() {
        return this.dsiData;
    }

    final void setTickCordinates(AxisTickCoordinates atc) {
        if (atc != null && atc.size() == 1) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.tick.computations", Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        this.atcTickCoordinates = atc;
    }

    public final boolean isTickLabelVisible(int index) {
        if (this.baTickLabelVisible == null || index < 0 || index > this.baTickLabelVisible.length - 1) {
            return false;
        }
        return this.baTickLabelVisible[index];
    }

    public final boolean isTickLabelStaggered(int index) {
        if (this.baTickLabelStaggered == null || index < 0 || index > this.baTickLabelStaggered.length - 1) {
            return false;
        }
        return this.baTickLabelStaggered[index];
    }

    public final boolean isAxisLabelStaggered() {
        return this.bAxisLabelStaggered;
    }

    public final boolean isTickBetweenCategories() {
        return this.bTickBetweenCategories;
    }

    public final AxisTickCoordinates getTickCordinates() {
        return this.atcTickCoordinates;
    }

    public final double getNormalizedStart() {
        return 0.0;
    }

    public final double getNormalizedEnd() {
        return this.dEnd - this.dStart;
    }

    public final double[] getNormalizedEndPoints() {
        return new double[]{0.0, this.dEnd - this.dStart};
    }

    public final double[] getEndPoints() {
        return new double[]{this.dStart, this.dEnd};
    }

    final void setEndPoints(double _dStart, double _dEnd) {
        if (_dStart != -1.0) {
            this.dStart = _dStart;
        }
        if (_dEnd != -1.0) {
            this.dEnd = _dEnd;
        }
        if (this.atcTickCoordinates != null) {
            this.atcTickCoordinates.setEndPoints(this.dStart, this.dEnd);
        }
    }

    public final int getTickCount() throws ChartException {
        if (this.oStepNumber != null) {
            if (this.bCategoryScale || (this.iType & 1) != 1) {
                logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unsupported.step.number", Messages.getResourceBundle(this.rtc.getULocale()))));
            } else {
                return this.oStepNumber + 1;
            }
        }
        int nTicks = 2;
        if ((this.iType & 0x10) == 16 || this.bCategoryScale) {
            if (this.dsiData != null) {
                nTicks = this.dsiData.size() + 1;
                if (!this.bTickBetweenCategories) {
                    ++nTicks;
                }
            }
        } else if ((this.iType & 1) == 1) {
            if ((this.iType & 2) == 2) {
                double dMax = AutoScale.asDouble(this.oMaximum);
                double dMin = AutoScale.asDouble(this.oMinimum);
                double dStep = AutoScale.asDouble(this.oStep);
                nTicks = dMax != dMin ? (int)Math.ceil((dMax - dMin) / dStep - 0.5) + 1 : 5;
            } else if ((this.iType & 4) == 4) {
                double dMax = AutoScale.asDouble(this.oMaximum);
                double dMin = AutoScale.asDouble(this.oMinimum);
                double dStep = AutoScale.asDouble(this.oStep);
                double dMaxLog = Math.log(dMax) / LOG_10;
                double dMinLog = Math.log(dMin) / LOG_10;
                double dStepLog = Math.log(dStep) / LOG_10;
                nTicks = (int)Math.ceil((dMaxLog - dMinLog) / dStepLog) + 1;
            }
        } else if ((this.iType & 8) == 8) {
            CDateTime cdt1 = (CDateTime)((Object)this.oMinimum);
            CDateTime cdt2 = (CDateTime)((Object)this.oMaximum);
            nTicks = (int)(Math.ceil(CDateTime.computeDifference(cdt2, cdt1, AutoScale.asInteger(this.oUnit))) / (double)AutoScale.asInteger(this.oStep)) + 1;
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unknown.axis.type.tick.computations", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (nTicks > 10000) {
            nTicks = 10000;
        }
        if (nTicks < 2) {
            nTicks = 2;
        }
        return nTicks;
    }

    public final double getUnitSize() {
        if (this.atcTickCoordinates == null) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.unit.size.failure", Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        return Math.abs(this.atcTickCoordinates.getStep());
    }

    public final Object getMinimum() {
        return this.oMinimum;
    }

    public final void setMinimum(Object o) {
        this.oMinimum = o;
    }

    public final Object getMaximum() {
        return this.oMaximum;
    }

    public final void setMaximum(Object o) {
        this.oMaximum = o;
    }

    public final Object getStep() {
        return this.oStep;
    }

    public final void setStep(Object o) {
        this.oStep = o;
    }

    public final Integer getStepNumber() {
        return this.oStepNumber;
    }

    public final void setStepNumber(Integer o) {
        this.oStepNumber = o;
    }

    final Object[] getMinMax() throws ChartException {
        Object oValue = null;
        try {
            if ((this.iType & 1) == 1) {
                double dMinValue = Double.MAX_VALUE;
                double dMaxValue = -1.7976931348623157E308;
                this.dsiData.reset();
                while (this.dsiData.hasNext()) {
                    oValue = this.dsiData.next();
                    if (oValue == null) continue;
                    double dValue = (Double)oValue;
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
                return new Object[]{new Double(dMinValue), new Double(dMaxValue)};
            }
            if ((this.iType & 8) == 8) {
                Calendar caMin = null;
                Calendar caMax = null;
                this.dsiData.reset();
                while (this.dsiData.hasNext()) {
                    oValue = this.dsiData.next();
                    Calendar cValue = (Calendar)oValue;
                    if (caMin == null) {
                        caMin = cValue;
                    }
                    if (caMax == null) {
                        caMax = cValue;
                    }
                    if (cValue == null) continue;
                    if (cValue.before((Object)caMin)) {
                        caMin = cValue;
                        continue;
                    }
                    if (!cValue.after((Object)caMax)) continue;
                    caMax = cValue;
                }
                return new Object[]{new CDateTime(caMin), new CDateTime(caMax)};
            }
        }
        catch (ClassCastException classCastException) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.axis.data.type", new Object[]{oValue}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        return null;
    }

    public final void updateAxisMinMax(Object oMinValue, Object oMaxValue) {
        if ((this.iType & 4) == 4) {
            if ((this.iType & 0x20) == 32) {
                this.oMaximum = new Double(100.0);
                this.oMinimum = new Double(1.0);
                this.oStep = new Double(10.0);
                this.bMaximumFixed = true;
                this.bMinimumFixed = true;
                this.bStepFixed = true;
                return;
            }
            double dMinValue = AutoScale.asDouble(oMinValue);
            double dMaxValue = AutoScale.asDouble(oMaxValue);
            double dAbsMax = Math.abs(dMaxValue);
            double dAbsMin = Math.abs(dMinValue);
            double dStep = AutoScale.asDouble(this.oStep);
            double dStepLog = Math.log(dStep);
            int iPow = (int)Math.floor(Math.log(dAbsMax) / dStepLog) + 1;
            double dMaxAxis = Math.pow(dStep, iPow);
            iPow = (int)Math.floor(Math.log(dAbsMin) / dStepLog) - 1;
            double dMinAxis = Math.pow(dStep, iPow + 1);
            if (!this.bMaximumFixed) {
                this.oMaximum = new Double(dMaxAxis);
            }
            if (!this.bMinimumFixed) {
                this.oMinimum = new Double(dMinAxis);
            }
        } else if ((this.iType & 8) == 8) {
            int iUnit = AutoScale.asInteger(this.oUnit);
            int iStep = AutoScale.asInteger(this.oStep);
            CDateTime cdtMinValue = AutoScale.asDateTime(oMinValue);
            CDateTime cdtMaxValue = AutoScale.asDateTime(oMaxValue);
            if (!this.bMinimumFixed) {
                this.oMinimum = cdtMinValue.backward(iUnit, iStep);
            }
            ((CDateTime)((Object)this.oMinimum)).clearBelow(iUnit);
            if (!this.bMaximumFixed) {
                this.oMaximum = cdtMaxValue.forward(iUnit, iStep);
            }
            ((CDateTime)((Object)this.oMaximum)).clearBelow(iUnit);
        } else {
            ScaleContext sct = new ScaleContext(this.iMarginPercent, this.iType, oMinValue, oMaxValue, this.oStep);
            sct.setFixedValue(this.bMinimumFixed, this.bMaximumFixed, this.oMinimum, this.oMaximum);
            sct.setFixedStep(this.bStepFixed, this.oStepNumber);
            sct.computeMinMax();
            this.updateContext(sct);
        }
    }

    private final void updateContext(ScaleContext sct) {
        this.oMaximum = sct.getMax();
        this.oMinimum = sct.getMin();
        this.oMaximumWithMargin = sct.getRealMax();
        this.oMinimumWithMargin = sct.getRealMin();
        this.oStep = sct.getStep();
    }

    Object getMinWithMargin() {
        return this.oMinimumWithMargin;
    }

    Object getMaxWithMargin() {
        return this.oMaximumWithMargin;
    }

    public final boolean checkFit(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        block41: {
            RotatedRectangle rrPrev2;
            RotatedRectangle rrPrev;
            AxisTickCoordinates da;
            int iPointToCheck;
            double y;
            double x;
            block42: {
                block40: {
                    if (this.iType == 16 || this.bCategoryScale) {
                        return true;
                    }
                    double dAngleInDegrees = la.getCaption().getFont().getRotation();
                    x = 0.0;
                    y = 0.0;
                    iPointToCheck = 0;
                    if (iLabelLocation == 3 || iLabelLocation == 4) {
                        iPointToCheck = this.iScaleDirection == -1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 1 : 2) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 3 : 0);
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        iPointToCheck = this.iScaleDirection == 1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 0 : 1) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 2 : 3);
                    }
                    da = this.atcTickCoordinates;
                    rrPrev = null;
                    rrPrev2 = null;
                    if ((this.iType & 3) != 3) break block40;
                    double dAxisValue = AutoScale.asDouble(this.getMinimum());
                    double dAxisStep = AutoScale.asDouble(this.getStep());
                    DecimalFormat df = null;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    NumberDataElement nde = NumberDataElementImpl.create(0.0);
                    int i = 0;
                    while (i < da.size()) {
                        RotatedRectangle rr;
                        String sText;
                        nde.setValue(dAxisValue);
                        try {
                            sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                        }
                        catch (ChartException dfex) {
                            logger.log((Exception)((Object)dfex));
                            sText = NULL_STRING;
                        }
                        if (iLabelLocation == 3 || iLabelLocation == 4) {
                            x = da.getCoordinate(i) * this.dZoomFactor;
                        } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                            y = da.getCoordinate(i) * this.dZoomFactor;
                        }
                        la.getCaption().setValue(sText);
                        try {
                            rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                        }
                        Point p = rr.getPoint(iPointToCheck);
                        if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                            if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                                return false;
                            }
                            rrPrev2 = rr;
                        } else {
                            if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev))) {
                                return false;
                            }
                            rrPrev = rr;
                        }
                        dAxisValue += dAxisStep;
                        ++i;
                    }
                    break block41;
                }
                if ((this.iType & 5) != 5) break block42;
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size() - 1) {
                    RotatedRectangle rr;
                    String sText;
                    nde.setValue(dAxisValue);
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = NULL_STRING;
                    }
                    if (iLabelLocation == 3 || iLabelLocation == 4) {
                        x = da.getCoordinate(i) * this.dZoomFactor;
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        y = da.getCoordinate(i) * this.dZoomFactor;
                    }
                    la.getCaption().setValue(sText);
                    try {
                        rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                    }
                    Point p = rr.getPoint(iPointToCheck);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                            return false;
                        }
                        rrPrev2 = rr;
                    } else {
                        if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                            return false;
                        }
                        rrPrev = rr;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
                break block41;
            }
            if (this.iType != 8) break block41;
            CDateTime cdtAxisValue = AutoScale.asDateTime(this.oMinimum);
            int iUnit = AutoScale.asInteger(this.oUnit);
            int iStep = AutoScale.asInteger(this.oStep);
            IDateFormatWrapper sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
            CDateTime cdt = cdtAxisValue;
            int i = 0;
            while (i < da.size() - 1) {
                RotatedRectangle rr;
                String sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
                if (iLabelLocation == 3 || iLabelLocation == 4) {
                    x = da.getCoordinate(i) * this.dZoomFactor;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = da.getCoordinate(i) * this.dZoomFactor;
                }
                la.getCaption().setValue(sText);
                try {
                    rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                Point p = rr.getPoint(iPointToCheck);
                if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                    if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                        return false;
                    }
                    rrPrev2 = rr;
                } else {
                    if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                        return false;
                    }
                    rrPrev = rr;
                }
                cdt = cdtAxisValue.forward(iUnit, iStep * (i + 1));
                ++i;
            }
        }
        return true;
    }

    protected final boolean[] checkTickLabelsVisibility(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        int i;
        boolean[] ba = new boolean[this.atcTickCoordinates.size()];
        boolean vis = la.isSetVisible() && la.isVisible();
        Arrays.fill(ba, vis);
        this.baTickLabelStaggered = new boolean[this.atcTickCoordinates.size()];
        boolean staggerEnabled = this.isAxisLabelStaggered();
        if (!vis) {
            return ba;
        }
        if (this.iLabelShowingInterval >= 2) {
            i = 0;
            int c = 0;
            while (i < ba.length) {
                boolean bl = ba[i] = i % this.iLabelShowingInterval == 0;
                if (staggerEnabled && ba[i]) {
                    this.baTickLabelStaggered[i] = ++c % 2 == 0;
                }
                ++i;
            }
        } else if (staggerEnabled) {
            i = 0;
            while (i < ba.length) {
                this.baTickLabelStaggered[i] = i % 2 != 0;
                ++i;
            }
        }
        if (this.iType != 16 && !this.bCategoryScale) {
            return ba;
        }
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        double x = 0.0;
        double y = 0.0;
        int iNewPointToCheck = 0;
        int iPrevPointToCheck = 0;
        boolean isNegativeRotation = dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0;
        switch (iLabelLocation) {
            case 3: {
                iNewPointToCheck = isNegativeRotation ? 3 : 0;
                iPrevPointToCheck = isNegativeRotation ? 1 : 3;
                break;
            }
            case 4: {
                int n = isNegativeRotation ? (this.iScaleDirection == -1 ? 1 : 3) : (iNewPointToCheck = this.iScaleDirection == -1 ? 2 : 0);
                iPrevPointToCheck = isNegativeRotation ? (this.iScaleDirection == -1 ? 2 : 0) : (this.iScaleDirection == -1 ? 0 : 2);
                break;
            }
            case 1: {
                iNewPointToCheck = this.iScaleDirection == 1 ? 1 : 2;
                iPrevPointToCheck = this.iScaleDirection == 1 ? 2 : 1;
                break;
            }
            case 2: {
                iNewPointToCheck = this.iScaleDirection == 1 ? 0 : 3;
                iPrevPointToCheck = this.iScaleDirection == 1 ? 3 : 0;
            }
        }
        RotatedRectangle[] rrPrev = new RotatedRectangle[2];
        DataSetIterator dsi = this.getData();
        dsi.reset();
        int iDateTimeUnit = this.iType == 8 ? CDateTime.computeUnit(dsi) : 0;
        String sText = null;
        dsi.reset();
        int i2 = 0;
        while (i2 < this.atcTickCoordinates.size() - 1) {
            Object oValue = null;
            if (dsi.hasNext()) {
                oValue = dsi.next();
            }
            if (ba[i2]) {
                sText = this.formatCategoryValue(this.iType, oValue, iDateTimeUnit);
                if (iLabelLocation == 3 || iLabelLocation == 4) {
                    x = this.atcTickCoordinates.getCoordinate(i2) * this.dZoomFactor;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = this.atcTickCoordinates.getCoordinate(i2) * this.dZoomFactor;
                }
                la.getCaption().setValue(sText);
                ba[i2] = this.isAxisLabelStaggered() && this.baTickLabelStaggered[i2] ? this.checkOneTickLabelVisibility(rrPrev, 1, iLabelLocation, x, y, iNewPointToCheck, iPrevPointToCheck, la, xs, i2) : this.checkOneTickLabelVisibility(rrPrev, 0, iLabelLocation, x, y, iNewPointToCheck, iPrevPointToCheck, la, xs, i2);
            }
            ++i2;
        }
        return ba;
    }

    protected final boolean checkOneTickLabelVisibility(RotatedRectangle[] rrPrev, int arrayIndex, int iLabelLocation, double x, double y, int iNewPointToCheck, int iPrevPointToCheck, Label la, IDisplayServer xs, int tickIndex) {
        if (rrPrev[arrayIndex] == null) {
            rrPrev[arrayIndex] = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
            return true;
        }
        Point previousPoint = rrPrev[arrayIndex].getPoint(iPrevPointToCheck);
        if (this.quickCheckVisibility(iLabelLocation, previousPoint, x, y)) {
            boolean visible;
            RotatedRectangle rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
            Point p = rr.getPoint(iNewPointToCheck);
            boolean bl = visible = !rrPrev[arrayIndex].contains(p) && !ChartUtil.intersects(rr, rrPrev[arrayIndex]);
            if (visible) {
                rrPrev[arrayIndex] = rr;
                return true;
            }
        }
        return false;
    }

    protected boolean quickCheckVisibility(int iLabelLocation, Point previousPoint, double x, double y) {
        return !(iLabelLocation == 3 || iLabelLocation == 4 ? this.iScaleDirection == -1 && previousPoint.getX() < x || this.iScaleDirection != -1 && previousPoint.getX() > x : (iLabelLocation == 1 || iLabelLocation == 2) && (this.iScaleDirection == 1 && previousPoint.getY() > y || this.iScaleDirection != 1 && previousPoint.getY() < y));
    }

    final void resetShifts() {
        this.dStartShift = 0.0;
        this.dEndShift = 0.0;
    }

    public final double getStart() {
        return this.dStart;
    }

    public final double getEnd() {
        return this.dEnd;
    }

    final double getStartShift() {
        return this.dStartShift;
    }

    final double getEndShift() {
        return this.dEndShift;
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, Scale scModel, FormatSpecifier fs, RunTimeContext rtc, int direction, double zoomFactor, int iMarginPercent) throws ChartException {
        return AutoScale.computeScale(xs, ax, dsi, iType, dStart, dEnd, scModel, null, fs, rtc, direction, zoomFactor, iMarginPercent);
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, Scale scModel, AxisOrigin axisOrigin, FormatSpecifier fs, RunTimeContext rtc, int direction, double zoomFactor, int iMarginPercent) throws ChartException {
        Object oValue;
        Object oMaxValue;
        Object oMinValue;
        Label la = ax.getLabel();
        int iLabelLocation = ax.getLabelPosition();
        int iOrientation = ax.getOrientation();
        DataElement oMinimum = scModel.getMin();
        DataElement oMaximum = scModel.getMax();
        Double oStep = scModel.isSetStep() ? new Double(scModel.getStep()) : null;
        Integer oStepNumber = scModel.isSetStepNumber() ? new Integer(scModel.getStepNumber()) : null;
        AutoScale sc = null;
        AutoScale scCloned = null;
        if ((iType & 0x10) == 16 || ax.isCategoryScale()) {
            sc = new AutoScale(iType);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bCategoryScale = true;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.iMarginPercent = iMarginPercent;
            sc.setData(dsi);
            sc.setDirection(direction);
            sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
            oMinValue = null;
            oMaxValue = null;
        } else if ((iType & 2) == 2) {
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            dsi.reset();
            double dPrecision = 0.0;
            while (dsi.hasNext()) {
                oValue = dsi.next();
                if (oValue == null) continue;
                double dValue = (Double)oValue;
                if (dValue < dMinValue) {
                    dMinValue = dValue;
                }
                if (dValue > dMaxValue) {
                    dMaxValue = dValue;
                }
                dPrecision = AutoScale.getPrecision(dPrecision, dValue, fs, rtc.getULocale());
            }
            if (axisOrigin != null && ((Object)((Object)axisOrigin.getType())).equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof NumberDataElement) {
                double origin = AutoScale.asDouble(axisOrigin.getValue());
                if (oMinimum == null && origin < dMinValue) {
                    oMinimum = axisOrigin.getValue();
                }
                if (oMaximum == null && origin > dMaxValue) {
                    oMaximum = axisOrigin.getValue();
                }
            }
            double dAbsMax = Math.abs(dMaxValue);
            double dAbsMin = Math.abs(dMinValue);
            double dStep = Math.max(dAbsMax, dAbsMin);
            double dDelta = dMaxValue - dMinValue;
            if (dDelta == 0.0) {
                dStep = dPrecision;
            } else {
                dStep = Math.floor(Math.log(dDelta) / LOG_10);
                if ((dStep = Math.pow(10.0, dStep)) < dPrecision) {
                    dStep = dPrecision;
                }
            }
            sc = new AutoScale(iType, new Double(0.0), new Double(0.0));
            sc.oStep = new Double(dStep);
            sc.oStepNumber = oStepNumber;
            sc.setData(dsi);
            sc.setDirection(direction);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.dPrecision = dPrecision;
            sc.iMarginPercent = iMarginPercent;
            AutoScale.setNumberMinMaxToScale(sc, oMinimum, oMaximum, rtc, ax);
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            oMinValue = new Double(dMinValue);
            oMaxValue = new Double(dMaxValue);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
        } else if ((iType & 4) == 4) {
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            if ((iType & 0x20) == 32) {
                dMinValue = 0.0;
                dMaxValue = 100.0;
            } else {
                dsi.reset();
                while (dsi.hasNext()) {
                    oValue = dsi.next();
                    if (oValue == null) continue;
                    double dValue = (Double)oValue;
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
                if (axisOrigin != null && ((Object)((Object)axisOrigin.getType())).equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof NumberDataElement) {
                    double origin = AutoScale.asDouble(axisOrigin.getValue());
                    if (oMinimum == null && origin < dMinValue) {
                        oMinimum = axisOrigin.getValue();
                    }
                    if (oMaximum == null && origin > dMaxValue) {
                        oMaximum = axisOrigin.getValue();
                    }
                }
                if (dMinValue == 0.0) {
                    dMinValue = dMaxValue > 0.0 ? 1 : -1;
                }
            }
            sc = new AutoScale(iType, new Double(0.0), new Double(0.0));
            sc.oStep = new Double(10.0);
            sc.oStepNumber = oStepNumber;
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.iMarginPercent = iMarginPercent;
            sc.setData(dsi);
            sc.setDirection(direction);
            AutoScale.setNumberMinMaxToScale(sc, oMinimum, oMaximum, rtc, ax);
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            oMinValue = new Double(dMinValue);
            oMaxValue = new Double(dMaxValue);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
            if ((iType & 0x20) == 32) {
                sc.bStepFixed = true;
                sc.bMaximumFixed = true;
                sc.bMinimumFixed = true;
                sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
                return sc;
            }
        } else if ((iType & 8) == 8) {
            int iUnit;
            Calendar caMin = null;
            Calendar caMax = null;
            dsi.reset();
            while (dsi.hasNext()) {
                Calendar cValue = (Calendar)dsi.next();
                if (cValue == null) continue;
                if (caMin == null) {
                    caMin = cValue;
                }
                if (caMax == null) {
                    caMax = cValue;
                }
                if (cValue.before((Object)caMin)) {
                    caMin = cValue;
                    continue;
                }
                if (!cValue.after((Object)caMax)) continue;
                caMax = cValue;
            }
            oMinValue = new CDateTime(caMin);
            oMaxValue = new CDateTime(caMax);
            if (axisOrigin != null && ((Object)((Object)axisOrigin.getType())).equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof DateTimeDataElement) {
                CDateTime origin = AutoScale.asDateTime(axisOrigin.getValue());
                if (oMinimum == null && origin.before(oMinValue)) {
                    oMinimum = axisOrigin.getValue();
                }
                if (oMaximum == null && origin.after(oMaxValue)) {
                    oMaximum = axisOrigin.getValue();
                }
            }
            if ((iUnit = oStep != null || oStepNumber != null ? ChartUtil.convertUnitTypeToCalendarConstant(scModel.getUnit()) : CDateTime.getPreferredUnit(oMinValue, oMaxValue)) == 0) {
                iUnit = 13;
            }
            CDateTime cdtMinAxis = oMinValue.backward(iUnit, 1);
            CDateTime cdtMaxAxis = oMaxValue.forward(iUnit, 1);
            cdtMinAxis.clearBelow(iUnit);
            cdtMaxAxis.clearBelow(iUnit);
            sc = new AutoScale(8, (Object)cdtMinAxis, (Object)cdtMaxAxis);
            sc.oStep = new Integer(1);
            sc.oStepNumber = oStepNumber;
            sc.oUnit = new Integer(iUnit);
            sc.setDirection(direction);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.iMarginPercent = iMarginPercent;
            if (oMinimum != null) {
                if (!(oMinimum instanceof DateTimeDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.minimum.scale.value", new Object[]{oMinimum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMinimum = ((DateTimeDataElement)oMinimum).getValueAsCDateTime();
                sc.bMinimumFixed = true;
            }
            if (oMaximum != null) {
                if (!(oMaximum instanceof DateTimeDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.maximum.scale.value", new Object[]{sc.oMaximum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMaximum = ((DateTimeDataElement)oMaximum).getValueAsCDateTime();
                sc.bMaximumFixed = true;
            }
            if (sc.bMaximumFixed && sc.bMinimumFixed && ((CDateTime)((Object)sc.oMinimum)).after(sc.oMaximum)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.oMinimum, sc.oMaximum}, Messages.getResourceBundle(rtc.getULocale()));
            }
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
        } else {
            oMinValue = null;
            oMaxValue = null;
        }
        if ((iType & 0x10) != 16 && !ax.isCategoryScale()) {
            boolean bFirstFit;
            sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
            dStart = sc.dStart;
            dEnd = sc.dEnd;
            boolean bFits = bFirstFit = sc.checkFit(xs, la, iLabelLocation);
            boolean bZoomSuccess = false;
            int i = 0;
            while (bFits == bFirstFit && i < 50) {
                bZoomSuccess = true;
                scCloned = (AutoScale)sc.clone();
                if (sc.bStepFixed) break;
                if (bFirstFit) {
                    if (!bFits) break;
                    bZoomSuccess = sc.zoomIn();
                } else {
                    if (!bFits && sc.getTickCordinates().size() == 2) break;
                    bZoomSuccess = sc.zoomOut();
                }
                if (!bZoomSuccess) break;
                sc.updateAxisMinMax(oMinValue, oMaxValue);
                sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
                bFits = sc.checkFit(xs, la, iLabelLocation);
                if (!bFits && sc.getTickCordinates().size() == 2) {
                    sc = scCloned;
                    break;
                }
                ++i;
            }
            if (scCloned != null && bFirstFit && bZoomSuccess) {
                sc = scCloned;
            }
        }
        sc.setData(dsi);
        return sc;
    }

    protected static double getPrecision(double precision, double pValue, FormatSpecifier fs, ULocale locale) {
        NumberFormatSpecifier ns;
        double value = Math.abs(pValue);
        if (value == 0.0) {
            if (precision < 0.0) {
                return precision;
            }
            if (precision >= 0.0) {
                return 1.0;
            }
        }
        if (precision == 0.0) {
            precision = Math.pow(10.0, Math.floor(Math.log(value) / Math.log(10.0)));
        }
        double check = value / precision;
        int loopCounter = 0;
        while (Math.floor(check) != check && loopCounter < 20) {
            ++loopCounter;
            check = value / (precision /= 10.0);
        }
        if (loopCounter == 20) {
            logger.log(2, "Autoscale precision not found for " + value);
        }
        if (fs != null && fs instanceof NumberFormatSpecifier && (ns = (NumberFormatSpecifier)fs).isSetFractionDigits()) {
            double multiplier;
            double d = multiplier = ns.isSetMultiplier() ? ns.getMultiplier() : 1.0;
            if (multiplier != 0.0) {
                double formatPrecision = Math.pow(10.0, -ns.getFractionDigits()) / multiplier;
                precision = precision == 0.0 ? formatPrecision : Math.max(precision, formatPrecision);
            }
        }
        return precision;
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartEndLabels, AllAxes aax) throws ChartException {
        return this.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, bConsiderStartEndLabels, bConsiderStartEndLabels, aax);
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartLabel, boolean bConsiderEndLabel, AllAxes aax) throws ChartException {
        int iDirection;
        int nTicks = 0;
        double dLength = 0.0;
        double dTickGap = 0.0;
        int n = this.iScaleDirection == 0 ? (iOrientation == 0 ? 1 : -1) : (iDirection = this.iScaleDirection);
        if (bConsiderStartLabel || bConsiderEndLabel) {
            this.computeAxisStartEndShifts(xs, la, iOrientation, iLabelLocation, aax);
            if (bConsiderStartLabel) {
                dStart += this.dStartShift * (double)iDirection;
            }
            if (bConsiderEndLabel) {
                dEnd += this.dEndShift * (double)(-iDirection);
            }
        }
        this.dStart = dStart;
        this.dEnd = dEnd;
        nTicks = this.getTickCount();
        dLength = Math.abs(dStart - dEnd);
        if (!this.bCategoryScale && (this.iType & 1) == 1 && (this.iType & 2) == 2) {
            double dMax = AutoScale.asDouble(this.oMaximum);
            double dMin = AutoScale.asDouble(this.oMinimum);
            if (this.bStepFixed && this.oStepNumber != null) {
                dTickGap = dLength / (double)this.oStepNumber.intValue() * (double)iDirection;
            } else {
                double dStepSize = AutoScale.asDouble(this.oStep);
                dTickGap = Math.min(Math.abs(dStepSize / (dMax - dMin) * dLength), dLength) * (double)iDirection;
            }
        } else {
            dTickGap = dLength / (double)(nTicks - 1) * (double)iDirection;
        }
        if (nTicks > 100 && this.bStepFixed && !this.bCategoryScale) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.scale.tick.max", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        AxisTickCoordinates atc = new AxisTickCoordinates(nTicks, dStart, dEnd, dTickGap);
        this.setTickCordinates(null);
        this.setEndPoints(dStart, dEnd);
        this.setTickCordinates(atc);
        this.baTickLabelVisible = this.checkTickLabelsVisibility(xs, la, iLabelLocation);
        return nTicks;
    }

    public final String formatCategoryValue(int iType, Object oValue, int iDateTimeUnit) {
        if (oValue == null) {
            return IConstants.NULL_STRING;
        }
        if (iType == 16) {
            return oValue.toString();
        }
        if (iType == 8) {
            Calendar ca = (Calendar)oValue;
            IDateFormatWrapper sdf = null;
            if (this.fs == null) {
                sdf = DateFormatWrapperFactory.getPreferredDateFormat(iDateTimeUnit, this.rtc.getULocale());
            }
            try {
                return ValueFormatter.format(ca, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        if ((iType & 1) == 1) {
            DecimalFormat df = null;
            if (this.fs == null) {
                df = new DecimalFormat(this.getNumericPattern(((Number)oValue).doubleValue()));
            }
            try {
                return ValueFormatter.format(oValue, this.fs, this.rtc.getULocale(), df);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        return IConstants.NULL_STRING;
    }

    final void computeAxisStartEndShifts(IDisplayServer xs, Label la, int iOrientation, int iLocation, AllAxes aax) throws ChartException {
        double dMaxES;
        double dMaxSS = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxStartShift() : 0.0;
        double d = dMaxES = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxEndShift() : 0.0;
        if (!la.isVisible()) {
            this.dStartShift = dMaxSS;
            this.dEndShift = dMaxES;
            return;
        }
        if (this.getType() == 16 || this.bCategoryScale) {
            boolean bCenter;
            int iDateTimeUnit;
            double dUnitSize = this.getUnitSize();
            DataSetIterator dsi = this.getData();
            BoundingBox bb = null;
            try {
                iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
            }
            catch (ClassCastException classCastException) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.dataset.non.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
            }
            double rotation = la.getCaption().getFont().getRotation();
            boolean bl = bCenter = rotation == 0.0 || rotation == 90.0 || rotation == -90.0;
            if (!this.isTickLabelVisible(0)) {
                this.dStartShift = dMaxSS;
            } else {
                la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.first(), iDateTimeUnit));
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitSize) / 2.0) : (this.iScaleDirection == 1 ? Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint() - dUnitSize / 2.0));
                } else if (iOrientation == 0) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitSize) / 2.0) : (this.iScaleDirection == -1 ? Math.max(dMaxSS, bb.getWidth() - bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0));
                }
            }
            if (!this.isTickLabelVisible(dsi.size() - 1)) {
                this.dEndShift = dMaxES;
            } else {
                la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.last(), iDateTimeUnit));
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, this.dEnd);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = bCenter ? Math.max(dMaxES, dUnitSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitSize) / 2.0) : (this.iScaleDirection == 1 ? Math.max(dMaxES, bb.getHeight() - bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxES, bb.getHotPoint() - dUnitSize / 2.0));
                } else if (iOrientation == 0) {
                    this.dEndShift = bCenter ? Math.max(dMaxES, dUnitSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitSize) / 2.0) : (this.iScaleDirection == -1 ? Math.max(dMaxES, bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxES, bb.getWidth() - bb.getHotPoint() - dUnitSize / 2.0));
                }
            }
        } else if ((this.iType & 1) == 1) {
            if ((this.iType & 2) == 2) {
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern());
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(this.getMinimum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = null;
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                try {
                    sValue = ValueFormatter.format(this.getMaximum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            } else if ((this.iType & 4) == 4) {
                double dMinimum = AutoScale.asDouble(this.getMinimum());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern(dMinimum));
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(this.getMinimum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = null;
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                double dMaximum = AutoScale.asDouble(this.getMaximum());
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern(dMaximum));
                }
                try {
                    sValue = ValueFormatter.format(this.getMaximum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            }
        } else if (this.getType() == 8) {
            CDateTime cdt = AutoScale.asDateTime(this.getMinimum());
            int iUnit = AutoScale.asInteger(this.oUnit);
            IDateFormatWrapper sdf = null;
            String sText = null;
            if (this.fs == null) {
                sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
            }
            try {
                sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            BoundingBox bb = null;
            try {
                bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            if (iOrientation == 1) {
                this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
            }
            cdt = AutoScale.asDateTime(this.getMaximum());
            try {
                sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            try {
                bb = AutoScale.computeBox(xs, iLocation, la, 0.0, this.dEnd);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            if (iOrientation == 1) {
                this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
            }
        }
    }

    final double computeAxisLabelThickness(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unset.label.visibility", new Object[]{la.getCaption().getValue()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (!la.isVisible()) {
            return 0.0;
        }
        AxisTickCoordinates da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            double dMaxW2 = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxW + dMaxW2;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            double dMaxH2 = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxH + dMaxH2;
        }
        return 0.0;
    }

    public final double computeStaggeredAxisLabelOffset(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unset.label.visibility", new Object[]{la.getCaption().getValue()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (!la.isVisible() || !this.isAxisLabelStaggered()) {
            return 0.0;
        }
        AxisTickCoordinates da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dW;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.baTickLabelStaggered[i] && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxW;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dH;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.baTickLabelStaggered[i] && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxH;
        }
        return 0.0;
    }

    public final boolean isStepFixed() {
        return this.bStepFixed;
    }

    public final void setStepFixed(boolean v) {
        this.bStepFixed = v;
    }

    public final boolean isMinimumFixed() {
        return this.bMinimumFixed;
    }

    public final void setMinimumFixed(boolean v) {
        this.bMinimumFixed = v;
    }

    public final boolean isMaximumFixed() {
        return this.bMaximumFixed;
    }

    public final void setMaximumFixed(boolean v) {
        this.bMaximumFixed = v;
    }

    public final boolean isCategoryScale() {
        return this.bCategoryScale;
    }

    public final double[] getMinorCoordinates(int iMinorUnitsPerMajor) {
        if (this.atcTickCoordinates == null || iMinorUnitsPerMajor <= 0) {
            return null;
        }
        double[] da = new double[iMinorUnitsPerMajor];
        double dUnit = this.getUnitSize();
        if ((this.iType & 4) != 4) {
            double dEach = dUnit / (double)iMinorUnitsPerMajor;
            int i = 1;
            while (i < iMinorUnitsPerMajor) {
                da[i - 1] = dEach * (double)i;
                ++i;
            }
        } else {
            double dCount = iMinorUnitsPerMajor;
            double dMax = Math.log(dCount);
            int i = 0;
            while (i < iMinorUnitsPerMajor) {
                da[i] = Math.log(i + 1) * dUnit / dMax;
                ++i;
            }
        }
        da[iMinorUnitsPerMajor - 1] = dUnit;
        return da;
    }

    public final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }

    public final void setRunTimeContext(RunTimeContext context) {
        this.rtc = context;
    }

    public static void setNumberMinMaxToScale(AutoScale sc, Object oMinimum, Object oMaximum, RunTimeContext rtc, OneAxis ax) throws ChartException {
        if (oMinimum != null) {
            if (!(oMinimum instanceof NumberDataElement)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.minimum.scale.value", new Object[]{sc.oMinimum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
            }
            sc.oMinimum = new Double(((NumberDataElement)oMinimum).getValue());
            sc.bMinimumFixed = true;
        }
        if (oMaximum != null) {
            if (!(oMaximum instanceof NumberDataElement)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.maximum.scale.value", new Object[]{sc.oMaximum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
            }
            sc.oMaximum = new Double(((NumberDataElement)oMaximum).getValue());
            sc.bMaximumFixed = true;
        }
        if (sc.bMaximumFixed && sc.bMinimumFixed && (Double)sc.oMinimum > (Double)sc.oMaximum) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.oMinimum, sc.oMaximum}, Messages.getResourceBundle(rtc.getULocale()));
        }
    }

    public static void setStepToScale(AutoScale sc, Object oStep, Integer oStepNumber, RunTimeContext rtc) throws ChartException {
        if (oStep != null) {
            sc.oStep = oStep;
            sc.bStepFixed = true;
            if ((Double)sc.oStep <= 0.0) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.size", new Object[]{oStep}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
        if (oStepNumber != null) {
            sc.oStepNumber = oStepNumber;
            sc.bStepFixed = true;
            if (sc.oStepNumber < 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.number", new Object[]{oStepNumber}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
    }

    public final DecimalFormat computeDecimalFormat(double dAxisValue, double dAxisStep) {
        String valuePattern = this.getNumericPattern(dAxisValue);
        String stepPattern = this.getNumericPattern(dAxisStep);
        boolean bValuePrecise = ChartUtil.checkDoublePrecise(dAxisValue);
        boolean bStepPrecise = ChartUtil.checkDoublePrecise(dAxisStep);
        if (bValuePrecise ? bStepPrecise && valuePattern.length() < stepPattern.length() : bStepPrecise) {
            return new DecimalFormat(stepPattern);
        }
        return new DecimalFormat(valuePattern);
    }
}

