/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class InteractiveRenderer {
    private Map targets = new HashMap();
    private IUpdateNotifier iun;
    private Map savedColors = new HashMap();
    private Map savedLines = new HashMap();
    private Map savedLabels = new HashMap();

    public boolean registerAction(StructureSource target, ActionType type) {
        if (this.iun == null) {
            return false;
        }
        String source = this.getSource(target);
        HashSet<ActionType> set = (HashSet<ActionType>)this.targets.get(source);
        if (set != null) {
            return set.add(type);
        }
        set = new HashSet<ActionType>();
        set.add(type);
        this.targets.put(source, set);
        return true;
    }

    public void unregisterAction(StructureSource target, ActionType type) {
        if (this.iun == null) {
            return;
        }
        String source = this.getSource(target);
        Set set = (Set)this.targets.get(source);
        if (set != null && set.size() > 1) {
            set.remove((Object)type);
        } else {
            this.targets.remove(source);
        }
    }

    public void modifyEvent(PrimitiveRenderEvent event) {
        if (this.iun == null) {
            return;
        }
        this.restoreEvent();
        String source = this.getSource((StructureSource)event.getSource());
        if (source == null) {
            return;
        }
        Set typeSet = (Set)this.targets.get(source);
        if (typeSet != null) {
            Iterator iter = typeSet.iterator();
            while (iter.hasNext()) {
                ActionType type = (ActionType)((Object)iter.next());
                switch (type.getValue()) {
                    case 4: {
                        this.highlight(event);
                        break;
                    }
                    case 6: {
                        this.hideLabel(event);
                        break;
                    }
                    case 2: {
                        this.hideElement(event);
                    }
                }
            }
        }
    }

    private void hideLabel(PrimitiveRenderEvent event) {
        Label label = event.getLabel();
        if (label != null) {
            this.saveLabel(label);
            label.setVisible(false);
        }
    }

    public String getSource(StructureSource src) {
        if (src.getType() == StructureType.SERIES || src.getType() == StructureType.SERIES_DATA_POINT) {
            if (this.isColoredByCategories()) {
                if (src.getSource() instanceof DataPointHints) {
                    DataPointHints hints = (DataPointHints)src.getSource();
                    int index = hints.getIndex();
                    return "category_" + String.valueOf(index);
                }
                return null;
            }
            Series series = src.getType() == StructureType.SERIES ? (Series)src.getSource() : (Series)((WrappedStructureSource)src).getParent().getSource();
            return String.valueOf(series.hashCode());
        }
        return null;
    }

    private boolean isColoredByCategories() {
        return this.iun.getRunTimeModel().getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
    }

    private void hideElement(PrimitiveRenderEvent event) {
        Label label;
        LineAttributes lineAttributes;
        Fill fill = event.getBackground();
        if (fill != null) {
            this.hideFill(fill);
        }
        if ((lineAttributes = event.getLineAttributes()) != null) {
            this.saveLine(lineAttributes);
            lineAttributes.setVisible(false);
        }
        if ((label = event.getLabel()) != null) {
            this.saveLabel(label);
            label.setVisible(false);
        }
    }

    private void hideFill(Fill fill) {
        if (fill instanceof ColorDefinition) {
            ((ColorDefinition)fill).setTransparency(0);
        } else if (fill instanceof Gradient) {
            ((Gradient)fill).setTransparency(0);
        } else if (!(fill instanceof Image) && fill instanceof MultipleFill) {
            EList list = ((MultipleFill)fill).getFills();
            int i = 0;
            while (i < list.size()) {
                this.hideFill((Fill)list.get(i));
                ++i;
            }
        }
    }

    private void highlight(PrimitiveRenderEvent event) {
        Label label;
        LineAttributes lineAttributes;
        Fill fill = event.getBackground();
        if (fill != null) {
            this.highlightFill(fill);
        }
        if ((lineAttributes = event.getLineAttributes()) != null) {
            this.highlightLine(lineAttributes);
        }
        if ((label = event.getLabel()) != null) {
            this.highlightLabel(label);
        }
    }

    private void highlightLabel(Label label) {
        this.saveLabel(label);
        ColorDefinition color = label.getCaption().getColor();
        if (color != null) {
            color.brighter();
        }
    }

    private void highlightLine(LineAttributes la) {
        this.saveLine(la);
        ColorDefinition color = la.getColor();
        if (color != null) {
            color.brighter();
        }
    }

    private void highlightFill(Fill fill) {
        if (fill instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)fill;
            this.saveColor(cd);
            cd.setRed((cd.getRed() + 255) / 2);
            cd.setGreen((cd.getGreen() + 255) / 2);
            cd.setBlue((cd.getBlue() + 255) / 2);
        } else if (fill instanceof Gradient) {
            this.highlightFill(((Gradient)fill).getStartColor());
            this.highlightFill(((Gradient)fill).getEndColor());
        } else if (!(fill instanceof Image) && fill instanceof MultipleFill) {
            EList list = ((MultipleFill)fill).getFills();
            int i = 0;
            while (i < list.size()) {
                this.highlightFill((Fill)list.get(i));
                ++i;
            }
        }
    }

    private void saveColor(ColorDefinition cd) {
        if (!this.savedColors.containsKey(cd)) {
            this.savedColors.put(cd, EcoreUtil.copy((EObject)cd));
        }
    }

    private void saveLine(LineAttributes line) {
        if (!this.savedLines.containsKey(line)) {
            this.savedLines.put(line, EcoreUtil.copy((EObject)line));
        }
    }

    private void saveLabel(Label label) {
        if (!this.savedLabels.containsKey(label)) {
            this.savedLabels.put(label, EcoreUtil.copy((EObject)label));
        }
    }

    protected void restoreEvent() {
        Object copy;
        Object original;
        if (this.iun == null) {
            return;
        }
        Iterator iter = this.savedColors.keySet().iterator();
        while (iter.hasNext()) {
            original = (ColorDefinition)iter.next();
            copy = (ColorDefinition)this.savedColors.get(original);
            original.setBlue(copy.getBlue());
            original.setRed(copy.getRed());
            original.setGreen(copy.getGreen());
            original.setTransparency(copy.getTransparency());
        }
        this.savedColors.clear();
        iter = this.savedLines.keySet().iterator();
        while (iter.hasNext()) {
            original = (LineAttributes)iter.next();
            copy = (LineAttributes)this.savedLines.get(original);
            original.setVisible(copy.isVisible());
        }
        this.savedLines.clear();
        iter = this.savedLabels.keySet().iterator();
        while (iter.hasNext()) {
            original = (Label)iter.next();
            copy = (Label)this.savedLabels.get(original);
            original.setVisible(copy.isVisible());
            original.getCaption().setFont(copy.getCaption().getFont());
        }
        this.savedLabels.clear();
    }

    public void setUpdateNotifier(IUpdateNotifier _iun) {
        this.iun = _iun;
    }

    public void reset() {
        this.iun = null;
        this.savedColors.clear();
        this.savedLabels.clear();
        this.savedLines.clear();
        this.targets.clear();
    }
}

